/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.providers;

import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.helpers.AnomalyHelper;
import fr.cnav.autocontrole.helpers.IndividualHelper;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.messageparser.IndividualInformationDescriptor;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.validator.autocontrol.registry.IIndividualFieldRegistry;
import java.util.List;

public class IndividualLabelProvider {
    private List<IIndividualFieldRegistry> individualFieldList;
    private IndividualInformationDescriptor individual;
    private Anomaly anomaly;

    public IndividualLabelProvider(Object anomalieElt) {
        if (IndividualHelper.isAnomaly(anomalieElt)) {
            this.anomaly = (Anomaly)anomalieElt;
            this.individual = AnomalyHelper.getIndividualFromAnomaly(this.anomaly);
            this.individualFieldList = StandardHelper.getInstance().getMessageDescriptor().getIndividualFields();
        }
    }

    public String getText(int index) throws AutoCtrlException {
        if (this.individualFieldList != null && this.individualFieldList.size() > index) {
            String individualValue = "";
            String individualValueFirstPart = AnomalyHelper.getIndividualValue(this.individual, this.individualFieldList.get(index).getFirstRubiqueFullQualifiedId());
            if (individualValueFirstPart != null) {
                individualValue = individualValueFirstPart;
            }
            if (this.individualFieldList.get(index).getSecondRubiqueFullQualifiedId() != null) {
                String individualValueSecondPart = AnomalyHelper.getIndividualValue(this.individual, this.individualFieldList.get(index).getSecondRubiqueFullQualifiedId());
                if (individualValueSecondPart == null) {
                    individualValueSecondPart = "";
                } else if (individualValueFirstPart != null) {
                    individualValue = String.valueOf(individualValue) + "/" + individualValueSecondPart;
                }
            }
            return individualValue;
        }
        return "";
    }

    public static String getTitle(int index) {
        List<IIndividualFieldRegistry> individualFieldList = StandardHelper.getInstance().getMessageDescriptor().getIndividualFields();
        if (individualFieldList != null && individualFieldList.size() > index) {
            return StandardHelper.getInstance().getMessageDescriptor().getIndividualFields().get(index).getLabel();
        }
        return null;
    }

    public IndividualInformationDescriptor getIndividual() {
        return this.individual;
    }

    public Object getNormeElt() {
        return MessageFile.getInstance().getAnomalyContextFromIndividualElt(this.anomaly, this.individual.getMessageBlock());
    }
}

