/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.declaration;

import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.api.model.access.ValueDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeclarationIdentifier {
    private final StandardDescription standard;
    private final Set<FieldDescription> primaryKeys;
    private Map<DeclarationDescription, Map<FieldDescription, List<ValueDescription>>> declarationToKeyValues;

    public DeclarationIdentifier(StandardAccessor modelAccessor) {
        this.standard = modelAccessor.getStandardDescription();
        this.createDeclarationToKeyValues();
        this.primaryKeys = new HashSet<FieldDescription>();
        for (DeclarationDescription declaration : this.standard.getDeclarations()) {
            this.primaryKeys.addAll(this.declarationToKeyValues.get(declaration).keySet());
        }
    }

    public Set<FieldDescription> getDeclarationPrimaryKeys() {
        return Collections.unmodifiableSet(this.primaryKeys);
    }

    public DeclarationDescription getDeclaration(Map<String, String> values) {
        for (DeclarationDescription declaration : this.standard.getDeclarations()) {
            if (!this.matchesValues(declaration, values)) continue;
            return declaration;
        }
        return null;
    }

    private boolean matchesValues(DeclarationDescription declaration, Map<String, String> values) {
        boolean matches = true;
        for (Map.Entry<String, String> entry : values.entrySet()) {
            FieldDescription keyField = null;
            for (Map.Entry<FieldDescription, List<ValueDescription>> fieldToValueMap : this.declarationToKeyValues.get(declaration).entrySet()) {
                if (!entry.getKey().equals(fieldToValueMap.getKey().getFullQualifiedId())) continue;
                keyField = fieldToValueMap.getKey();
                break;
            }
            if (keyField == null) {
                matches = false;
                break;
            }
            List<ValueDescription> declValues = this.declarationToKeyValues.get(declaration).get(keyField);
            boolean found = false;
            String value = entry.getValue();
            for (ValueDescription val : declValues) {
                if (!value.equals(val.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            matches = false;
            break;
        }
        return matches && values.size() == this.declarationToKeyValues.get(declaration).size();
    }

    private void createDeclarationToKeyValues() {
        this.declarationToKeyValues = new HashMap<DeclarationDescription, Map<FieldDescription, List<ValueDescription>>>();
        for (DeclarationDescription decl : this.standard.getDeclarations()) {
            HashMap keyFieldToValues = new HashMap();
            Set entrySet = decl.getKeyValues().entrySet();
            for (Map.Entry entry : entrySet) {
                ArrayList<ValueDescription> keyValues = new ArrayList<ValueDescription>();
                for (ValueDescription value : (List)entry.getValue()) {
                    keyValues.add(value);
                }
                keyFieldToValues.put((FieldDescription)entry.getKey(), keyValues);
            }
            this.declarationToKeyValues.put(decl, keyFieldToValues);
        }
    }

    public boolean isAPrimayKey(String fqi) {
        return this.getDeclarationPrimaryKeys().stream().map(fieldDesc -> fieldDesc.getFullQualifiedId()).anyMatch(fieldDescFqid -> fieldDescFqid.equals(fqi));
    }
}

