/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator;

import fr.cnav.saturne.ModelAccessorWithNomenclaturesHandling;
import fr.cnav.saturne.ModelLoader;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class InternalAbstractKbDescriptor {
    protected OptionMap options;
    private ModelAccessorWithNomenclaturesHandling modelAccessor;

    public InternalAbstractKbDescriptor(OptionMap optionMap) throws IOException, URISyntaxException {
        this.options = optionMap;
        ModelLoader modelLoader = new ModelLoader(this.getResourceURL(this.getStandardPath()));
        this.initModelAccessor(modelLoader);
    }

    public InternalAbstractKbDescriptor(ResourceSet rs, OptionMap optionMap) throws IOException, URISyntaxException {
        this.options = optionMap;
        ModelLoader modelLoader = new ModelLoader(rs, this.getResourceURL(this.getStandardPath()));
        this.initModelAccessor(modelLoader);
    }

    public InternalAbstractKbDescriptor() throws IOException, URISyntaxException {
        this.options = new OptionMap();
        ModelLoader modelLoader = new ModelLoader(this.getResourceURL(this.getStandardPath()));
        this.initModelAccessor(modelLoader);
    }

    public InternalAbstractKbDescriptor(ModelAccessorWithNomenclaturesHandling modelAccessor) {
        this.options = new OptionMap();
        this.modelAccessor = modelAccessor;
    }

    public InternalAbstractKbDescriptor(ResourceSet rs) throws IOException, URISyntaxException {
        this.options = new OptionMap();
        ModelLoader modelLoader = new ModelLoader(rs, this.getResourceURL(this.getStandardPath()));
        this.initModelAccessor(modelLoader);
    }

    private void initModelAccessor(ModelLoader modelLoader) throws IOException {
        Boolean initAccessorWithDesc = (Boolean)this.options.getOption(new Key("fr.cnav.saturne.kbdescriptor.init.modelaccessor.with.description"));
        this.modelAccessor = initAccessorWithDesc != null && initAccessorWithDesc != false ? new ModelAccessorWithNomenclaturesHandling(modelLoader.getStandard(), this.options, Logger.getAnonymousLogger(), this.getDatasourcePath(), (Object)this, true) : new ModelAccessorWithNomenclaturesHandling(modelLoader.getStandard(), this.options, Logger.getAnonymousLogger(), this.getDatasourcePath(), (Object)this);
    }

    public void initKBDescriptor(OptionMap option) {
    }

    public String getPackageName() {
        return String.valueOf(this.getKBBasePackage()) + "." + this.getModelAccessor().getStandard().getNamespacePrefix() + "..";
    }

    public abstract String getKBBasePackage();

    public abstract String getKBVariantName();

    public abstract String getStandardPath();

    public abstract List<String> getInputExtensions();

    public abstract String getDatasourcePath();

    public ModelAccessorWithNomenclaturesHandling getModelAccessor() {
        return this.modelAccessor;
    }

    public OptionMap getOptions() {
        return this.options;
    }

    public InputStream getResource(String resourceName) {
        IFile standardFile = (IFile)this.options.getOption(new Key("fr.cnav.saturne.kbdescriptor.init.workspace.norm.file"));
        if (standardFile != null) {
            IFile file = standardFile.getProject().getFile(resourceName);
            InputStream content = null;
            try {
                content = file.getContents();
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "The resource cannot be read. The standard will not be loaded", e);
            }
            return content;
        }
        return this.getClass().getClassLoader().getResourceAsStream(resourceName);
    }

    public URL getResourceURL(String resourceName) {
        IFile standardFile = (IFile)this.options.getOption(new Key("fr.cnav.saturne.kbdescriptor.init.workspace.norm.file"));
        if (standardFile != null) {
            String slash = "/";
            String projectPath = standardFile.getProject().getFullPath().toString();
            String normPath = standardFile.getFullPath().toString();
            normPath = normPath.substring(projectPath.length() + 1);
            normPath = normPath.substring(0, normPath.indexOf(slash));
            URI uri = URI.createPlatformResourceURI((String)(String.valueOf(standardFile.getProject().getName()) + slash + normPath + slash + resourceName), (boolean)true);
            URL url = null;
            try {
                url = new URL(uri.toString());
            }
            catch (MalformedURLException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "The URL of the resource cannot be computed. The standard will not be loaded", e);
            }
            return url;
        }
        return this.getClass().getClassLoader().getResource(resourceName);
    }

    public abstract ResourceBundle getResourceBundle();
}

