/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Standard;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;

public class StandardFileUtil {
    public IFile getStandardFile(Standard standard) throws ExecutionException {
        IFile standardFile = null;
        if (standard != null) {
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            URI modelUri = standard.eResource().getURI();
            String locationString = null;
            if (modelUri.isPlatform()) {
                locationString = modelUri.toString().substring("platform:/resource/".length());
            } else if (modelUri.isFile()) {
                locationString = modelUri.toString().replaceFirst("file:/?" + myWorkspaceRoot.getLocation().toString(), "");
            } else {
                throw new ExecutionException("Standard File model can not be load. The unloaded model Uri is " + modelUri.toString());
            }
            standardFile = (IFile)myWorkspaceRoot.findMember(locationString);
        }
        return standardFile;
    }
}

