/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Equiv;
import fr.cnav.saturne.dsl.formules.Imply;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.Notifier;

public class LogicalOperatorTypeAdapter
extends DSLTypeAdapter {
    @Override
    Type computeType(Type context, Map<String, Type> env) {
        Type result;
        Notifier target = this.getTarget();
        assert (target instanceof Binary && (target instanceof Equiv || target instanceof Imply));
        Binary expr = (Binary)target;
        DSLTypeAdapter leftAdapter = DSLTypeAdapterFactory.adapt(expr.getLeftOp());
        Type leftOpType = leftAdapter.getType(context, env);
        DSLTypeAdapter rightAdapter = DSLTypeAdapterFactory.adapt(expr.getRightOp());
        Type rightOpType = rightAdapter.getType(context, env);
        if (leftOpType != Type.BOOLEAN || rightOpType != Type.BOOLEAN) {
            this.setErrorMsg("N4DSType : Logical operator's operands must be of boolean type : " + (Object)((Object)leftOpType) + " and " + (Object)((Object)rightOpType));
            result = Type.UNDEFINED;
        } else {
            result = Type.BOOLEAN;
        }
        if (result == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }
}

