/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.doc;

import fr.cnav.presentation.PresentationPackage;
import fr.cnav.presentation.TreeBlock;
import fr.cnav.presentation.TreeDeclaration;
import fr.cnav.presentation.TreeMessage;
import fr.cnav.presentation.TreeNode;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class TreeCreator {
    public TreeDeclaration createTree(Declaration decl) {
        TreeDeclaration treeDeclaration = null;
        if (decl != null) {
            Standard standard = (Standard)decl.eContainer();
            DeclarationBlock declarationBlock = standard.getMessage().getHeaderBlock().getDeclarationBlock();
            treeDeclaration = (TreeDeclaration)EcoreUtil.create((EClass)PresentationPackage.Literals.TREE_DECLARATION);
            if (declarationBlock != null) {
                treeDeclaration.setName(decl.getName());
                treeDeclaration.setId(declarationBlock.getId());
                treeDeclaration.getChildren().addAll(this.extractChildrenDeclarationTreeBlocks(decl, declarationBlock));
                return treeDeclaration;
            }
        }
        return treeDeclaration;
    }

    public TreeMessage createTree(Message msg, EList<Declaration> retainedDeclarations) {
        Block footerBlock;
        TreeMessage treeMessage = (TreeMessage)EcoreUtil.create((EClass)PresentationPackage.Literals.TREE_MESSAGE);
        if (msg == null) {
            return treeMessage;
        }
        treeMessage.setName(msg.getName());
        treeMessage.setId(msg.getId());
        HeaderBlock headerBlock = msg.getHeaderBlock();
        if (headerBlock != null) {
            Standard standard = (Standard)msg.eContainer();
            TreeBlock treeHeaderBlock = this.createFromBlock(headerBlock);
            treeHeaderBlock.getChildren().addAll(this.extractChildrenTreeBlocks(headerBlock));
            DeclarationBlock declarationBlock = standard.getMessage().getHeaderBlock().getDeclarationBlock();
            for (Declaration declaration : retainedDeclarations) {
                TreeDeclaration treeDeclaration = (TreeDeclaration)EcoreUtil.create((EClass)PresentationPackage.Literals.TREE_DECLARATION);
                treeDeclaration.setName(declaration.getName());
                treeDeclaration.setId(declarationBlock.getId());
                treeHeaderBlock.getChildren().add((Object)treeDeclaration);
            }
            treeMessage.getChildren().add((Object)treeHeaderBlock);
        }
        if ((footerBlock = msg.getFooterBlock()) != null) {
            TreeBlock treeFooterBlock = this.createFromBlock(footerBlock);
            treeFooterBlock.getChildren().addAll(this.extractChildrenTreeBlocks(footerBlock));
            treeMessage.getChildren().add((Object)treeFooterBlock);
        }
        return treeMessage;
    }

    private List<TreeNode> extractChildrenTreeBlocks(Block parentBlock) {
        ArrayList<TreeNode> childrenTreeNode = new ArrayList<TreeNode>();
        for (Block childBlock : parentBlock.getChildrenBlocks()) {
            if (childBlock instanceof DeclarationBlock) continue;
            TreeBlock treeBlock = this.createFromBlock(childBlock);
            if (childBlock.getChildrenBlocks().size() > 0) {
                treeBlock.getChildren().addAll(this.extractChildrenTreeBlocks(childBlock));
            }
            childrenTreeNode.add(treeBlock);
        }
        return childrenTreeNode;
    }

    private List<TreeNode> extractChildrenDeclarationTreeBlocks(Declaration decl, Block parentBlock) {
        ArrayList<TreeNode> childrenTreeNode = new ArrayList<TreeNode>();
        for (Block childBlock : parentBlock.getChildrenBlocks()) {
            if (childBlock.getUsage().equals((Object)UsageType.FORBIDDEN) || decl.getBlockUpperBound(childBlock) == 0) continue;
            TreeBlock treeBlock = this.createFromBlock(childBlock);
            treeBlock.setLowerBound(decl.getBlockLowerBound(childBlock));
            treeBlock.setUpperBound(decl.getBlockUpperBound(childBlock));
            if (childBlock.getChildrenBlocks().size() > 0) {
                treeBlock.getChildren().addAll(this.extractChildrenDeclarationTreeBlocks(decl, childBlock));
            }
            childrenTreeNode.add(treeBlock);
        }
        return childrenTreeNode;
    }

    private TreeBlock createFromBlock(Block block) {
        TreeBlock treeHeaderBlock = (TreeBlock)EcoreUtil.create((EClass)PresentationPackage.Literals.TREE_BLOCK);
        treeHeaderBlock.setName(block.getName());
        treeHeaderBlock.setId(block.getId());
        treeHeaderBlock.setLowerBound(block.getLowerBound());
        treeHeaderBlock.setUpperBound(block.getUpperBound());
        return treeHeaderBlock;
    }
}

