/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum NatureType implements Enumerator
{
    ALPHANUMERIC(1, "Alphanumeric", "Alphanumeric"),
    NUMERIC(2, "Numeric", "Numeric"),
    DATE(3, "Date", "Date"),
    ENUMERATION(4, "Enumeration", "Enumeration"),
    EXTERNAL_REFERENTIAL(5, "ExternalReferential", "ExternalReferential");

    public static final int ALPHANUMERIC_VALUE = 1;
    public static final int NUMERIC_VALUE = 2;
    public static final int DATE_VALUE = 3;
    public static final int ENUMERATION_VALUE = 4;
    public static final int EXTERNAL_REFERENTIAL_VALUE = 5;
    private static final NatureType[] VALUES_ARRAY;
    public static final List<NatureType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new NatureType[]{ALPHANUMERIC, NUMERIC, DATE, ENUMERATION, EXTERNAL_REFERENTIAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static NatureType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NatureType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NatureType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            NatureType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static NatureType get(int value) {
        switch (value) {
            case 1: {
                return ALPHANUMERIC;
            }
            case 2: {
                return NUMERIC;
            }
            case 3: {
                return DATE;
            }
            case 4: {
                return ENUMERATION;
            }
            case 5: {
                return EXTERNAL_REFERENTIAL;
            }
        }
        return null;
    }

    private NatureType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

