/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui;

import fr.cnav.autocontrol.rcp.ApplicationWorkbenchWindowAdvisor;
import fr.cnav.autocontrole.INormSelector;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.normselector.NormSelectorImpl;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.perspective.AutocontrolePerspective;
import fr.cnav.saturne.validator.registry.NormRegistryException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AutocontrolUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "fr.cnav.autocontrole.ui";
    private static AutocontrolUiPlugin plugin;
    public static final String VALIDATOR_VERSION = "1.6.10";
    private String standardDescription;
    private String standardVersion;
    private String standardApplicationName;
    private String normToUseForNextSession;

    public String getStandardDescription() {
        return this.standardDescription;
    }

    public String getStandardVersion() {
        return this.standardVersion;
    }

    public String getStandardApplicationName() {
        return this.standardApplicationName;
    }

    public static AutocontrolUiPlugin getPlugin() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        block7: {
            super.start(context);
            plugin = this;
            try {
                String normUsedId = "";
                if (normUsedId == null || "".equals(normUsedId)) {
                    normUsedId = System.getProperty("fr.cnav.autocontrole.defaultnorm.id");
                }
                try {
                    NormSelectorImpl normSelector = new NormSelectorImpl();
                    if (normSelector.isEmpty()) {
                        ApplicationWorkbenchWindowAdvisor.setTitleWithNoValidNorms((String)Messages.NoNormAvailable, (String)VALIDATOR_VERSION);
                        break block7;
                    }
                    normSelector.setSelectedNorm(normUsedId);
                    StandardHelper.createNewStandardHelper((INormSelector)normSelector);
                    StandardHelper.getInstance().initializeClasses();
                    if (StandardHelper.getInstance().getNormDescriptor() == null || StandardHelper.getInstance().getNormDescriptor().getStandardAccessor() == null || StandardHelper.getInstance().getNormDescriptor().getStandardAccessor().getStandard() == null) {
                        throw new AutoCtrlException(ExceptionKind.ERROR_CANNOT_RETRIEVE_BUNDLE);
                    }
                    this.standardDescription = StandardHelper.getInstance().getNormDescriptor().getStandardAccessor().getStandard().getDescription();
                    this.standardVersion = VALIDATOR_VERSION;
                    this.standardApplicationName = StandardHelper.getInstance().getApplicationLabel();
                    AutocontrolePerspective.setTitle();
                }
                catch (NormRegistryException e) {
                    AutocontrolUiPlugin.log((IStatus)new Status(2, PLUGIN_ID, e.getCode(), e.getMessage(), (Throwable)e));
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String errorMessage = e.getMessage();
                            if (e.getCause() != null && e.getCause().getMessage() != null) {
                                errorMessage = String.valueOf(errorMessage) + "\n Cause : " + e.getCause().getMessage();
                            }
                            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause().getMessage() != null) {
                                errorMessage = String.valueOf(errorMessage) + "\n Cause : " + e.getCause().getCause().getMessage();
                            }
                            if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause().getCause() != null && e.getCause().getCause().getCause().getMessage() != null) {
                                errorMessage = String.valueOf(errorMessage) + "\n Cause : " + e.getCause().getCause().getCause().getMessage();
                            }
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.NormInitProblemHeader, (String)(String.valueOf(Messages.NormInitProblem) + "\n" + errorMessage));
                        }
                    });
                }
            }
            catch (Throwable t) {
                AutocontrolUiPlugin.log((IStatus)new Status(2, PLUGIN_ID, Messages.NormInitProblemHeader, t));
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.NormInitProblemHeader, (String)(String.valueOf(Messages.NormInitProblem) + "\n" + t.getMessage()));
                    }
                });
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AutocontrolUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AutocontrolUiPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String key) {
        Image image = JFaceResources.getImage((String)key);
        if (image == null) {
            ImageDescriptor imageDescriptor = AutocontrolUiPlugin.getImageDescriptor(key);
            JFaceResources.getImageRegistry().put(key, imageDescriptor.createImage());
            image = JFaceResources.getImage((String)key);
        }
        return image;
    }

    public static void log(IStatus status) {
        if (AutocontrolUiPlugin.getPlugin() != null && AutocontrolUiPlugin.getPlugin().getLog() != null && status != null) {
            AutocontrolUiPlugin.getPlugin().getLog().log(status);
        } else if (AutocontrolUiPlugin.getPlugin() != null && AutocontrolUiPlugin.getPlugin().getLog() != null) {
            System.err.println(status.getMessage());
            status.getException().printStackTrace();
        }
    }

    public String getNormToUseForNextSession() {
        return this.normToUseForNextSession;
    }

    public void setNormToUseForNextSession(String normToUseForNextSession) {
        this.normToUseForNextSession = normToUseForNextSession;
    }
}

