/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Csl03SyntaxControl
extends AbstractFieldSyntaxControl {
    private final String regexp;
    private final int miniLengthLimit;
    private final int maxLengthLimit;
    private final String fullQualifiedId;

    public Csl03SyntaxControl(int id, String code, FieldDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        this.fullQualifiedId = target.getFullQualifiedId();
        this.regexp = target.getDataType().getRegexp();
        this.miniLengthLimit = target.getDataType().getMinLength();
        this.maxLengthLimit = target.getDataType().getMaxLength();
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        IRuleResult result = IRule.SUCCESS;
        if (subject == null) {
            result = IRule.SUCCESS;
        }
        if (subject instanceof IMessageFieldDate) {
            String value = ((IMessageFieldDate)subject).getOriginalValue();
            if (value == null) {
                result = IRule.SUCCESS;
            } else {
                boolean miniLengthViolation = false;
                boolean maxLengthViolation = false;
                int valueLength = value.length();
                if (valueLength < this.miniLengthLimit) {
                    miniLengthViolation = true;
                } else if (valueLength > this.maxLengthLimit) {
                    maxLengthViolation = true;
                }
                Pattern regexpPattern = Pattern.compile(this.regexp);
                Matcher valueMatcher = regexpPattern.matcher(value);
                boolean matches = valueMatcher.matches();
                if (!matches || miniLengthViolation || maxLengthViolation) {
                    String message = this.controlMessage.getMessage("syntactic.messages.CSL03_DATE", new Object[]{this.fullQualifiedId});
                    result = new RuleFailure(this, subject, subject.getParent(), message);
                }
            }
        }
        return result;
    }
}

