/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.ForeignKeyBindingDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.dsl.requestor.StandardNavigationException;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.MessageNavigator;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageElement;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.List;

public class Cce01SyntaxControl
extends AbstractFieldSyntaxControl {
    StandardAccessor modelAccessor;
    ForeignKeyBindingDescription binding;

    public Cce01SyntaxControl(int id, String code, FieldDescription target, ControlMessages controlMessage, DeclarationDescription declaration, StandardAccessor modelAccessor, ForeignKeyBindingDescription binding) {
        super(id, code, target, controlMessage, declaration);
        this.modelAccessor = modelAccessor;
        this.binding = binding;
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        RuleFailure resultFailure;
        String message;
        String value;
        String subjectFQN;
        MessageNavigator messageNavigator = new MessageNavigator(this.modelAccessor);
        IMessageBlock parent = subject.getParent();
        int numberOfMatches = 0;
        try {
            List<IMessageElement> foreignBlocks = messageNavigator.getTargetMessages(parent, this.binding.getForeignBlockId());
            for (IMessageElement targetElement : foreignBlocks) {
                if (!(targetElement instanceof IMessageBlock)) continue;
                for (IMessageField<?> field : ((IMessageBlock)targetElement).getFields()) {
                    if (!this.binding.getForeignFieldId().equals(field.getStandardFieldDescription().getFullQualifiedId()) || !subject.getValue().equals(field.getValue())) continue;
                    ++numberOfMatches;
                }
            }
        }
        catch (StandardNavigationException e) {
            e.printStackTrace();
        }
        IRuleResult result = IRule.SUCCESS;
        if (this.binding.isMultiple() && numberOfMatches == 0) {
            subjectFQN = subject.getStandardFieldDescription().getFullQualifiedId();
            value = subject.getValue().toString();
            message = this.controlMessage.getMessage("syntactic.messages.CCE01", new Object[]{subjectFQN, this.binding.getForeignBlockId(), this.binding.getForeignFieldId(), value});
            resultFailure = new RuleFailure(this, subject, subject.getParent(), message);
            result = resultFailure;
        } else if (!this.binding.isMultiple() && numberOfMatches == 0) {
            subjectFQN = subject.getStandardFieldDescription().getFullQualifiedId();
            value = subject.getValue().toString();
            message = this.controlMessage.getMessage("syntactic.messages.CCE02", new Object[]{subjectFQN, this.binding.getForeignBlockId(), this.binding.getForeignFieldId(), value});
            resultFailure = new RuleFailure(this, subject, subject.getParent(), message);
            result = resultFailure;
        } else if (!this.binding.isMultiple() && numberOfMatches > 1) {
            subjectFQN = subject.getStandardFieldDescription().getFullQualifiedId();
            value = subject.getValue().toString();
            message = this.controlMessage.getMessage("syntactic.messages.CCE03", new Object[]{subjectFQN, this.binding.getForeignBlockId(), this.binding.getForeignFieldId(), numberOfMatches, value});
            resultFailure = new RuleFailure(this, subject, subject.getParent(), message);
            result = resultFailure;
        }
        return result;
    }
}

