/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv.exporter;

import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.PositionalPackage;
import fr.cnav.saturne.validator.positional.RecordSpecification;
import fr.cnav.saturne.validator.positional.csv.DefaultCSVParameters;
import fr.cnav.saturne.validator.positional.csv.ICSVParameters;
import fr.cnav.saturne.validator.positional.csv.importer.PositionalFixModelCSVMapping;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;

public class PositionalCSVExporter {
    private static final String CSV_NEW_LINE = "\n";
    private static final String THE_FIELDS_MAPPING_IS_UNDEFINED = "The fields mapping is undefined.";
    private PositionalFixModelCSVMapping mapping;
    private FormatSpecification positionalFixModel;
    private ICSVParameters parameters;
    private List<EAttribute> eAttributes;

    public PositionalCSVExporter(FormatSpecification positionalModel, ICSVParameters icvsParameters) {
        if (positionalModel == null) {
            throw new IllegalArgumentException("The PositionalModel must not be null.");
        }
        this.positionalFixModel = positionalModel;
        this.parameters = icvsParameters == null ? new DefaultCSVParameters() : icvsParameters;
    }

    public File export(URI outputFileURI) throws IOException {
        Collection<FieldSpecification> fieldSpecifications = this.getPositionalElements();
        if (outputFileURI == null) {
            throw new IllegalArgumentException("The filePath must not be null.");
        }
        String fileName = outputFileURI.getPath();
        File file = new File(fileName);
        if (file.isDirectory()) {
            throw new RuntimeException("The target file URI has to be a regular file");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.parameters.getEncoding()));
        if (this.parameters.hasTitleLine()) {
            writer.write(this.formatTitleLine());
        }
        for (FieldSpecification fieldSpecification : fieldSpecifications) {
            writer.write(this.formatBodyLine(fieldSpecification));
        }
        writer.close();
        return file;
    }

    private String formatTitleLine() {
        StringBuilder output = new StringBuilder();
        Iterator<String> it = this.title().iterator();
        while (it.hasNext()) {
            String part = it.next();
            output.append(this.parameters.getColumnDelimiter());
            output.append(part.replaceAll(this.parameters.getQuotedColumnDelimiter(), this.parameters.getDoubledColumnDelimiter()));
            output.append(this.parameters.getColumnDelimiter());
            if (!it.hasNext()) continue;
            output.append(this.parameters.getColumnSeparator());
        }
        output.append(CSV_NEW_LINE);
        return output.toString();
    }

    private String formatBodyLine(FieldSpecification fieldSpecification) {
        StringBuilder output = new StringBuilder();
        Iterator<String> it = this.bodyLine(fieldSpecification).iterator();
        while (it.hasNext()) {
            String part = it.next();
            output.append(this.parameters.getColumnDelimiter());
            if (part != null) {
                output.append(part.replaceAll(this.parameters.getQuotedColumnDelimiter(), this.parameters.getDoubledColumnDelimiter()));
            }
            output.append(this.parameters.getColumnDelimiter());
            if (!it.hasNext()) continue;
            output.append(this.parameters.getColumnSeparator());
        }
        output.append(CSV_NEW_LINE);
        return output.toString();
    }

    private Collection<FieldSpecification> getPositionalElements() {
        BasicEList fieldsList = new BasicEList();
        EList<RecordSpecification> records = this.positionalFixModel.getRecords();
        for (RecordSpecification recordSpecification : records) {
            fieldsList.addAll(recordSpecification.getFields());
        }
        return fieldsList;
    }

    private List<String> title() {
        this.mapping = new PositionalFixModelCSVMapping(false, this.positionalFixModel, null, this.positionalFixModel.getStandard());
        return PositionalFixModelCSVMapping.TITLES;
    }

    private List<String> bodyLine(FieldSpecification fieldSpecification) {
        if (this.mapping == null) {
            throw new IllegalStateException(THE_FIELDS_MAPPING_IS_UNDEFINED);
        }
        return this.mapping.getLine(fieldSpecification);
    }

    List<EAttribute> getEAttributes() {
        if (this.eAttributes == null) {
            this.eAttributes = new ArrayList<EAttribute>();
            this.eAttributes.addAll((Collection<EAttribute>)PositionalPackage.Literals.FIELD_SPECIFICATION.getEAllAttributes());
        }
        return this.eAttributes;
    }
}

