/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.IFieldLocalizer;
import fr.cnav.saturne.validator.message.MessageElement;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.util.Collection;

public abstract class MessageField<C extends Comparable<C>>
extends MessageElement
implements IMessageField<C> {
    protected final C value;
    protected String originalValue;
    private final FieldDescription fieldDescription;
    private final int index;
    private IFieldLocalizer fieldLocalizer;

    public MessageField(IMessageBlock parent, FieldDescription field, C value, String originalValueAsString, int index, IFieldLocalizer fieldLocalizer) {
        super(parent);
        this.fieldDescription = field;
        this.value = value;
        this.index = index;
        this.fieldLocalizer = fieldLocalizer;
        this.originalValue = originalValueAsString;
    }

    @Override
    public FieldDescription getStandardFieldDescription() {
        return this.fieldDescription;
    }

    @Override
    public C getValue() {
        return this.value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getOriginalValueAsString() {
        return this.originalValue;
    }

    @Override
    public IFieldLocalizer getFieldLocalizer() {
        return this.fieldLocalizer;
    }

    @Override
    public abstract String getValueAsString();

    @Override
    public boolean eq(IMessageField<C> val) {
        return val == null ? false : this.eq(val.getValue());
    }

    @Override
    public boolean neq(IMessageField<C> val) {
        return val == null ? false : this.neq(val.getValue());
    }

    @Override
    public boolean lt(IMessageField<C> val) {
        return val == null ? false : this.lt(val.getValue());
    }

    @Override
    public boolean le(IMessageField<C> val) {
        return val == null ? false : this.le(val.getValue());
    }

    @Override
    public boolean gt(IMessageField<C> val) {
        return val == null ? false : this.gt(val.getValue());
    }

    @Override
    public boolean ge(IMessageField<C> val) {
        return val == null ? false : this.ge(val.getValue());
    }

    @Override
    public boolean eq(C val) {
        return val == null ? false : val.equals(this.value);
    }

    @Override
    public boolean neq(C val) {
        return val == null ? false : !val.equals(this.value);
    }

    @Override
    public boolean lt(C val) {
        return val == null ? false : val.compareTo(this.value) > 0;
    }

    @Override
    public boolean le(C val) {
        return val == null ? false : val.compareTo(this.value) >= 0;
    }

    @Override
    public boolean gt(C val) {
        return val == null ? false : val.compareTo(this.value) < 0;
    }

    @Override
    public boolean ge(C val) {
        return val == null ? false : val.compareTo(this.value) <= 0;
    }

    @Override
    public boolean in(Collection<?> values) {
        return values == null ? false : values.contains(this.value);
    }

    public String toString() {
        return "MessageField [standardElement=" + this.fieldDescription.getFullQualifiedId() + "(" + this.fieldLocalizer.getLineNumber() + ")]";
    }
}

