/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.runtime;

import fr.cnav.saturne.ExternalFunctionDefinition;
import fr.cnav.saturne.RulesConfiguration;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.dsl.runtime.Description;
import fr.cnav.saturne.validator.utils.BuiltInHelper;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class BuiltinFunctionsExtractor {
    private static final String PARAMS_SEPARATOR = ",";
    private static final String RETURN_SEPARATOR = ":";
    private static final String ALPHANUM_STRING = "alphanum";
    private static final String NUM_STRING = "num";
    private static final String DATE_STRING = "date";
    private static final String BOOLEAN_STRING = "bool";
    private static final String NODE_STRING = "node";
    private RulesConfiguration ruleConfig;
    private List<ExternalFunctionDefinition> definitionsToAdd = new ArrayList<ExternalFunctionDefinition>();
    private List<Method> notAddedFunctions = new ArrayList<Method>();

    public BuiltinFunctionsExtractor(RulesConfiguration ruleConfig) {
        if (ruleConfig == null) {
            throw new IllegalArgumentException("The external functions set cannot be null.");
        }
        this.ruleConfig = ruleConfig;
    }

    public List<ExternalFunctionDefinition> extractBuiltinFunctions(Class<?> containerClass) {
        Method[] builtinFunctions = this.getOrderedBuiltinFunctions(containerClass);
        EList existingDefinitions = this.ruleConfig.getExternalFunctions();
        Method[] methodArray = builtinFunctions;
        int n = builtinFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            Method builtinFunction = methodArray[n2];
            if (existingDefinitions.isEmpty() || !this.definitionsContainsFunction((List<ExternalFunctionDefinition>)existingDefinitions, builtinFunction)) {
                this.addDefinition(builtinFunction);
            }
            ++n2;
        }
        return this.definitionsToAdd;
    }

    public Method[] getOrderedBuiltinFunctions(Class<?> containerClass) {
        BuiltInHelper builtInHelper = new BuiltInHelper();
        Method[] builtinFunctions = builtInHelper.getOrderedBuiltinFunctions(containerClass);
        return builtinFunctions;
    }

    public List<ExternalFunctionDefinition> getDefinitionsToAdd() {
        return this.definitionsToAdd;
    }

    public List<Method> getNotAddedFunctions() {
        return this.notAddedFunctions;
    }

    private boolean definitionsContainsFunction(List<ExternalFunctionDefinition> existingDefinitions, Method builtinFunction) {
        ExternalFunctionDefinition existingBuiltinFunction = this.getBuitlintFunctionFromExternalFunction(existingDefinitions, builtinFunction);
        if (existingBuiltinFunction != null) {
            this.notAddedFunctions.add(builtinFunction);
            return true;
        }
        return false;
    }

    public ExternalFunctionDefinition getBuitlintFunctionFromExternalFunction(List<ExternalFunctionDefinition> existingDefinitions, Method builtinFunction) {
        String builtinFunctionSignature = this.getMethodSignature(builtinFunction);
        ExternalFunctionDefinition defTool = (ExternalFunctionDefinition)EcoreUtil.create((EClass)SaturnePackage.Literals.EXTERNAL_FUNCTION_DEFINITION);
        defTool.setSignature(builtinFunctionSignature);
        int builtinFunctionCadinality = defTool.getCardinality();
        for (ExternalFunctionDefinition existingDefinition : existingDefinitions) {
            if (existingDefinition.getName() == null || !existingDefinition.getName().equals(builtinFunction.getName()) || existingDefinition.getCardinality() != builtinFunctionCadinality || existingDefinition.getSignature() == null || !existingDefinition.getSignature().equals(builtinFunctionSignature)) continue;
            return existingDefinition;
        }
        return null;
    }

    private void addDefinition(Method builtinFunction) {
        ExternalFunctionDefinition externalFuncDef = this.extractExternalFunctionFromBuiltinFunction(builtinFunction);
        if (externalFuncDef != null) {
            this.definitionsToAdd.add(externalFuncDef);
        }
    }

    public ExternalFunctionDefinition extractExternalFunctionFromBuiltinFunction(Method builtinFunction) {
        Objects.requireNonNull(builtinFunction);
        Description description = builtinFunction.getAnnotation(Description.class);
        if (description != null) {
            ExternalFunctionDefinition definition = (ExternalFunctionDefinition)EcoreUtil.create((EClass)SaturnePackage.Literals.EXTERNAL_FUNCTION_DEFINITION);
            definition.setName(builtinFunction.getName());
            definition.setSpecification(description.description());
            definition.setComment(description.parameters());
            String signature = this.getMethodSignature(builtinFunction);
            definition.setSignature(signature);
            return definition;
        }
        return null;
    }

    private String getMethodSignature(Method builtinFunction) {
        Class<?>[] types;
        StringBuilder sb = new StringBuilder();
        Class<?>[] classArray = types = builtinFunction.getParameterTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            if (!this.isStandardAccessor(type)) {
                if (!sb.toString().isEmpty()) {
                    sb.append(PARAMS_SEPARATOR);
                }
                sb.append(this.getType(type));
            }
            ++n2;
        }
        Class<?> returnType = builtinFunction.getReturnType();
        sb.append(RETURN_SEPARATOR);
        sb.append(this.getType(returnType));
        return sb.toString();
    }

    private boolean isStandardAccessor(Class<?> clazz) {
        boolean result = false;
        if (clazz.isAssignableFrom(StandardAccessor.class)) {
            result = true;
        }
        return result;
    }

    private String getType(Class<?> clazz) {
        String result = clazz.isAssignableFrom(String.class) ? ALPHANUM_STRING : (clazz.isAssignableFrom(BigDecimal.class) || clazz.isAssignableFrom(Double.class) || clazz.isAssignableFrom(Integer.class) || "int".equals(clazz.getName()) ? NUM_STRING : (clazz.isAssignableFrom(Date.class) ? DATE_STRING : (clazz.isAssignableFrom(Boolean.class) || "boolean".equals(clazz.getName()) ? BOOLEAN_STRING : NODE_STRING)));
        return result;
    }
}

