/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.gen.DSLGeneratorContext;
import fr.cnav.saturne.dsl.parser.FormuleTraducteur;
import fr.cnav.saturne.dsl.parser.FormuleTraducteurException;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import fr.cnav.saturne.utils.RuleUtil;
import fr.cnav.saturne.utils.StandardUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class DslExpressionExtractor {
    public Expression extractDslExpressionFromDslString(Standard standard, String dslString, String fqidFieldSubject, String fqidBlockcontext) throws FormuleTraducteurException, ParserConfigurationException {
        Expression dslExpression = null;
        if (dslString != null && !dslString.isEmpty()) {
            FormuleTraducteur formuleTraducteur = new FormuleTraducteur(new StandardParserConfiguration(standard, Collections.emptyMap()));
            dslExpression = formuleTraducteur.processDSL(dslString, fqidFieldSubject, fqidBlockcontext);
        }
        return dslExpression;
    }

    public Expression extractDslExpressionFromRule(Standard standard, Rule dslRule) throws FormuleTraducteurException, ParserConfigurationException {
        Expression dslExpression = null;
        dslExpression = this.extractDslExpressionFromDslString(standard, dslRule.getDslExpression(), RuleUtil.getActualSubject(dslRule).getFullQualifiedId(), RuleUtil.getActualContext(dslRule).getFullQualifiedId());
        return dslExpression;
    }

    public Expression extractDslExpressionFromRule(Rule dslRule) throws FormuleTraducteurException, ParserConfigurationException {
        StandardUtil standardUtil = new StandardUtil();
        Standard standard = standardUtil.getStandard(dslRule);
        return this.extractDslExpressionFromRule(standard, dslRule);
    }

    public List<String> extractUsedMsgEltFromRule(Rule dslRule) throws FormuleTraducteurException, ParserConfigurationException {
        ArrayList<String> result = new ArrayList<String>();
        if (dslRule.getSubject() != null && dslRule.getSubject().getFullQualifiedId() != null && !dslRule.getSubject().getFullQualifiedId().isEmpty()) {
            result.add(dslRule.getSubject().getFullQualifiedId());
        }
        if (dslRule.getContext() != null && dslRule.getContext().getFullQualifiedId() != null && !dslRule.getContext().getFullQualifiedId().isEmpty()) {
            result.add(dslRule.getContext().getFullQualifiedId());
        }
        Expression expression = this.extractDslExpressionFromRule(dslRule);
        TreeIterator treeIterator = expression.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObj = (EObject)treeIterator.next();
            if (!(eObj instanceof FieldRef)) continue;
            result.add(((FieldRef)eObj).getName());
        }
        return result;
    }

    public List<MessageElement> extractUsedMsgEltFromRule(StandardAccessor stdAccessor, Rule dslRule) throws FormuleTraducteurException, ParserConfigurationException {
        List<String> resultString = this.extractUsedMsgEltFromRule(dslRule);
        ArrayList<MessageElement> result = new ArrayList<MessageElement>();
        for (String fqidElt : resultString) {
            Block block = stdAccessor.getBlock(fqidElt);
            if (block != null) {
                result.add(block);
                continue;
            }
            Field field = stdAccessor.getField(fqidElt);
            if (field == null) continue;
            result.add(field);
        }
        return result;
    }

    public Type getExpressionType(Standard standard, Expression dslExpression) throws ParserConfigurationException {
        Type expressionType = null;
        if (standard != null) {
            DSLGeneratorContext dSLGeneratorContext = DSLGeneratorContext.initDSLGeneratorContext(standard, new HashMap<String, String>(0));
            final IParserConfiguration configuration = dSLGeneratorContext.getConfiguration();
            ITypingEnvironment env = new ITypingEnvironment(){

                @Override
                public String getSignature(String functionName, int argCount) {
                    String key = String.valueOf(functionName) + "/" + argCount + ".prototype";
                    return configuration.getDefinition(key);
                }

                @Override
                public Type getNodeType(String nodeName) {
                    return configuration.getType(nodeName);
                }
            };
            if (dslExpression != null) {
                DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(dslExpression);
                adapter.setTypingEnvironment(env);
                expressionType = adapter.getType();
            }
        }
        return expressionType;
    }
}

