/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.CSVDataSource;
import fr.cnav.saturne.CSVExternalDataTable;
import fr.cnav.saturne.DataSource;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FilterType;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.SaturneFactory;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.ExternalDataTypeDescription;
import fr.cnav.saturne.utils.StandardUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class DataTypeUtil {
    public static final String DEFAULT_SL_DATA_SOURCE = "DefaultSLDataSource";
    private static final int MIN_LENGHT = 1;
    private static final int MAX_LENGTH = 20;
    private Map<DataType, List<Field>> mapDataTypeToFieldList;
    private StandardUtil standardUtil = new StandardUtil();
    private EContentAdapter dataType2FieldEContentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() != 9) {
                DataTypeUtil.this.updateCache(notification);
            }
        }
    };

    private void initMap(Standard standard) {
        this.mapDataTypeToFieldList = new HashMap<DataType, List<Field>>();
        this.adaptStandard(standard);
        TreeIterator iter = standard.getMessage().eAllContents();
        while (iter.hasNext()) {
            Field field;
            DataType dataType;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof Field) || (dataType = (field = (Field)eObject).getDataType()) == null) continue;
            if (this.mapDataTypeToFieldList.get(dataType) == null) {
                this.mapDataTypeToFieldList.put(dataType, new ArrayList());
            }
            List<Field> fields = this.mapDataTypeToFieldList.get(dataType);
            fields.add(field);
        }
    }

    public boolean hasFieldListWithDT(DataType dataType) {
        return this.getFieldListWithDT(dataType) != null && this.getFieldListWithDT(dataType).size() != 0;
    }

    public List<Field> getFieldListWithDT(DataType dataType) {
        if (this.mapDataTypeToFieldList == null) {
            Standard standard = this.standardUtil.getStandard(dataType);
            this.initMap(standard);
        }
        return this.mapDataTypeToFieldList.get(dataType);
    }

    public Field getFirstFieldWithDT(DataType dataType) {
        Field result = null;
        List<Field> fields = this.getFieldListWithDT(dataType);
        if (fields != null && !fields.isEmpty()) {
            result = fields.get(0);
        }
        return result;
    }

    private boolean adaptStandard(Standard standard) {
        boolean result = false;
        if (standard != null && !standard.eAdapters().contains((Object)this.dataType2FieldEContentAdapter)) {
            standard.eAdapters().add((Object)this.dataType2FieldEContentAdapter);
            result = true;
        }
        return result;
    }

    private void updateCache(Notification notification) {
        if (this.mapDataTypeToFieldList == null) {
            return;
        }
        if (notification.getNotifier() instanceof Block) {
            if (notification.getEventType() == 4) {
                this.updateMapWhenRemoveFieldInMap(notification);
            }
        } else if (notification.getNotifier() instanceof Field && notification.getEventType() == 1) {
            Field field = (Field)notification.getNotifier();
            this.updateMapWhenSetDataTypeToField(notification, field);
        }
    }

    private void updateMapWhenSetDataTypeToField(Notification notification, Field field) {
        if (notification.getFeatureID(Block.class) == 6) {
            if (notification.getOldValue() instanceof DataType) {
                DataType dataTypeOldValue = (DataType)notification.getOldValue();
                this.removeFieldToMap(field, dataTypeOldValue);
            }
            if (notification.getNewValue() instanceof DataType) {
                DataType dataTypeNewValue = (DataType)notification.getNewValue();
                List<Field> fields = null;
                if (!this.mapDataTypeToFieldList.containsKey(dataTypeNewValue)) {
                    this.mapDataTypeToFieldList.put(dataTypeNewValue, new ArrayList());
                }
                fields = this.mapDataTypeToFieldList.get(dataTypeNewValue);
                fields.add(field);
            }
        }
    }

    private void updateMapWhenRemoveFieldInMap(Notification notification) {
        if (notification.getFeatureID(Block.class) == 6 && notification.getOldValue() instanceof Field) {
            Field oldField = (Field)notification.getOldValue();
            DataType dataType = oldField.getDataType();
            this.removeFieldToMap(oldField, dataType);
        }
    }

    private void removeFieldToMap(Field field, DataType dataType) {
        if (dataType != null && this.mapDataTypeToFieldList.get(dataType) != null) {
            List<Field> fields = this.mapDataTypeToFieldList.get(dataType);
            fields.remove(field);
            if (fields.isEmpty()) {
                this.mapDataTypeToFieldList.remove(dataType);
            }
        }
    }

    public boolean hasAtLeastOneFieldWithDT(DataType dataType) {
        Standard standard = this.standardUtil.getStandard(dataType);
        if (this.hasAtLeastOneFieldWithDataType(standard.getMessage().getHeaderBlock(), dataType)) {
            return true;
        }
        return this.hasAtLeastOneFieldWithDataType(standard.getMessage().getFooterBlock(), dataType);
    }

    private boolean hasAtLeastOneFieldWithDataType(Block block, DataType dataType) {
        for (Field field : block.getChildrenFields()) {
            if (field.getDataType() != dataType) continue;
            return true;
        }
        for (Block nextBlock : block.getChildrenBlocks()) {
            if (!this.hasAtLeastOneFieldWithDataType(nextBlock, dataType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAtLeastOneKeyWithValue(Value value) {
        Standard standard = this.standardUtil.getStandard(value);
        for (Declaration declaration : standard.getDeclarations()) {
            EMap<Field, EList<Value>> keyValues = declaration.getKeyValues();
            if (keyValues.isEmpty()) continue;
            for (Map.Entry mapentry : keyValues.entrySet()) {
                EList values = (EList)mapentry.getValue();
                if (!values.contains((Object)value)) continue;
                return true;
            }
        }
        return false;
    }

    public DataType createAndAddDataType(Standard standard, String dataTypeId, NatureType natureType) {
        DataType newDataType = null;
        if (natureType == NatureType.ALPHANUMERIC) {
            newDataType = SaturneFactory.eINSTANCE.createAlphanumericDataType();
        } else if (natureType == NatureType.NUMERIC) {
            newDataType = SaturneFactory.eINSTANCE.createNumericDataType();
        } else if (natureType == NatureType.DATE) {
            newDataType = SaturneFactory.eINSTANCE.createDateDataType();
        } else if (natureType == NatureType.ENUMERATION) {
            newDataType = SaturneFactory.eINSTANCE.createEnumDataType();
        } else if (natureType == NatureType.EXTERNAL_REFERENTIAL) {
            newDataType = SaturneFactory.eINSTANCE.createExternalDataType();
        }
        if (newDataType != null) {
            newDataType.setId("New" + natureType.getLiteral() + dataTypeId);
            newDataType.setName("New" + natureType.getLiteral() + dataTypeId);
            newDataType.setDescription("New " + natureType.getLiteral() + dataTypeId + " Description");
            newDataType.setComment("New " + natureType.getLiteral() + dataTypeId + " Comment");
            newDataType.setNature(natureType);
            newDataType.setMinLength(1);
            newDataType.setMaxLength(20);
            standard.getDataTypes().getDatatypes().add((Object)newDataType);
        }
        return newDataType;
    }

    public boolean isFilteredValue(String value, ExternalDataType externalDataType) {
        FilterType filterType = externalDataType.getFilter();
        List<String> filterValues = externalDataType.getIncludeExcludeValues().stream().map(csvValue -> csvValue.getValue()).collect(Collectors.toList());
        return this.isFilteredValue(value, filterType, filterValues);
    }

    public boolean isFilteredValue(String value, DataTypeDescription dataType) {
        if (dataType instanceof ExternalDataTypeDescription) {
            ExternalDataTypeDescription externalDataType = (ExternalDataTypeDescription)dataType;
            FilterType filterType = externalDataType.getFilterType();
            List<String> filterValues = externalDataType.getIncludeExcludeValues();
            return this.isFilteredValue(value, filterType, filterValues);
        }
        return false;
    }

    private boolean isFilteredValue(String value, FilterType filterType, List<String> filterValues) {
        if (filterType == FilterType.EXCLUDE) {
            return filterValues.contains(value);
        }
        if (filterType == FilterType.INCLUDE) {
            return !filterValues.contains(value);
        }
        return false;
    }

    public Optional<DataSource> getDefaultSLDataSource(Standard standard) {
        Optional<DataSource> dataSourceTarget = Optional.empty();
        for (DataSource dataSource : standard.getDataSources().getDatasources()) {
            if (!DEFAULT_SL_DATA_SOURCE.equals(dataSource.getId())) continue;
            dataSourceTarget = Optional.of(dataSource);
        }
        return dataSourceTarget;
    }

    public Optional<DataSource> getNewDefaultSLDataSource() {
        CSVDataSource csvDataSource = SaturneFactory.eINSTANCE.createCSVDataSource();
        csvDataSource.setId(DEFAULT_SL_DATA_SOURCE);
        csvDataSource.setName(DEFAULT_SL_DATA_SOURCE);
        csvDataSource.setDescription("Description : DefaultSLDataSource");
        csvDataSource.setFilename("DefaultSLDataSource.csv");
        return Optional.of(csvDataSource);
    }

    public Optional<ExternalDataTable> getNewExternalDataTables(ExternalDataType externalDataType, Optional<DataSource> dataSource) {
        Optional<ExternalDataTable> externalDataTableTarget = Optional.empty();
        if (externalDataType.getExternalDataTables().isEmpty()) {
            CSVExternalDataTable csvExternalDataTable = SaturneFactory.eINSTANCE.createCSVExternalDataTable();
            if (dataSource.isPresent()) {
                csvExternalDataTable.setDataSource(dataSource.get());
            }
            csvExternalDataTable.setColumnId("1");
            return Optional.of(csvExternalDataTable);
        }
        return externalDataTableTarget;
    }
}

