/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.impl;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.Refinement;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.impl.FieldToValueMapImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class DeclarationImpl
extends MinimalEObjectImpl.Container
implements Declaration {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String COMMENT_EDEFAULT = null;
    protected String comment = COMMENT_EDEFAULT;
    protected EMap<Field, EList<Value>> keyValues;
    protected EList<Refinement> refinements;
    private List<Refinement> emptyRefinementStorage = new ArrayList<Refinement>();
    Map<Block, BlockRefinement> blockRefinements;
    Map<Field, FieldRefinement> fieldRefinements;

    protected DeclarationImpl() {
    }

    protected EClass eStaticClass() {
        return SaturnePackage.Literals.DECLARATION;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String newComment) {
        String oldComment = this.comment;
        this.comment = newComment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldComment, (Object)this.comment));
        }
    }

    @Override
    public EMap<Field, EList<Value>> getKeyValues() {
        if (this.keyValues == null) {
            this.keyValues = new EcoreEMap(SaturnePackage.Literals.FIELD_TO_VALUE_MAP, FieldToValueMapImpl.class, (InternalEObject)this, 3);
        }
        return this.keyValues;
    }

    @Override
    public EList<Refinement> getRefinements() {
        if (this.refinements == null) {
            this.refinements = new EObjectContainmentEList.Resolving(Refinement.class, (InternalEObject)this, 4);
            this.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == SaturnePackage.Literals.DECLARATION__REFINEMENTS) {
                        DeclarationImpl.this.fieldRefinements = null;
                        DeclarationImpl.this.blockRefinements = null;
                    }
                    super.notifyChanged(msg);
                }
            });
        }
        return this.refinements;
    }

    @Override
    public int getBlockLowerBound(Block block) {
        if (block == null) {
            throw new IllegalArgumentException();
        }
        if (this.getBlockRefinements().containsKey(block)) {
            BlockRefinement refinement = this.getBlockRefinements().get(block);
            if (refinement.getLowerBound() != null) {
                return refinement.getLowerBound().getNewBound();
            }
            return block.getLowerBound();
        }
        return block.getLowerBound();
    }

    @Override
    public int getBlockUpperBound(Block block) {
        if (block == null) {
            throw new IllegalArgumentException();
        }
        if (this.getBlockRefinements().containsKey(block)) {
            BlockRefinement refinement = this.getBlockRefinements().get(block);
            if (refinement.getUpperBound() != null) {
                return refinement.getUpperBound().getNewBound();
            }
            return block.getUpperBound();
        }
        return block.getUpperBound();
    }

    @Override
    public UsageType getUsage(MessageElement element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof Field && this.getFieldRefinements().containsKey(element)) {
            UsageType usage = this.getFieldRefinements().get(element).getUsage();
            if (UsageType.UNSET == usage) {
                return element.getUsage();
            }
            return usage;
        }
        if (element instanceof Block && this.getBlockRefinements().containsKey(element)) {
            UsageType usage = this.getBlockRefinements().get(element).getUsage();
            if (UsageType.UNSET == usage) {
                return element.getUsage();
            }
            return usage;
        }
        return element.getUsage();
    }

    @Override
    public Map<Block, BlockRefinement> getBlockRefinements() {
        if (this.blockRefinements == null) {
            this.blockRefinements = new LinkedHashMap<Block, BlockRefinement>();
            for (Refinement refinement : this.getRefinements()) {
                if (!(refinement instanceof BlockRefinement)) continue;
                Block block = ((BlockRefinement)refinement).getBlock();
                if (block != null) {
                    this.blockRefinements.put(block, (BlockRefinement)refinement);
                    continue;
                }
                this.emptyRefinementStorage.add(refinement);
            }
        }
        this.handleNullBlockRefinement();
        return this.blockRefinements;
    }

    @Override
    public Map<Field, FieldRefinement> getFieldRefinements() {
        if (this.fieldRefinements == null) {
            this.fieldRefinements = new LinkedHashMap<Field, FieldRefinement>();
            for (Refinement refinement : this.getRefinements()) {
                if (!(refinement instanceof FieldRefinement)) continue;
                Field field = ((FieldRefinement)refinement).getField();
                if (field != null) {
                    this.fieldRefinements.put(field, (FieldRefinement)refinement);
                    continue;
                }
                this.emptyRefinementStorage.add(refinement);
            }
        }
        this.handleNullFieldRefinement();
        return this.fieldRefinements;
    }

    private void handleNullFieldRefinement() {
        ArrayList<Refinement> tempList = new ArrayList<Refinement>(this.emptyRefinementStorage);
        for (Refinement refinement : tempList) {
            if (!(refinement instanceof FieldRefinement) || ((FieldRefinement)refinement).getField() == null) continue;
            this.fieldRefinements.put(((FieldRefinement)refinement).getField(), (FieldRefinement)refinement);
            this.emptyRefinementStorage.remove(refinement);
        }
    }

    private void handleNullBlockRefinement() {
        ArrayList<Refinement> tempList = new ArrayList<Refinement>(this.emptyRefinementStorage);
        for (Refinement refinement : tempList) {
            if (!(refinement instanceof BlockRefinement) || ((BlockRefinement)refinement).getBlock() == null) continue;
            this.blockRefinements.put(((BlockRefinement)refinement).getBlock(), (BlockRefinement)refinement);
            this.emptyRefinementStorage.remove(refinement);
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getKeyValues()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getRefinements()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getComment();
            }
            case 3: {
                if (coreType) {
                    return this.getKeyValues();
                }
                return this.getKeyValues().map();
            }
            case 4: {
                return this.getRefinements();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setDescription((String)newValue);
                return;
            }
            case 2: {
                this.setComment((String)newValue);
                return;
            }
            case 3: {
                ((EStructuralFeature.Setting)this.getKeyValues()).set(newValue);
                return;
            }
            case 4: {
                this.getRefinements().clear();
                this.getRefinements().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setComment(COMMENT_EDEFAULT);
                return;
            }
            case 3: {
                this.getKeyValues().clear();
                return;
            }
            case 4: {
                this.getRefinements().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 2: {
                return COMMENT_EDEFAULT == null ? this.comment != null : !COMMENT_EDEFAULT.equals(this.comment);
            }
            case 3: {
                return this.keyValues != null && !this.keyValues.isEmpty();
            }
            case 4: {
                return this.refinements != null && !this.refinements.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getBlockLowerBound((Block)arguments.get(0));
            }
            case 1: {
                return this.getBlockUpperBound((Block)arguments.get(0));
            }
            case 2: {
                return this.getUsage((MessageElement)arguments.get(0));
            }
            case 3: {
                return this.getBlockRefinements();
            }
            case 4: {
                return this.getFieldRefinements();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", description: ");
        result.append(this.description);
        result.append(", comment: ");
        result.append(this.comment);
        result.append(')');
        return result.toString();
    }
}

