/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Unary;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.metacontrol.TransformationException;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractTransformation
extends FormulesSwitch<Expression> {
    protected Throwable problem;

    public Expression transform(Expression expression, Standard standard) throws TransformationException {
        this.problem = null;
        Expression expr = (Expression)this.doSwitch(expression);
        if (this.problem != null) {
            throw new TransformationException("Some problem occur during DLS transformation", this.problem);
        }
        return expr;
    }

    @Override
    public Expression caseExpression(Expression object) {
        return object;
    }

    @Override
    public Expression caseBinary(Binary object) {
        object.setLeftOp((Expression)this.doSwitch(object.getLeftOp()));
        object.setRightOp((Expression)this.doSwitch(object.getRightOp()));
        return object;
    }

    @Override
    public Expression caseUnary(Unary object) {
        object.setOperand((Expression)this.doSwitch(object.getOperand()));
        return object;
    }

    @Override
    public Expression caseNary(Nary object) {
        ArrayList<Expression> arguments = new ArrayList<Expression>((Collection<Expression>)object.getOperands());
        object.getOperands().clear();
        for (Expression argument : arguments) {
            object.getOperands().add((Object)((Expression)this.doSwitch(argument)));
        }
        return object;
    }

    @Override
    public Expression caseFunctionCall(FunctionCall object) {
        ArrayList<Expression> arguments = new ArrayList<Expression>((Collection<Expression>)object.getArguments());
        object.getArguments().clear();
        for (Expression argument : arguments) {
            object.getArguments().add((Object)((Expression)this.doSwitch(argument)));
        }
        return object;
    }
}

