/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.CSVExternalDataTable;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.FilterType;
import fr.cnav.saturne.api.model.access.CSVExternalDataTableDescription;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.ExternalDataTableDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExternalDataTypeDescription
extends DataTypeDescription {
    private ExternalDataType externalDataType;
    private List<ExternalDataTableDescription> externalDataTables;

    public ExternalDataTypeDescription(ExternalDataType theDataType, StandardMapUtils standardMapUtils) {
        super(theDataType, standardMapUtils);
        this.externalDataType = theDataType;
        this.externalDataTables = new ArrayList<ExternalDataTableDescription>();
        for (ExternalDataTable extDataTable : this.externalDataType.getExternalDataTables()) {
            if (!(extDataTable instanceof CSVExternalDataTable)) continue;
            this.externalDataTables.add(new CSVExternalDataTableDescription((CSVExternalDataTable)extDataTable));
        }
    }

    public List<ExternalDataTableDescription> getExternalDataTables() {
        return this.externalDataTables;
    }

    public List<String> getIncludeExcludeValues() {
        List<String> filteredValues = this.externalDataType.getIncludeExcludeValues().stream().map(csvValue -> csvValue.getValue()).collect(Collectors.toList());
        return filteredValues;
    }

    public FilterType getFilterType() {
        return this.externalDataType.getFilter();
    }
}

