/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ControlType implements Enumerator
{
    CSL(0, "CSL", "CSL"),
    CCH(1, "CCH", "CCH"),
    CME(2, "CME", "CME"),
    CRE(3, "CRE", "CRE"),
    CID(4, "CID", "CID"),
    CST(5, "CST", "CST"),
    SIG(6, "SIG", "SIG"),
    CCR(7, "CCR", "CCR"),
    CAT(8, "CAT", "CAT");

    public static final int CSL_VALUE = 0;
    public static final int CCH_VALUE = 1;
    public static final int CME_VALUE = 2;
    public static final int CRE_VALUE = 3;
    public static final int CID_VALUE = 4;
    public static final int CST_VALUE = 5;
    public static final int SIG_VALUE = 6;
    public static final int CCR_VALUE = 7;
    public static final int CAT_VALUE = 8;
    private static final ControlType[] VALUES_ARRAY;
    public static final List<ControlType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ControlType[]{CSL, CCH, CME, CRE, CID, CST, SIG, CCR, CAT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ControlType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlType get(int value) {
        switch (value) {
            case 0: {
                return CSL;
            }
            case 1: {
                return CCH;
            }
            case 2: {
                return CME;
            }
            case 3: {
                return CRE;
            }
            case 4: {
                return CID;
            }
            case 5: {
                return CST;
            }
            case 6: {
                return SIG;
            }
            case 7: {
                return CCR;
            }
            case 8: {
                return CAT;
            }
        }
        return null;
    }

    private ControlType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

