/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.presentation.util;

import fr.cnav.saturne.AlphanumericDataType;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockContext;
import fr.cnav.saturne.CSVDataSource;
import fr.cnav.saturne.CSVExternalDataTable;
import fr.cnav.saturne.ControlType;
import fr.cnav.saturne.DataSource;
import fr.cnav.saturne.DataSourceSet;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.DataTypeSet;
import fr.cnav.saturne.DateDataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.ExternalFunctionDefinition;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldContext;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.Macro;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.NumericDataType;
import fr.cnav.saturne.ReportConfiguration;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.RuleSet;
import fr.cnav.saturne.RulesConfiguration;
import fr.cnav.saturne.SaturneFactory;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.dsl.runtime.BuiltinFunctions;
import fr.cnav.saturne.dsl.runtime.BuiltinFunctionsExtractor;
import fr.cnav.saturne.presentation.SaturneEditorPlugin;
import fr.cnav.saturne.presentation.util.SaturneModelWizardConfiguration;
import fr.cnav.saturne.utils.SaturneResourceUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class SaturneModelCreator {
    private static final String POSTFIX_DESCRIPTION = "Description : ";
    private static final SaturneFactory SATURNE_FACTORY = SaturneFactory.eINSTANCE;
    private static final int SEVEN = 7;
    private static final String ZERO_ZERO_ONE_STRING = "001";
    private static final String ZERO_ONE_STRING = "01";
    private static final int TWELVE = 12;
    private static final int TWENTY = 20;
    private boolean fullValidModelToGenerate;

    public Resource createSaturneModel(SaturneModelWizardConfiguration modelConfiguration) throws IOException, CoreException {
        IFile modelFile;
        this.fullValidModelToGenerate = modelConfiguration.isFullValidModelToGenerate();
        String projectName = modelConfiguration.getProjectName();
        String containerName = modelConfiguration.getContainerName();
        String modelName = modelConfiguration.getModelName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectName.equals(containerName)) {
            IFolder folder = project.getFolder(containerName);
            if (!folder.exists()) {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            modelFile = folder.getFile(modelName);
        } else {
            modelFile = project.getFile(modelName);
        }
        if (modelFile == null) {
            return null;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        URI dataTypesURI = URI.createPlatformResourceURI((String)new SaturneResourceUtil().createAuxiliaryResourceFile(modelFile.getFullPath().toString(), "DataTypes"), (boolean)true);
        Resource dataTypes = resourceSet.createResource(dataTypesURI);
        URI rulesURI = URI.createPlatformResourceURI((String)new SaturneResourceUtil().createAuxiliaryResourceFile(modelFile.getFullPath().toString(), "Rules"), (boolean)true);
        Resource rules = resourceSet.createResource(rulesURI);
        URI dataSourcesURI = URI.createPlatformResourceURI((String)new SaturneResourceUtil().createAuxiliaryResourceFile(modelFile.getFullPath().toString(), "DataSources"), (boolean)true);
        Resource dataSources = resourceSet.createResource(dataSourcesURI);
        Standard rootObject = this.createInitialModel(modelConfiguration.getSaturneFactory(), modelName);
        if (rootObject != null) {
            resource.getContents().add((Object)rootObject);
            dataTypes.getContents().add((Object)rootObject.getDataTypes());
            rules.getContents().add((Object)rootObject.getRules());
            dataSources.getContents().add((Object)rootObject.getDataSources());
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", modelConfiguration.getEncoding());
        resource.save(options);
        dataTypes.save(options);
        rules.save(options);
        dataSources.save(options);
        return resource;
    }

    private Standard createInitialModel(SaturneFactory saturneFactory, String modelName) {
        int lastIndexOf = modelName.lastIndexOf(SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneEditorFilenameExtensions"));
        String modelElementName = modelName.substring(0, lastIndexOf - 1);
        Standard rootObject = saturneFactory.createStandard();
        rootObject.setName(modelElementName);
        rootObject.setId(modelElementName.toUpperCase());
        rootObject.setDescription(POSTFIX_DESCRIPTION + modelElementName);
        rootObject.setLongName(modelElementName);
        rootObject.setVersion("P01V01");
        Date time = Calendar.getInstance().getTime();
        String timeStamp = new SimpleDateFormat("yyyyMMdd").format(time);
        rootObject.setRevision(timeStamp);
        rootObject.setNameSpace("https://myorg/" + modelElementName.toLowerCase() + "/1.0");
        rootObject.setNamespacePrefix(modelElementName.toLowerCase());
        rootObject.setAllowedBlockRegex(".*");
        rootObject.setAllowedFieldRegex(".*");
        rootObject.setDataTypes(saturneFactory.createDataTypeSet());
        rootObject.setRules(saturneFactory.createRuleSet());
        rootObject.setDataSources(saturneFactory.createDataSourceSet());
        rootObject.setReusedBlocks(saturneFactory.createReusedBlockSet());
        rootObject.setMessagesEncoding(StandardCharsets.UTF_8.name());
        RulesConfiguration rulesConfiguration = saturneFactory.createRulesConfiguration();
        BuiltinFunctionsExtractor builtinFunctionsExtractor = new BuiltinFunctionsExtractor(rulesConfiguration);
        List externalFunctionDefinitions = builtinFunctionsExtractor.extractBuiltinFunctions(BuiltinFunctions.class);
        if (this.fullValidModelToGenerate) {
            for (ExternalFunctionDefinition externalFunctionDefinition : externalFunctionDefinitions) {
                if (!externalFunctionDefinition.getName().equals("concat") && !externalFunctionDefinition.getName().equals("isPresent") && !externalFunctionDefinition.getName().equals("yearFromDate")) continue;
                externalFunctionDefinition.setDescription(POSTFIX_DESCRIPTION + externalFunctionDefinition.getName());
                rulesConfiguration.getExternalFunctions().add((Object)externalFunctionDefinition);
            }
        } else {
            rulesConfiguration.getExternalFunctions().addAll((Collection)externalFunctionDefinitions);
        }
        Macro annee = saturneFactory.createMacro();
        annee.setName("ANNEE_EN_COURS");
        annee.setDescription("Exemple de macro : constante");
        annee.setExpression(new SimpleDateFormat("yyyy").format(time));
        rulesConfiguration.getMacros().add((Object)annee);
        Macro datasource = saturneFactory.createMacro();
        datasource.setName("REF_DATASOURCE");
        datasource.setDescription("Exemple de r\u00e9f\u00e9rence sur une datasource\nSert de r\u00e9f\u00e9rence pour une utilisation dans un DSL");
        datasource.setExpression("'csv://DataSourceOne.csv#1'");
        rulesConfiguration.getMacros().add((Object)datasource);
        rootObject.setConfigurations(rulesConfiguration);
        RuleSet ruleSet = saturneFactory.createRuleSet();
        rootObject.setRules(ruleSet);
        DataSourceSet dataSourceSet = saturneFactory.createDataSourceSet();
        rootObject.setDataSources(dataSourceSet);
        DataTypeSet dataTypeSet = saturneFactory.createDataTypeSet();
        rootObject.setDataTypes(dataTypeSet);
        CSVDataSource csvDataSource = saturneFactory.createCSVDataSource();
        csvDataSource.setName("DataSourceOneCsv");
        csvDataSource.setDescription(POSTFIX_DESCRIPTION + csvDataSource.getName());
        csvDataSource.setId("DataSourceOneCsv");
        csvDataSource.setFilename("DataSourceOne.csv");
        csvDataSource.setColumnSeparator(";");
        csvDataSource.setTitleLineNumber(1);
        csvDataSource.setColumnId("1");
        dataSourceSet.getDatasources().add((Object)csvDataSource);
        EnumDataType enumDataType = saturneFactory.createEnumDataType();
        dataTypeSet.getDatatypes().add((Object)enumDataType);
        enumDataType.setId("Declaration_Nature");
        enumDataType.setName("Declaration_Nature");
        enumDataType.setDescription(POSTFIX_DESCRIPTION + enumDataType.getName());
        enumDataType.setMinLength(2);
        enumDataType.setMaxLength(2);
        Value value1 = saturneFactory.createValue();
        value1.setId(ZERO_ONE_STRING);
        String declaration1Name = "Declaration 1";
        value1.setName(declaration1Name);
        value1.setDescription(POSTFIX_DESCRIPTION + declaration1Name);
        enumDataType.getValues().add((Object)value1);
        Value value2 = saturneFactory.createValue();
        value2.setId("02");
        String declaration2Name = "Declaration 2";
        value2.setName(declaration2Name);
        value2.setDescription(POSTFIX_DESCRIPTION + declaration2Name);
        enumDataType.getValues().add((Object)value2);
        AlphanumericDataType alphanumericDataType = saturneFactory.createAlphanumericDataType();
        alphanumericDataType.setName("GenericAlpha_1-20");
        alphanumericDataType.setId("GenericAlpha_1-20");
        alphanumericDataType.setDescription(POSTFIX_DESCRIPTION + alphanumericDataType.getName());
        alphanumericDataType.setMinLength(1);
        alphanumericDataType.setMaxLength(20);
        dataTypeSet.getDatatypes().add((Object)alphanumericDataType);
        DateDataType dateDataType = saturneFactory.createDateDataType();
        dateDataType.setName("GenericXMLDate");
        dateDataType.setDescription(POSTFIX_DESCRIPTION + dateDataType.getName());
        dateDataType.setId("GenericXMLDate");
        dateDataType.setMinLength(10);
        dateDataType.setMaxLength(10);
        dateDataType.setRegexp("[0-9]{4}-[0-9]{2}-[0-9]{2}");
        dataTypeSet.getDatatypes().add((Object)dateDataType);
        NumericDataType numericDataType = saturneFactory.createNumericDataType();
        numericDataType.setName("Number_0-12");
        numericDataType.setDescription(POSTFIX_DESCRIPTION + numericDataType.getName());
        numericDataType.setId("Number_0-12");
        numericDataType.setMinLength(0);
        numericDataType.setMaxLength(12);
        numericDataType.setRegexp("[0]*[1-9][0-9]*");
        dataTypeSet.getDatatypes().add((Object)numericDataType);
        ExternalDataType externalDataType = saturneFactory.createExternalDataType();
        externalDataType.setName("DataSourceOne");
        externalDataType.setDescription(POSTFIX_DESCRIPTION + externalDataType.getName());
        externalDataType.setId("DataSourceOne");
        externalDataType.setMinLength(7);
        externalDataType.setMaxLength(7);
        CSVExternalDataTable csvExternalDataTable = saturneFactory.createCSVExternalDataTable();
        csvExternalDataTable.setDataSource((DataSource)csvDataSource);
        csvExternalDataTable.setColumnId("1");
        externalDataType.getExternalDataTables().add((Object)csvExternalDataTable);
        dataTypeSet.getDatatypes().add((Object)externalDataType);
        Message message = saturneFactory.createMessage();
        rootObject.setMessage(message);
        String messageName = String.valueOf(modelElementName) + "Msg";
        message.setName(messageName);
        message.setId(messageName.toUpperCase());
        message.setDescription(POSTFIX_DESCRIPTION + messageName);
        message.setUsage(UsageType.MANDATORY);
        HeaderBlock header = this.createHeaderBlock("ENVOI", "Envoi", 1, 1, UsageType.MANDATORY);
        message.setHeaderBlock(header);
        Field headerField = this.createField(ZERO_ZERO_ONE_STRING, "Identifiant Emetteur", UsageType.MANDATORY, (DataType)alphanumericDataType);
        header.getFields().add((Object)headerField);
        Block footer = this.createBlock("TOTAL", "Total de l'envoi", 1, 1, UsageType.MANDATORY);
        message.setFooterBlock(footer);
        Field footerField = this.createField("FIELDSNUMBER", "Nombre total de fields", UsageType.MANDATORY, (DataType)numericDataType);
        footer.getFields().add((Object)footerField);
        DeclarationBlock declarationBlock = this.createDeclarationBlock("DECLARATION", "Declaration", 1, -1, UsageType.MANDATORY);
        message.getHeaderBlock().setDeclarationBlock(declarationBlock);
        Field field = this.createField(ZERO_ZERO_ONE_STRING, "Nature de la declaration", UsageType.MANDATORY, (DataType)enumDataType);
        field.setDeclarationKey(true);
        declarationBlock.getFields().add((Object)field);
        Block internalBlock = this.createBlock("OBJET", "Objet metier", 1, -1, UsageType.MANDATORY);
        declarationBlock.getChildrenBlocks().add((Object)internalBlock);
        Field internalFieldID = this.createField(ZERO_ZERO_ONE_STRING, "Identifiant", UsageType.MANDATORY, (DataType)alphanumericDataType);
        internalBlock.getFields().add((Object)internalFieldID);
        Field internalFieldRef = this.createField("002", "Reference \u00e0 une datasource", UsageType.OPTIONAL, (DataType)externalDataType);
        internalBlock.getFields().add((Object)internalFieldRef);
        if (this.fullValidModelToGenerate) {
            Field internalFieldDate = this.createField("003", "Creation Date", UsageType.CONDITIONAL, (DataType)dateDataType);
            internalBlock.getFields().add((Object)internalFieldDate);
            Rule rule3 = saturneFactory.createRule();
            rule3.setName("OBJET.003/CCH-01");
            rule3.setDescription("Exemple de contr\u00f4le avec extraction de l'ann\u00e9e d'une date avec et comparason avec une valleurdec Macro.");
            rule3.setSubject(internalFieldDate);
            rule3.setMessage("L'ann\u00e9e de la date de cr\u00e9ation, si elle existe doit \u00eatre l'ann\u00e9e en cours.");
            rule3.setDslExpression("isPresent($rub) => yearFromDate($rub) = @ANNEE_EN_COURS");
            rule3.setType(ControlType.CCH);
            rule3.setCriticity(RuleCriticity.NOT_BLOCKING);
            rule3.setId(ZERO_ONE_STRING);
            ruleSet.getRules().add((Object)rule3);
        }
        Declaration declaration = saturneFactory.createDeclaration();
        rootObject.getDeclarations().add((Object)declaration);
        declaration.setName(declaration1Name);
        declaration.setDescription(POSTFIX_DESCRIPTION + declaration1Name);
        Map keyValues = declaration.getKeyValues().map();
        BasicEList values = new BasicEList();
        values.add((Object)value1);
        keyValues.put(field, values);
        Rule rule1 = saturneFactory.createRule();
        rule1.setName("OBJET.001/CCH-01");
        rule1.setDescription("Exemple de contr\u00f4le sur la pr\u00e9sence de rubrique.\nCe contr\u00f4le est \u00e9crit en DSL et utilise une fonction externe (Externale Function) d\u00e9clar\u00e9e dans la \"Rule Configuration\"");
        rule1.setSubject(internalFieldID);
        rule1.setMessage("La rubrique doit \u00eatre pr\u00e9sente");
        rule1.setDslExpression("isPresent($rub)");
        rule1.setType(ControlType.CCH);
        rule1.setCriticity(RuleCriticity.BLOCKING);
        rule1.setId(ZERO_ONE_STRING);
        ruleSet.getRules().add((Object)rule1);
        Rule rule2 = saturneFactory.createRule();
        rule2.setName("OBJET.002/CRE-01");
        rule2.setDescription("Exemple de contr\u00f4le sur la concat\u00e9nation de deux valeurs alphanum\u00e9rique qui doit \u00eatre diff\u00e9rent d'une constante enregistr\u00e9 dans la liste de Macros.\nCe contr\u00f4le est \u00e9crit en DSL et utilise une fonction externe (Externale Function) et une valleur Macro d\u00e9clar\u00e9s tous les deux dans la \"Rule Configuration\"");
        rule2.setSubject(internalFieldRef);
        rule2.setMessage("Valeur concat\u00e9n\u00e9e \u00e9gale \u00e0 la r\u00e9f\u00e9nrence de la premi\u00e8re colonne du dataSource");
        rule2.setDslExpression("concat($rub, ENVOI.001) != @REF_DATASOURCE");
        rule2.setType(ControlType.CRE);
        rule2.setCriticity(RuleCriticity.BLOCKING);
        rule2.setId(ZERO_ONE_STRING);
        ruleSet.getRules().add((Object)rule2);
        ReportConfiguration configuration = saturneFactory.createReportConfiguration();
        rootObject.setReportConfiguration(configuration);
        configuration.setName("Envoi");
        configuration.setBlock((Block)header);
        FieldContext fieldContext = saturneFactory.createFieldContext();
        fieldContext.setField(internalFieldID);
        fieldContext.setName("identifiant");
        configuration.getFieldContexts().add((Object)fieldContext);
        BlockContext blockContext = saturneFactory.createBlockContext();
        blockContext.setBlock(internalBlock);
        blockContext.setName("metier");
        blockContext.setStrictSelf(false);
        blockContext.setStrictSubContexts(false);
        blockContext.setUseAnomalyCounter(true);
        blockContext.setUseTotalAnomalyCounter(true);
        configuration.getBlockContexts().add((Object)blockContext);
        return rootObject;
    }

    private Field createField(String id, String name, UsageType usageType, DataType datatype) {
        Field internalFieldID = SATURNE_FACTORY.createField();
        internalFieldID.setId(id);
        internalFieldID.setName(name);
        internalFieldID.setDescription(POSTFIX_DESCRIPTION + name);
        internalFieldID.setUsage(usageType);
        internalFieldID.setDataType(datatype);
        return internalFieldID;
    }

    private Block createBlock(String id, String name, int upperBound, int lowerBound, UsageType usageType) {
        Block block = SATURNE_FACTORY.createBlock();
        this.setBlock(block, id, name, upperBound, lowerBound, usageType);
        return block;
    }

    private HeaderBlock createHeaderBlock(String id, String name, int lowerBound, int upperBound, UsageType usageType) {
        HeaderBlock block = SATURNE_FACTORY.createHeaderBlock();
        this.setBlock((Block)block, id, name, lowerBound, upperBound, usageType);
        return block;
    }

    private DeclarationBlock createDeclarationBlock(String id, String name, int lowerBound, int upperBound, UsageType usageType) {
        DeclarationBlock block = SATURNE_FACTORY.createDeclarationBlock();
        this.setBlock((Block)block, id, name, lowerBound, upperBound, usageType);
        return block;
    }

    private void setBlock(Block block, String id, String name, int lowerBound, int upperBound, UsageType usageType) {
        block.setId(id);
        block.setName(name);
        block.setDescription(POSTFIX_DESCRIPTION + name);
        block.setUpperBound(upperBound);
        block.setLowerBound(lowerBound);
        block.setUsage(usageType);
    }
}

