/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.syntax.Cst01SyntaxControl;
import fr.cnav.saturne.validator.syntax.Cst02ForbiddenChildrenSyntaxControl;
import fr.cnav.saturne.validator.syntax.Cst02SyntaxControl;
import fr.cnav.saturne.validator.syntax.Cst03SyntaxControl;
import fr.cnav.saturne.validator.syntax.Cst05SyntaxControl;
import fr.cnav.saturne.validator.syntax.Cst08SyntaxControl;
import fr.cnav.saturne.validator.syntax.SyntacticControlCode;

public class SyntaxCtrlBlockFactory {
    private final ControlMessages controlMessage;
    private StandardDescription standard;
    private MessageElementFactory messageElementFactory;

    public SyntaxCtrlBlockFactory(StandardDescription standard, ControlMessages controlMessage, MessageElementFactory messageElementFactory) {
        this.controlMessage = controlMessage;
        this.standard = standard;
        this.messageElementFactory = messageElementFactory;
    }

    public IRule getCST01Rule(int id, BlockDescription context, DeclarationDescription declaration) {
        Cst01SyntaxControl ruleCst01 = new Cst01SyntaxControl(id, SyntacticControlCode.CST_01.getCode(), context, this.controlMessage, declaration);
        return ruleCst01;
    }

    public IRule getCST02Rule(int id, BlockDescription context, DeclarationDescription declaration) {
        Cst02SyntaxControl ruleCst02 = new Cst02SyntaxControl(id, SyntacticControlCode.CST_02.getCode(), context, this.controlMessage, declaration);
        return ruleCst02;
    }

    public IRule getCST02ForbidenChildrenRule(int id, BlockDescription context, DeclarationDescription declaration) {
        return new Cst02ForbiddenChildrenSyntaxControl(id, SyntacticControlCode.CST_02.getCode(), context, this.controlMessage, declaration);
    }

    public IRule getCST03Rule(int id, BlockDescription context, FieldDescription field, DeclarationDescription declaration) {
        return new Cst03SyntaxControl(id, SyntacticControlCode.CST_03.getCode(), context, field, this.controlMessage, declaration, this.messageElementFactory);
    }

    public IRule getCST05Rule(int id, BlockDescription context, DeclarationDescription declaration) {
        return new Cst05SyntaxControl(id, SyntacticControlCode.CST_05.getCode(), context, this.controlMessage, declaration);
    }

    public IRule getCST08Rule(int id, BlockDescription context, DeclarationDescription declaration) {
        String fullQualifiedIdSubGroup = context.getFullQualifiedId();
        Cst08SyntaxControl ruleCst08 = new Cst08SyntaxControl(id, SyntacticControlCode.CST_08.getCode(), context, fullQualifiedIdSubGroup, this.standard, this.controlMessage, declaration);
        return ruleCst08;
    }

    public static enum CtrlSubGroupKind {
        CST_01(false),
        CST_02(false),
        CST_03(true),
        CST_05(true),
        CST_08(false);

        private boolean isFieldDependancy;

        private CtrlSubGroupKind(boolean isFieldDependency) {
            this.isFieldDependancy = isFieldDependency;
        }

        public boolean isRubDep() {
            return this.isFieldDependancy;
        }
    }
}

