/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.report.model.Report;
import fr.cnav.saturne.validator.IFieldLocalizer;
import fr.cnav.saturne.validator.SequentialLocalizer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.impl.LineAndColumnLocalizer;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.report.IReportConstants;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.report.impl.AnomalyBuckets;
import fr.cnav.saturne.validator.report.impl.ReportContextDescriptor;
import fr.cnav.saturne.validator.reportfilter.PrimaryAnomaliesScopesProvider;
import fr.cnav.saturne.validator.reportfilter.ReportFilteringOperation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;

public class GenericReportLogger
implements IReportLogger {
    protected AnomalyBuckets anomalyBuckets;
    protected boolean factorizationEnabled;
    private ReportContextDescriptor contextDescriptor;
    private final List<Context> contextList;
    private Stack<Context> notLeftContextStack;
    private int validationOperationNumber;
    private final Report report;
    private int nbLimitAnomalies = IReportConstants.UNLIMITED_ERRORS;
    private boolean limitExceeded;
    private Integer nbTotalAnomaliesLogged = 0;
    private int lastLineNumber;
    private final Stack<Boolean> contextSetStack;
    private IMessageBlock currentMessageBlockContext;
    private final boolean calculateContextsDuringParsing;
    private final Map<Integer, Context> lineNumberToContextMap;
    private Map<String, Integer> siblingsNumber;
    private final Map<String, String> calculatedContextAttributesMap;
    private OptionMap optionMap;
    private PrimaryAnomaliesScopesProvider primaryAnomaliesScopesProvider;
    private boolean doFilterSecondaryAnomalies = true;
    private Standard standard;
    private Properties controlsProperties;

    public GenericReportLogger(Standard theStandard, boolean calculateContextsDuringParsing, OptionMap optionsMap) {
        this.standard = theStandard;
        this.report = new Report(this.standard.getName(), this.standard.getVersion());
        this.validationOperationNumber = 0;
        this.lineNumberToContextMap = new HashMap<Integer, Context>();
        this.calculatedContextAttributesMap = new HashMap<String, String>();
        this.siblingsNumber = new HashMap<String, Integer>();
        this.contextList = new ArrayList<Context>();
        this.notLeftContextStack = new Stack();
        this.factorizationEnabled = false;
        this.lastLineNumber = 0;
        this.primaryAnomaliesScopesProvider = new PrimaryAnomaliesScopesProvider();
        this.contextSetStack = new Stack();
        this.calculateContextsDuringParsing = calculateContextsDuringParsing;
        this.optionMap = optionsMap == null ? new OptionMap() : optionsMap;
        Key factorizationKey = new Key("fr.cnav.norme.report.mutualisation.threshold");
        Integer factorizationValue = (Integer)this.optionMap.getOption(factorizationKey);
        this.updateOptions(factorizationKey, factorizationValue);
        Key maxErrorKey = new Key("maximal.number.errors");
        Integer maxErrorValue = (Integer)this.optionMap.getOption(maxErrorKey);
        this.updateOptions(maxErrorKey, maxErrorValue);
        Key filtersSecondaryAnomalies = new Key("fr.cnav.norme.val.anomaliesInhibiting");
        Boolean doFiltersSecondaryAnomalies = (Boolean)this.optionMap.getOption(filtersSecondaryAnomalies);
        this.updateOptions(filtersSecondaryAnomalies, doFiltersSecondaryAnomalies);
        Key controlsOverrideKey = new Key("fr.cnav.saturne.rules.properties");
        this.controlsProperties = (Properties)this.optionMap.getOption(controlsOverrideKey);
        this.initReportContextDescriptor(new ReportContextDescriptor(this.standard));
    }

    private <T> void updateOptions(Key<T> key, T value) {
        if ("fr.cnav.norme.report.mutualisation.threshold" == key.getKeyValue() && value instanceof Integer) {
            this.setAnomalyFactorization((Integer)value);
        } else if ("maximal.number.errors" == key.getKeyValue() && value instanceof Integer) {
            this.setMaxAnomaly((Integer)value);
        } else if ("fr.cnav.norme.val.anomaliesInhibiting" == key.getKeyValue() && value instanceof Boolean) {
            this.setAnomaliesFilteringOption((Boolean)value);
        }
    }

    private void setAnomaliesFilteringOption(Boolean value) {
        this.doFilterSecondaryAnomalies = value;
    }

    private void initReportContextDescriptor(ReportContextDescriptor reportContextDescriptor) {
        this.contextDescriptor = reportContextDescriptor;
        Context rootContext = this.contextDescriptor.getRootContext();
        this.lineNumberToContextMap.put(0, rootContext);
        rootContext.setStartLine(0);
        this.contextList.add(rootContext);
        this.report.setRootContext(rootContext);
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        if (this.validationOperationNumber == 1 && this.contextDescriptor.isABlockContext(block) && !this.contextDescriptor.isABlockRootContext(block)) {
            Context newContext = this.contextDescriptor.getNewContext(block);
            String newContextBlockID = newContext.getblockQualifiedId();
            int rankInParent = this.siblingsNumber.containsKey(newContextBlockID) ? this.siblingsNumber.get(newContextBlockID) : 0;
            this.siblingsNumber.put(newContextBlockID, ++rankInParent);
            newContext.setRank(rankInParent);
            Context lastContext = this.notLeftContextStack.peek();
            lastContext.addContextChild(newContext);
            if (!this.limitExceeded) {
                newContext.hasBeenDirectlyValidated(true);
            }
            this.contextList.add(newContext);
            this.notLeftContextStack.push(newContext);
            this.contextSetStack.push(true);
        } else if (this.contextDescriptor.isABlockContext(block) && !this.contextDescriptor.isABlockRootContext(block)) {
            this.contextSetStack.push(false);
            this.currentMessageBlockContext = block;
        } else {
            this.currentMessageBlockContext = null;
        }
        if (this.doFilterSecondaryAnomalies) {
            this.primaryAnomaliesScopesProvider.enterBlock(block);
        }
    }

    private Context getContext(int subgroupFirstLineNumber) {
        Context context = this.lineNumberToContextMap.get(subgroupFirstLineNumber);
        if (context == null) {
            throw new IllegalStateException("A problem occured when retrieving the context associated to a subgroup in reporting operation of phase 2 or 3 of the validation.");
        }
        return context;
    }

    @Override
    public void logResult(IRuleResult ruleResult) throws TooManyAnomaliesException {
        if (!this.limitExceeded) {
            IRule rule = ruleResult.getRule();
            IFieldLocalizer localizer = null;
            localizer = ruleResult.getTriggeringField() != null ? ruleResult.getTriggeringField().getFieldLocalizer() : new SequentialLocalizer(0);
            ContextInformation anomalyContext = this.getClosestContext(localizer, false);
            boolean isBlocking = this.isBlockingRule(rule.getCode(), rule.getCriticity());
            this.genericLog(ruleResult.getTriggeringField(), rule.getCode(), ruleResult.getMessage(), ruleResult.getTriggeringContext(), isBlocking, anomalyContext);
        }
    }

    protected void genericLog(IMessageField<?> messageField, String code, String message, IMessageBlock blockContext, boolean isBlocking, ContextInformation contextInformation) throws TooManyAnomaliesException {
        if (this.nbTotalAnomaliesLogged < this.nbLimitAnomalies || this.nbLimitAnomalies <= 0) {
            IFieldLocalizer localizer = messageField == null ? new SequentialLocalizer(0) : messageField.getFieldLocalizer();
            Anomaly anomaly = this.newAnomalie(messageField, code, message, isBlocking, localizer);
            if (this.doFilterSecondaryAnomalies) {
                this.primaryAnomaliesScopesProvider.signalAnomaly(anomaly);
            }
            this.nbTotalAnomaliesLogged = this.nbTotalAnomaliesLogged + 1;
            if (this.mustLog(anomaly, contextInformation)) {
                contextInformation.closestContext.addAnomalyToContext(anomaly);
            }
        } else {
            IFieldLocalizer localizer = messageField == null ? new SequentialLocalizer(0) : messageField.getFieldLocalizer();
            this.logLimitExceededError(localizer);
            Context closestContext = contextInformation.closestContext;
            if (closestContext.getAnomalies().size() == 0) {
                closestContext.hasBeenDirectlyValidated(false);
            }
            throw new TooManyAnomaliesException("Anomaly number exceeds the limit (" + this.nbLimitAnomalies + ")");
        }
    }

    boolean mustLog(Anomaly anomaly, ContextInformation contextInformation) {
        if (this.factorizationEnabled) {
            return this.anomalyBuckets.mustLogAnomaly(anomaly, contextInformation.closestContext, contextInformation.closestContextRank);
        }
        return true;
    }

    private ContextInformation getClosestContext(IFieldLocalizer fieldLocalizer, boolean conversionError) {
        Context closestContext = null;
        ContextInformation contextInformation = new ContextInformation();
        if (this.validationOperationNumber == 0) {
            contextInformation.closestContextRank = this.contextList.get(0).getRank();
            contextInformation.closestContext = this.contextList.get(0);
        } else if (conversionError) {
            contextInformation.closestContextRank = this.notLeftContextStack.peek().getRank();
            contextInformation.closestContext = this.notLeftContextStack.peek();
        } else {
            ListIterator<Context> contextIterator = this.contextList.listIterator(this.contextList.size());
            closestContext = this.getClosestContextFromAllExistingContexts(fieldLocalizer, contextIterator);
            if (closestContext == null) {
                closestContext = this.contextList.get(0);
            }
            contextInformation.closestContext = closestContext;
            if (closestContext != this.contextList.get(0)) {
                contextInformation.closestContextRank = closestContext.getRank();
            }
        }
        return contextInformation;
    }

    private Context getClosestContextFromAllExistingContexts(IFieldLocalizer fieldLocalizer, ListIterator<Context> contextIterator) {
        Context closestContext = null;
        while (closestContext == null && contextIterator.hasPrevious()) {
            Context previousContext = contextIterator.previous();
            if (fieldLocalizer == null) {
                throw new IllegalStateException("The IFieldLocalizer is unknow to the GenericReportLogger and can't be handled.");
            }
            if (fieldLocalizer.getLineNumber() < previousContext.getStartLine() || fieldLocalizer.getLineNumber() > previousContext.getEndLine() && previousContext.getEndLine() != -1) continue;
            closestContext = previousContext;
        }
        return closestContext;
    }

    @Override
    public void logAnomaly(IMessageField<?> messageField, String code, String message, RuleCriticity criticality) throws TooManyAnomaliesException {
        this.logAnomaly(messageField, code, message, criticality, true);
    }

    @Override
    public void logAnomaly(IMessageField<?> messageField, String code, String message, RuleCriticity criticality, boolean isConversionError) throws TooManyAnomaliesException {
        if (!this.limitExceeded) {
            boolean isBlocking = this.isBlockingRule(code, criticality);
            IFieldLocalizer fieldLocalizer = null;
            if (messageField == null) {
                fieldLocalizer = new SequentialLocalizer(0);
                Anomaly anomaly = this.newAnomalie(null, "99", "A technical error occured, see the logs for more details", true, fieldLocalizer);
                this.report.getRootContext().addAnomalyToContext(anomaly);
                if (this.doFilterSecondaryAnomalies) {
                    this.primaryAnomaliesScopesProvider.signalAnomaly(anomaly);
                }
            } else {
                fieldLocalizer = messageField.getFieldLocalizer();
                IMessageBlock contextBlock = messageField.getParent();
                ContextInformation anomalyContext = this.getClosestContext(fieldLocalizer, isConversionError);
                this.genericLog(messageField, code, message, contextBlock, isBlocking, anomalyContext);
            }
        }
    }

    private boolean isBlockingRule(String code, RuleCriticity defaultRuleCriticality) {
        boolean isBLockingRule;
        boolean bl = isBLockingRule = RuleCriticity.BLOCKING == defaultRuleCriticality;
        if (this.controlsProperties != null && this.controlsProperties.get(code) != null && RuleCriticity.BLOCKING.getLiteral().toLowerCase().equals(((String)this.controlsProperties.get(code)).toLowerCase())) {
            isBLockingRule = true;
        } else if (this.controlsProperties != null && this.controlsProperties.get(code) != null && RuleCriticity.NOT_BLOCKING.getLiteral().toLowerCase().equals(((String)this.controlsProperties.get(code)).toLowerCase())) {
            isBLockingRule = false;
        }
        return isBLockingRule;
    }

    private Anomaly newAnomalie(IMessageField<?> messageField, String code, String message, boolean isBlocking, IFieldLocalizer fieldLocalizer) {
        String fieldId = "";
        String fieldValue = "";
        String fieldLabel = null;
        if (messageField != null) {
            fieldId = messageField.getStandardFieldDescription().getFullQualifiedId();
            if (fieldId == null) {
                fieldId = messageField.getStandardFieldDescription().getId();
            }
            fieldLabel = messageField.getStandardFieldDescription().getName();
            if (messageField instanceof IMessageFieldNum) {
                IMessageFieldNum messageFieldNum = (IMessageFieldNum)messageField;
                fieldValue = messageFieldNum.getOriginalValue();
            } else if (messageField instanceof IMessageFieldDate) {
                IMessageFieldDate messageFieldDate = (IMessageFieldDate)messageField;
                fieldValue = messageFieldDate.getOriginalValue();
            } else {
                fieldValue = messageField.getValueAsString();
            }
        }
        return new Anomaly(code, message, fieldId, fieldLabel, fieldValue, fieldLocalizer, 1, isBlocking);
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
        HashMap<String, Integer> newMap = new HashMap<String, Integer>();
        Enumeration elements = this.notLeftContextStack.elements();
        while (elements.hasMoreElements()) {
            Context context = (Context)elements.nextElement();
            String id = context.getblockQualifiedId();
            if (!this.siblingsNumber.containsKey(id)) continue;
            newMap.put(id, this.siblingsNumber.get(id));
        }
        this.siblingsNumber.clear();
        this.siblingsNumber.putAll(newMap);
        if (this.contextDescriptor.isABlockContext(block) && !this.contextSetStack.isEmpty() && this.contextSetStack.peek().booleanValue()) {
            Context lastPushedContext = this.notLeftContextStack.peek();
            lastPushedContext.setEndLine(this.lastLineNumber);
            this.contextSetStack.pop();
            this.notLeftContextStack.pop();
            this.currentMessageBlockContext = null;
        }
        if (this.doFilterSecondaryAnomalies) {
            this.primaryAnomaliesScopesProvider.exitBlock(block);
        }
    }

    private void register(IMessageField<?> messageField) {
        String fieldId;
        if (this.validationOperationNumber == 1 && this.calculateContextsDuringParsing && this.contextDescriptor.isFieldInContext(fieldId = messageField.getStandardFieldDescription().getFullQualifiedId())) {
            String value = messageField.getValueAsString();
            if (value == null || value.isEmpty()) {
                value = messageField.getValueAsString();
            }
            ContextField contextField = new ContextField(this.contextDescriptor.getSerializationName(fieldId), value);
            this.notLeftContextStack.peek().addContextField(contextField);
        }
        IFieldLocalizer fieldLocalizer = messageField.getFieldLocalizer();
        Integer lineNumber = null;
        if (fieldLocalizer instanceof SequentialLocalizer) {
            lineNumber = ((SequentialLocalizer)fieldLocalizer).getLineNumber();
        } else if (fieldLocalizer instanceof LineAndColumnLocalizer) {
            lineNumber = ((LineAndColumnLocalizer)fieldLocalizer).getLineNumber();
        }
        if (this.validationOperationNumber == 1 && this.notLeftContextStack.peek().getStartLine() == -1) {
            this.lineNumberToContextMap.put(lineNumber, this.notLeftContextStack.peek());
            this.notLeftContextStack.peek().setStartLine(lineNumber);
            this.contextSetStack.pop();
            this.contextSetStack.push(true);
        }
        if (this.validationOperationNumber > 1 && this.currentMessageBlockContext != null && !this.contextSetStack.peek().booleanValue()) {
            this.contextSetStack.pop();
            this.contextSetStack.push(true);
            this.notLeftContextStack.push(this.getContext(lineNumber));
        }
        if (this.factorizationEnabled) {
            this.anomalyBuckets.enterContext(this.notLeftContextStack.peek());
        }
        if (lineNumber != null) {
            this.lastLineNumber = lineNumber;
        }
    }

    protected void setAnomalyFactorization(int threshold) {
        if (threshold <= 0) {
            this.factorizationEnabled = false;
            this.anomalyBuckets = null;
        } else {
            this.factorizationEnabled = true;
            this.anomalyBuckets = new AnomalyBuckets(threshold);
        }
    }

    private void setMaxAnomaly(int anomalyLimit) {
        this.nbLimitAnomalies = anomalyLimit < 0 ? Integer.MAX_VALUE : anomalyLimit;
    }

    private void logLimitExceededError(IFieldLocalizer fieldLocalizer) {
        if (!this.limitExceeded) {
            Anomaly anomaly = this.newAnomalie(null, "LIM000", "Des anomalies ont \u00e9t\u00e9 d\u00e9tect\u00e9es en surnombre dans l'envoi", true, fieldLocalizer);
            this.report.getRootContext().addAnomalyToContext(anomaly);
            this.limitExceeded = true;
        }
    }

    @Override
    public void setCustomAttribute(String attributeKey, String value) {
        if ("fr.cnav.saturne.validator.report.timeStampAttributeKey".equals(attributeKey)) {
            this.report.setValidationTimeStamp(value);
        } else if ("fr.cnav.saturne.validator.report.validationIdAttributeKey".equals(attributeKey)) {
            this.report.setValidationId(value);
        }
        this.calculatedContextAttributesMap.put(attributeKey, value);
    }

    @Override
    public String getCustomAttributeValue(String attributeKey) {
        return this.calculatedContextAttributesMap.get(attributeKey);
    }

    @Override
    public int getAnomaliesNumber() {
        return this.getAnomaliesNumber(this.report.getRootContext());
    }

    private int getAnomaliesNumber(Context context) {
        if (context == null) {
            return 0;
        }
        int nbAnomalies = 0;
        List<Anomaly> anomalies = context.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            nbAnomalies += anomaly.getNumber();
        }
        List<Context> contextChildren = context.getContextChildren();
        for (Context contextChild : contextChildren) {
            nbAnomalies += this.getAnomaliesNumber(contextChild);
        }
        return nbAnomalies;
    }

    @Override
    public ReportContextDescriptor geReportContextDescriptor() {
        return this.contextDescriptor;
    }

    @Override
    public OptionMap getOptions() {
        return this.optionMap;
    }

    @Override
    public void startTree() {
        ++this.validationOperationNumber;
        this.siblingsNumber.clear();
        this.notLeftContextStack = new Stack();
        this.notLeftContextStack.push(this.report.getRootContext());
        if (this.validationOperationNumber == 1 && this.calculateContextsDuringParsing && (this.report.getRootContext() == null || this.report.getRootContext().getAnomalies().size() <= 0 || !"99".equals(this.report.getRootContext().getAnomalies().get(this.report.getRootContext().getAnomalies().size() - 1).getCode()))) {
            if (this.contextDescriptor.doAddValidationIdContext() && this.report.getValidationId() != null) {
                this.report.getRootContext().addContextField(new ContextField("validationID", this.report.getValidationId()));
            }
            if (this.contextDescriptor.doAddValidationTimeStampContext() && this.report.getValidationTimeStamp() != null) {
                this.report.getRootContext().addContextField(new ContextField("validation_execution_date", this.report.getValidationTimeStamp()));
            }
        }
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        this.register(field);
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        this.register(field);
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        this.register(field);
    }

    @Override
    public void endTree() throws TreeProcessingException {
    }

    @Override
    public void filterSecondaryAnomalies() {
        ReportFilteringOperation reportFilteringOperation = new ReportFilteringOperation();
        Map<String, Set<GenericRule>> fieldIdToReferencingRulesMap = reportFilteringOperation.getFieldIdToReferencingRulesMap(this.standard, this.primaryAnomaliesScopesProvider.getFieldToScopeMap());
        reportFilteringOperation.filterSecondaryAnomalies(this, this.primaryAnomaliesScopesProvider.getFieldToScopeMap(), fieldIdToReferencingRulesMap);
    }

    private static class ContextInformation {
        private Context closestContext;
        private int closestContextRank;

        private ContextInformation() {
        }
    }
}

