/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import java.util.HashMap;
import java.util.Map;

public class AnomalyBuckets {
    protected Map<String, AnomalyInfo> anomalyInfos;
    protected int threshold;

    public AnomalyBuckets(int threshold) {
        this.threshold = threshold;
        this.anomalyInfos = new HashMap<String, AnomalyInfo>();
    }

    protected AnomalyInfo getInfo(Anomaly anomaly, int contextRank, Context context) {
        StringBuilder builder = new StringBuilder();
        builder.append(anomaly.getCode()).append('/').append(anomaly.getFieldId()).append(contextRank).append('/').append(context.getblockQualifiedId());
        String key = builder.toString();
        AnomalyInfo result = this.anomalyInfos.get(key);
        if (result == null) {
            result = new AnomalyInfo(anomaly);
            this.anomalyInfos.put(key, result);
        }
        return result;
    }

    public boolean mustLogAnomaly(Anomaly anomaly, Context context, int contextRank) {
        boolean keepLogging;
        AnomalyInfo info = this.getInfo(anomaly, contextRank, context);
        boolean bl = keepLogging = info.count < this.threshold;
        if (!keepLogging) {
            info.lastAnomaly.incrementAnomalyNumber();
        } else {
            info.lastAnomaly = anomaly;
            ++info.count;
        }
        return keepLogging;
    }

    public void enterContext(Context context) {
    }

    static class AnomalyInfo {
        Anomaly lastAnomaly;
        int count;

        AnomalyInfo(Anomaly anomaly) {
            this.lastAnomaly = anomaly;
            this.count = 0;
        }

        public Anomaly getLastAnomaly() {
            return this.lastAnomaly;
        }
    }
}

