/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.SequentialLocalizer;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;

public class MessageBuilder {
    private IMessageBlock context;
    private IMessageBlock currentBlock;
    private IMessageField<?> subject;
    private IMessageField<?> currentField;
    private int fieldIdx;
    private MessageElementFactory messageElementFactory;

    public MessageBuilder(StandardAccessor theStandardAccessor) {
        this.messageElementFactory = new MessageElementFactory(theStandardAccessor);
    }

    public IMessageBlock getContext() {
        return this.context;
    }

    public IMessageBlock getCurrentBlock() {
        return this.currentBlock;
    }

    public IMessageField<?> getCurrentField() {
        return this.currentField;
    }

    public IMessageField<?> getSubject() {
        return this.subject;
    }

    public int getFieldIdx() {
        return this.fieldIdx;
    }

    public void resetFieldIdx() {
        this.fieldIdx = 0;
    }

    public MessageBuilder createRootMessageBlock() {
        this.currentBlock = this.messageElementFactory.getRootContextBlock();
        return this;
    }

    public MessageBuilder createMessageBlock(String blockFQID) {
        this.currentBlock = this.messageElementFactory.createMessageBlock(blockFQID);
        return this;
    }

    public MessageBuilder createMessageBlockInCurrentBlock(String blockFQID) {
        IMessageBlock oldCurrentBlock = this.currentBlock;
        this.createContextMessageBlock(blockFQID);
        oldCurrentBlock.addBlock(this.currentBlock);
        return this;
    }

    public MessageBuilder createContextMessageBlock(String blockFQID) {
        this.createMessageBlock(blockFQID);
        this.context = this.currentBlock;
        return this;
    }

    public MessageBuilder createContextMessageBlockInCurrentBlock(String blockFQID) {
        this.createMessageBlock(blockFQID);
        this.context = this.currentBlock;
        return this;
    }

    public MessageBuilder createSujectMessageBlockInCurrentBlock(String fieldFQID, String fieldValue) {
        this.createMessageFieldInCurrentBlock(fieldFQID, fieldValue);
        this.subject = this.currentField;
        return this;
    }

    public MessageBuilder setCurrentBlock(IMessageBlock block) {
        this.currentBlock = block;
        return this;
    }

    public MessageBuilder createMessageField(String fieldFQID, String fieldValue) {
        ++this.fieldIdx;
        this.currentField = this.messageElementFactory.createMessageField(fieldFQID, fieldValue, new SequentialLocalizer(this.fieldIdx));
        return this;
    }

    public MessageBuilder createMessageFieldInCurrentBlock(String fieldFQID, String fieldValue) {
        this.createMessageFieldInAParentBlock(fieldFQID, fieldValue, this.currentBlock);
        return this;
    }

    public MessageBuilder createMessageFieldInAParentBlock(String fieldFQID, String fieldValue, IMessageBlock parent) {
        this.createMessageField(fieldFQID, fieldValue);
        this.setCurrentFieldParentBlock(parent);
        return this;
    }

    public MessageBuilder setCurrentFieldParentBlock(IMessageBlock parent) {
        parent.addField(this.currentField);
        return this;
    }

    public MessageBuilder cleanBuilder() {
        this.context = null;
        this.currentBlock = null;
        this.subject = null;
        this.currentField = null;
        this.resetFieldIdx();
        return this;
    }
}

