/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.functions;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.conversion.TreeBuilder;
import fr.cnav.saturne.validator.conversion.csv.CSVSequenceReader;
import fr.cnav.saturne.validator.conversion.json.JsonSequenceReader;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialReader;
import fr.cnav.saturne.validator.conversion.xml.XMLSerializer;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.functions.ValidationFunctionsHelper;
import fr.cnav.saturne.validator.impl.FormatType;
import fr.cnav.saturne.validator.message.MessageRecuperator;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperConversion {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AbstractKBDescriptor abstractKBDescriptor;
    private final ControlMessages controlMessages;
    private final OriginalValueOptionValue emitOriginalValue;
    private final boolean emitOriginalLineNumber;
    private final OptionMap options;

    public HelperConversion(AbstractKBDescriptor abstractKBDescriptor, ControlMessages controlMessages, OptionMap options, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber) throws ValidationFunctionException {
        this.abstractKBDescriptor = abstractKBDescriptor;
        this.options = options;
        this.controlMessages = controlMessages;
        this.emitOriginalLineNumber = emitOriginalLineNumber;
        this.emitOriginalValue = emitOriginalValue;
    }

    public IMessageBlock convert(InputStream textInput, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        this.logger.debug("Start of the conversion");
        if (textInput == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        TreeBuilder treeBuilder = new TreeBuilder(this.getModelAccessor(), reportLogger, this.controlMessages, new SequentialReader(this.getStandardDescription(), this.options, this.controlMessages, this.getModelAccessor(), textInput, Charset.forName(this.getStandardDescription().getMessagesEncoding())));
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        treeBuilder.addConsumer(messageRecuperator);
        treeBuilder.addConsumer(reportLogger);
        try {
            treeBuilder.convert();
        }
        catch (SaturneValidatorException e) {
            this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the conversion and validation in one pass");
        return messageRecuperator.getRootMessageBlock();
    }

    public IMessageBlock convertAndSerializeToXml(InputStream textInput, OutputStream xmlOutput, IReportLogger reportLogger, String encoding, FormatType messageFormat) throws ValidationFunctionException, TooManyAnomaliesException {
        this.logger.info("[Saturne] Start of the serialization of the converted message");
        if (textInput == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (xmlOutput == null) {
            throw new IllegalArgumentException("The parameter message of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The parameter encoding of the serializeXML method can't be null");
        }
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        try {
            if (FormatType.XML.equals((Object)messageFormat) || FormatType.XMLNP.equals((Object)messageFormat)) {
                IOUtils.copyLarge((InputStream)textInput, (OutputStream)xmlOutput);
            } else {
                ValidationFunctionsHelper validationFunctionsHelper = new ValidationFunctionsHelper(this.abstractKBDescriptor, this.controlMessages, this.options);
                ISequenceProvider reader = validationFunctionsHelper.getReader(textInput, messageFormat);
                TreeBuilder treeBuilder = new TreeBuilder(this.getModelAccessor(), reportLogger, this.controlMessages, reader);
                treeBuilder.addConsumer(messageRecuperator);
                treeBuilder.addConsumer(reportLogger);
                XMLSerializer xmlSerializer = null;
                Boolean xmlNoPrefix = null;
                xmlNoPrefix = FormatType.TXTNP.equals((Object)messageFormat) || FormatType.CSVNP.equals((Object)messageFormat) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                xmlSerializer = new XMLSerializer(this.getStandardDescription(), xmlOutput, encoding, this.emitOriginalValue, this.emitOriginalLineNumber, xmlNoPrefix);
                treeBuilder.addConsumer(xmlSerializer);
                treeBuilder.convert();
            }
        }
        catch (SaturneValidatorException e) {
            this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        catch (ConversionSerializationException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        catch (IOException e) {
            this.logger.error("[Saturne] The serialization of the converted message has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the serialization of the converted message");
        return messageRecuperator.getRootMessageBlock();
    }

    public IMessageBlock convertFromCSV(InputStream textInput, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        TreeBuilder treeBuilder;
        this.logger.info("[Saturne] Start of the conversion");
        if (textInput == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        try {
            treeBuilder = new TreeBuilder(this.getModelAccessor(), reportLogger, this.controlMessages, new CSVSequenceReader(this.getStandardDescription(), this.options, this.controlMessages, this.getModelAccessor(), textInput));
        }
        catch (SaturneValidatorException e) {
            this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        treeBuilder.addConsumer(messageRecuperator);
        treeBuilder.addConsumer(reportLogger);
        try {
            treeBuilder.convert();
        }
        catch (SaturneValidatorException e) {
            this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the conversion and validation in one pass");
        return messageRecuperator.getRootMessageBlock();
    }

    public IMessageBlock convertFromJson(InputStream textInput, IReportLogger reportLogger) throws IOException, ValidationFunctionException, TooManyAnomaliesException {
        TreeBuilder treeBuilder;
        this.logger.info("[Saturne] Start of the conversion");
        if (textInput == null) {
            throw new IllegalArgumentException("The parameter inputStream of the conversion method can't be null");
        }
        if (reportLogger == null) {
            throw new IllegalArgumentException("The parameter reportLogger of the conversion method can't be null");
        }
        try {
            treeBuilder = new TreeBuilder(this.getModelAccessor(), reportLogger, this.controlMessages, new JsonSequenceReader(this.options, this.controlMessages, this.getModelAccessor(), textInput, Charset.forName(this.getStandardDescription().getMessagesEncoding())));
        }
        catch (SaturneValidatorException e) {
            this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        treeBuilder.addConsumer(messageRecuperator);
        treeBuilder.addConsumer(reportLogger);
        try {
            treeBuilder.convert();
        }
        catch (SaturneValidatorException e) {
            this.logger.error("[Saturne] The conversion of a message into a MessageBlock has failed", (Throwable)e);
            throw new ValidationFunctionException(e);
        }
        this.logger.info("[Saturne] End of the conversion and validation in one pass");
        return messageRecuperator.getRootMessageBlock();
    }

    private StandardDescription getStandardDescription() {
        return this.getModelAccessor().getStandardDescription();
    }

    private StandardAccessor getModelAccessor() {
        return this.abstractKBDescriptor.getStandardAccessor();
    }
}

