/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.msgtest;

import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.message.MessageBuilder;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class MessageTestReader {
    private static final String TAG_SEPARATOR = "#";
    StandardAccessor theStandardAccessor;
    private MessageBuilder messageBuilder;
    private IMessageBlock rootBlock;
    private Map<String, IMessageBlock> taggedMsgBlock;
    private Map<String, IMessageField<?>> taggedMsgField;
    private Map<String, IMessageFieldAlphanum> taggedMsgFieldAlpha;
    private Map<String, IMessageFieldNum> taggedMsgFieldNum;
    private Map<String, IMessageFieldDate> taggedMsgFieldDate;
    private Stack<IMessageBlock> currentMsgBlockStack;

    public MessageTestReader(StandardAccessor standardAccessor) {
        this.theStandardAccessor = standardAccessor;
        this.messageBuilder = new MessageBuilder(this.theStandardAccessor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IMessageBlock getRootBlock(String msgString) {
        this.rootBlock = null;
        this.currentMsgBlockStack = new Stack();
        this.taggedMsgBlock = new HashMap<String, IMessageBlock>();
        this.taggedMsgField = new HashMap();
        this.taggedMsgFieldAlpha = new HashMap<String, IMessageFieldAlphanum>();
        this.taggedMsgFieldNum = new HashMap<String, IMessageFieldNum>();
        this.taggedMsgFieldDate = new HashMap<String, IMessageFieldDate>();
        if (msgString == null) {
            return null;
        }
        String[] stringArray = msgString.split("[\n\r]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String cleanedLine = line.trim();
            if (cleanedLine.startsWith("<")) {
                String[] splitedLine = cleanedLine.substring(1).split(TAG_SEPARATOR);
                if (splitedLine.length > 0) {
                    if (this.rootBlock == null) {
                        this.messageBuilder.createMessageBlock(cleanedLine.substring(1).split(TAG_SEPARATOR)[0]);
                        this.rootBlock = this.messageBuilder.getCurrentBlock();
                    } else {
                        if (this.currentMsgBlockStack.isEmpty()) {
                            throw new RuntimeException("Message block can't have two root blocks");
                        }
                        this.messageBuilder.createMessageBlockInCurrentBlock(cleanedLine.substring(1).split(TAG_SEPARATOR)[0]);
                    }
                    this.currentMsgBlockStack.push(this.messageBuilder.getCurrentBlock());
                    if (splitedLine.length > 1) {
                        this.taggedMsgBlock.put(splitedLine[1].trim(), this.messageBuilder.getCurrentBlock());
                    }
                }
            } else if (cleanedLine.startsWith(">")) {
                if (this.currentMsgBlockStack.empty()) throw new RuntimeException("Block closing line is not matching a block opening line");
                this.currentMsgBlockStack.pop();
                if (!this.currentMsgBlockStack.isEmpty()) {
                    this.messageBuilder.setCurrentBlock(this.currentMsgBlockStack.peek());
                }
            } else if (cleanedLine.startsWith("+")) {
                this.createField(cleanedLine);
            }
            ++n2;
        }
        if (this.currentMsgBlockStack.isEmpty()) return this.rootBlock;
        throw new RuntimeException("An opened block is not closed");
    }

    private void createField(String cleanedLine) {
        String[] splitedFieldLine = cleanedLine.substring(1).split(TAG_SEPARATOR);
        String[] splitedFieldLine2 = splitedFieldLine[0].split(",");
        if (splitedFieldLine2.length > 1) {
            String fqid = splitedFieldLine2[0].trim();
            String value = splitedFieldLine2[1].trim();
            this.tryToParseValue(fqid, value);
            this.messageBuilder.createMessageFieldInCurrentBlock(fqid, value);
            if (splitedFieldLine.length > 1) {
                IMessageField<?> currentMsgField = this.messageBuilder.getCurrentField();
                String tag = splitedFieldLine[1].trim();
                this.taggedMsgField.put(tag, currentMsgField);
                if (currentMsgField instanceof IMessageFieldAlphanum) {
                    this.taggedMsgFieldAlpha.put(tag, (IMessageFieldAlphanum)currentMsgField);
                } else if (currentMsgField instanceof IMessageFieldNum) {
                    this.taggedMsgFieldNum.put(tag, (IMessageFieldNum)currentMsgField);
                } else if (currentMsgField instanceof IMessageFieldDate) {
                    this.taggedMsgFieldDate.put(tag, (IMessageFieldDate)currentMsgField);
                }
            }
        } else {
            throw new RuntimeException("The line '" + cleanedLine + "' has not a correct form. The correct form follows the format '+fullQIField,valueField[#Tag]', the tag is optional");
        }
    }

    public IMessageBlock getTaggedMsgBlock(String tag) {
        return this.taggedMsgBlock.get(tag);
    }

    public IMessageField<?> getTaggedMsgField(String tag) {
        return this.taggedMsgField.get(tag);
    }

    public IMessageFieldAlphanum getTaggedMsgFieldAlpha(String tag) {
        return this.taggedMsgFieldAlpha.get(tag);
    }

    public IMessageFieldNum getTaggedMsgFieldNum(String tag) {
        return this.taggedMsgFieldNum.get(tag);
    }

    public IMessageFieldDate getTaggedMsgFieldDate(String tag) {
        return this.taggedMsgFieldDate.get(tag);
    }

    protected void tryToParseValue(String fqid, String value) {
        FieldDescription fieldDescription = this.theStandardAccessor.getFieldDescription(fqid);
        if (fieldDescription == null) {
            throw new IllegalArgumentException("Couldn't find the specified field : " + fqid);
        }
        DataTypeDescription type = fieldDescription.getDataType();
        if (type.getNature() == NatureType.NUMERIC) {
            new BigDecimal(value);
        } else if (type.getNature() == NatureType.DATE) {
            String dateFormat = this.theStandardAccessor.getStandardDescription().getDateFormat();
            LocalDate localDate = LocalDate.parse(value, DateTimeFormatter.ofPattern(dateFormat.replace('y', 'u')).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE));
            Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }
}

