/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.AbstractBinding;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.FunctionBinding;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.MessageElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class BlockUtil {
    public boolean isInBlock(Block block, EObject eObject) {
        if (block == eObject) {
            return true;
        }
        if (eObject == null || eObject instanceof Message) {
            return false;
        }
        return this.isInBlock(block, eObject.eContainer());
    }

    public List<Block> getAllBlockSince(Block block) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        if (block != null) {
            blockList.add(block);
            for (Block child : block.getChildrenBlocks()) {
                blockList.addAll(this.getAllBlockSince(child));
            }
        }
        return blockList;
    }

    public List<FunctionBinding> getAllFunctionBindings(Block parentBlock) {
        ArrayList<FunctionBinding> bindingList = new ArrayList<FunctionBinding>();
        List<Block> allBlocks = this.getAllBlockSince(parentBlock);
        for (Block block : allBlocks) {
            if (block.getBindings() == null) continue;
            for (AbstractBinding binding : block.getBindings().getBindings()) {
                if (!(binding instanceof FunctionBinding)) continue;
                bindingList.add((FunctionBinding)binding);
            }
        }
        return bindingList;
    }

    public int indexOfBlock(Block block) {
        int result = -1;
        if (block != null && block.eContainer() != null && block.eContainer() instanceof Block) {
            Block parent = (Block)block.eContainer();
            result = parent.getChildren().indexOf((Object)block);
        }
        return result;
    }

    public int indexOfBlock(MessageElement msgElement) {
        int result = -1;
        if (msgElement != null && msgElement.eContainer() != null && msgElement.eContainer() instanceof Block) {
            Block parent = (Block)msgElement.eContainer();
            result = parent.getChildren().indexOf((Object)msgElement);
        } else if (msgElement != null && msgElement.eContainer() != null && msgElement.eContainer() instanceof Message) {
            Message parent = (Message)msgElement.eContainer();
            if (parent.getHeaderBlock() == msgElement) {
                result = 0;
            } else if (parent.getFooterBlock() == msgElement) {
                result = 1;
            }
        }
        return result;
    }
}

