/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;

public class ValueListTypeAdapter
extends DSLTypeAdapter {
    private static final String VALUE_LIST_HAS_PROHIBITED_ELEMENT_TYPE = "Value list has prohibited element's type: ";

    @Override
    Type computeType(Type context, Map<String, Type> env) {
        Type result;
        assert (this.getTarget() instanceof ValueList);
        ValueList list = (ValueList)this.getTarget();
        Type type = Type.UNSET;
        for (Literal literal : list.getValues()) {
            Type litType = DSLTypeAdapterFactory.adapt(literal).getType(context, env);
            if (type == Type.UNSET) {
                type = litType;
                continue;
            }
            if (type == litType) continue;
            this.setErrorMsg("ValueList element's type must be homogeneous : " + (Object)((Object)type) + " and " + (Object)((Object)litType));
            type = Type.UNDEFINED;
            break;
        }
        switch (type) {
            case NUM: {
                result = Type.NUM_LIST;
                break;
            }
            case ALPHANUM: {
                result = Type.ALPHANUM_LIST;
                break;
            }
            case DATE: {
                result = Type.DATE_LIST;
                break;
            }
            case TOKEN: {
                result = Type.TOKEN_LIST;
                break;
            }
            case UNDEFINED: {
                result = Type.UNDEFINED;
                if (this.getErrorMsg() != null) break;
                this.setErrorMsg("value list has elements of undefined type");
                break;
            }
            default: {
                result = Type.UNDEFINED;
                this.setErrorMsg(VALUE_LIST_HAS_PROHIBITED_ELEMENT_TYPE + (Object)((Object)type));
            }
        }
        if (result == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }
}

