/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.vn;

import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesFactory;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.VarRef;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public final class ValueNumberingUtils {
    private ValueNumberingUtils() {
    }

    private static boolean dependsOnQuantified(Expression e, Quantified quantified) {
        HashSet<String> variables = new HashSet<String>();
        for (IteratorVariable var : quantified.getVariables()) {
            variables.add(var.getVarName());
        }
        return ValueNumberingUtils.dependsOn((EObject)e, variables);
    }

    public static boolean dependsOn(Expression e1, Expression e2) {
        if (e2 instanceof Quantified) {
            return ValueNumberingUtils.dependsOnQuantified(e1, (Quantified)e2);
        }
        if (e2 instanceof Let) {
            return ValueNumberingUtils.dependsOnLet(e1, (Let)e2);
        }
        throw new IllegalArgumentException("dependsOn should be used on Quantified and Let only.");
    }

    private static boolean dependsOnLet(Expression e, Let let) {
        HashSet<String> variables = new HashSet<String>();
        for (Binding binding : let.getBindings()) {
            variables.add(binding.getVarName());
        }
        return ValueNumberingUtils.dependsOn((EObject)e, variables);
    }

    private static boolean dependsOn(EObject expr, Set<String> variables) {
        if (expr instanceof VarRef) {
            return variables.contains(((VarRef)expr).getVarName());
        }
        if (expr instanceof FieldRef) {
            return variables.contains(((FieldRef)expr).getContextVariable());
        }
        for (EObject eObject : expr.eContents()) {
            FieldRef struct;
            VarRef varRef;
            if (!(eObject instanceof VarRef ? variables.contains((varRef = (VarRef)eObject).getVarName()) : (eObject instanceof FieldRef ? variables.contains((struct = (FieldRef)eObject).getContextVariable()) : ValueNumberingUtils.dependsOn(eObject, variables)))) continue;
            return true;
        }
        return false;
    }

    public static Let topLevel(Expression e) {
        Let result;
        Expression previous = e;
        EObject container = e.eContainer();
        while (!(container == null || (container instanceof Quantified || container instanceof Let) && ValueNumberingUtils.dependsOn(e, (Expression)container))) {
            previous = container;
            container = container.eContainer();
        }
        if (container == null) {
            if (previous instanceof Let) {
                result = (Let)previous;
            } else {
                Let let = FormulesFactory.eINSTANCE.createLet();
                let.setIn(previous);
                result = let;
            }
        } else if (container instanceof Let) {
            result = (Let)container;
        } else {
            assert (container instanceof Quantified);
            Quantified quantified = (Quantified)container;
            if (quantified.getExpression() instanceof Let) {
                result = (Let)quantified.getExpression();
            } else {
                Let let = FormulesFactory.eINSTANCE.createLet();
                let.setIn(quantified.getExpression());
                quantified.setExpression(let);
                result = let;
            }
        }
        return result;
    }
}

