/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.invariants;

import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Call;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesGenerator;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.Unary;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.optimization.Transformation;
import fr.cnav.saturne.dsl.optimization.invariants.InvariantHoisting;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class InvariantTransformation
extends FormulesSwitch<Expression>
implements Transformation {
    private FormulesGenerator gen = new FormulesGenerator();
    private Map<Expression, Map<String, Expression>> invariantVarNameMap;
    private Map<Expression, String> invariantGloablExprMap;

    @Override
    public Expression transform(Expression input) {
        InvariantHoisting invariantHoisting = new InvariantHoisting();
        invariantHoisting.extractInvariant(input);
        this.invariantVarNameMap = invariantHoisting.getInvariantVarNameMap();
        this.invariantGloablExprMap = invariantHoisting.getInvariantGlobalExprMap();
        if (this.invariantGloablExprMap.isEmpty()) {
            return input;
        }
        return (Expression)this.doSwitch(input);
    }

    @Override
    public Expression caseQuantified(Quantified object) {
        Map<String, Expression> varMap = this.invariantVarNameMap.get(object);
        Expression result = this.replaceLetVarIfNeeded(object);
        if (result != null && result.equals(object)) {
            if (varMap.size() == 0) {
                Expression objExpression = (Expression)this.doSwitch(object.getExpression());
                object.setExpression(objExpression);
                result = object;
            } else if (varMap.size() > 0) {
                Binding[] binding = new Binding[varMap.size()];
                int i = 0;
                for (Map.Entry<String, Expression> entry : varMap.entrySet()) {
                    Binding curBinding;
                    InvariantTransformation invariantTransformation = new InvariantTransformation();
                    Expression bindingExp = invariantTransformation.transform(entry.getValue());
                    binding[i] = curBinding = this.gen.binding(entry.getKey(), bindingExp);
                    ++i;
                }
                Expression qualidierExpr = (Expression)this.doSwitch(object.getExpression());
                if (qualidierExpr != object.getExpression()) {
                    object.setExpression(qualidierExpr);
                }
                Let letInvariant = this.gen.let(object, binding);
                result = letInvariant;
            }
        }
        return result;
    }

    @Override
    public Expression caseLet(Let object) {
        Map<String, Expression> varMap = this.invariantVarNameMap.get(object);
        Expression result = this.replaceLetVarIfNeeded(object);
        if (result != null && result.equals(object)) {
            if (varMap.size() == 0) {
                Expression objExpression = (Expression)this.doSwitch(object.getIn());
                object.setIn(objExpression);
            } else if (varMap.size() > 0) {
                Binding[] binding = new Binding[varMap.size()];
                int i = 0;
                for (Map.Entry<String, Expression> entry : varMap.entrySet()) {
                    Binding curBinding;
                    InvariantTransformation invariantTransformation = new InvariantTransformation();
                    Expression bindingExp = invariantTransformation.transform(entry.getValue());
                    binding[i] = curBinding = this.gen.binding(entry.getKey(), bindingExp);
                    ++i;
                }
                Expression qualidierExpr = (Expression)this.doSwitch(object.getIn());
                object.setIn(qualidierExpr);
                Let letInvariant = this.gen.let(object, binding);
                result = letInvariant;
            }
        }
        return result;
    }

    private Expression replaceLetVarIfNeeded(Expression object) {
        Expression result = null;
        if (this.invariantGloablExprMap.containsKey(object)) {
            VarRef expVar = this.gen.varRef(this.invariantGloablExprMap.get(object));
            result = expVar;
        } else {
            result = object;
        }
        return result;
    }

    @Override
    public Expression caseCall(Call object) {
        Expression result = this.replaceLetVarIfNeeded(object);
        ArrayList<Expression> transformatedList = new ArrayList<Expression>();
        if (result != null && result.equals(object)) {
            for (Expression expression : object.getArguments()) {
                transformatedList.add((Expression)this.doSwitch(expression));
            }
            int i = 0;
            for (Expression expression : transformatedList) {
                if (expression != object.getArguments().get(i)) {
                    object.getArguments().set(i, (Object)expression);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public Expression caseNary(Nary object) {
        Expression result = this.replaceLetVarIfNeeded(object);
        if (result != null && result.equals(object)) {
            ArrayList<Expression> transformatedList = new ArrayList<Expression>();
            for (Expression expression : object.getOperands()) {
                transformatedList.add(expression);
            }
            object.getOperands().clear();
            for (Expression expression : transformatedList) {
                Expression transformedExpr = (Expression)this.doSwitch(expression);
                object.getOperands().add((Object)transformedExpr);
            }
        }
        return result;
    }

    @Override
    public Expression caseBinary(Binary object) {
        Expression result = this.replaceLetVarIfNeeded(object);
        if (result != null && result.equals(object)) {
            Expression leftOp = (Expression)this.doSwitch(object.getLeftOp());
            Expression rightOp = (Expression)this.doSwitch(object.getRightOp());
            if (leftOp != object.getLeftOp()) {
                object.setLeftOp(leftOp);
            }
            if (rightOp != object.getRightOp()) {
                object.setRightOp(rightOp);
            }
            result = object;
        }
        return result;
    }

    @Override
    public Expression caseUnary(Unary object) {
        Expression result = this.replaceLetVarIfNeeded(object);
        if (result != null && result.equals(object)) {
            Expression operand = (Expression)this.doSwitch(object.getOperand());
            if (operand != object.getOperand()) {
                object.setOperand(operand);
            }
            result = object;
        }
        return result;
    }

    @Override
    public Expression caseIn(In object) {
        Expression result = this.replaceLetVarIfNeeded(object);
        if (result != null && result.equals(object)) {
            Expression leftOp = (Expression)this.doSwitch(object.getLeftOp());
            if (leftOp != object.getLeftOp()) {
                object.setLeftOp(leftOp);
            }
            result = object;
        }
        return result;
    }

    @Override
    public Expression caseVarRef(VarRef object) {
        return object;
    }

    @Override
    public Expression caseFieldRef(FieldRef object) {
        Expression result = null;
        if (this.invariantGloablExprMap.containsKey(object)) {
            VarRef expVar = this.gen.varRef(this.invariantGloablExprMap.get(object));
            result = expVar;
        } else {
            result = object;
        }
        return result;
    }

    @Override
    public Expression caseLiteral(Literal object) {
        return object;
    }

    @Override
    public Expression caseValueList(ValueList object) {
        return object;
    }

    @Override
    public Expression defaultCase(EObject object) {
        return null;
    }
}

