/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.app.service;

import fr.cnav.saturne.app.service.exception.ExceptionKind;
import fr.cnav.saturne.app.service.exception.ValidationServiceException;
import fr.cnav.saturne.app.service.helpers.LoggerHelper;
import fr.cnav.saturne.app.service.helpers.Messages;
import fr.cnav.saturne.app.service.helpers.SystemFileHelper;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public abstract class AbstractValidationService {
    public static final String INPUT_FORMAT_PARAMETER = "-inputFileType";
    public static final String XML_INPUT_FORMAT_PARAMETER = "-inputFileTypeXML";
    public static final String CSV_INPUT_FORMAT_PARAMETER = "-inputFileTypeCSV";
    public static final LoggerHelper LOGGER = new LoggerHelper(AbstractValidationService.class);
    private static final Properties SYS_PROP = System.getProperties();
    protected ClassPathXmlApplicationContext context;
    private File inputDirFile;
    private File outputDirFile;
    private File runningFile;
    private boolean isTempRunningFile;
    private File validationReportRootPath;
    private boolean isTempValidationReportRootPath;
    private File convertedFilestRootPath;
    private boolean isTempConvertedFilestRootPath;
    private String extFilter;

    public abstract void launchService();

    public abstract String getMsgRunService();

    public void launch(String[] args) {
        if (args.length >= 1 && args[0].equals("-help")) {
            this.validationServiceHelp();
            System.exit(ExceptionKind.NEED_HELP.getCode());
        }
        int exitCode = ExceptionKind.UNKNOWN_ERROR.getCode();
        try {
            exitCode = this.validate(args);
        }
        catch (ValidationServiceException e) {
            LOGGER.logError(e);
            exitCode = e.getCode();
        }
        catch (InterruptedException e) {
            LOGGER.logError(e);
            exitCode = ExceptionKind.UNKNOWN_ERROR.getCode();
        }
        catch (IOException e) {
            LOGGER.logError(e);
            exitCode = ExceptionKind.IO_ERROR.getCode();
        }
        System.exit(exitCode);
    }

    public int validate(String ... args) throws InterruptedException, IOException {
        int response = 0;
        try {
            this.validateParameters(args);
            this.initSysProperties();
            this.initIntegrationPaths();
            response = this.callValidationService(args);
        }
        catch (ValidationServiceException e) {
            response = e.getCode();
            LOGGER.logError(e.getMessage());
            System.err.println(e.getMessage());
        }
        return response;
    }

    private void initIntegrationPaths() {
        System.setProperty("input.file.path", this.inputDirFile.getAbsolutePath());
        System.setProperty("validated.folder.path", this.outputDirFile.getAbsolutePath());
        if (!SYS_PROP.containsKey("running.folder.path")) {
            this.runningFile = SystemFileHelper.createTempDirAndInstallHookDeleteOnShutdown();
            this.isTempRunningFile = true;
            System.setProperty("running.folder.path", this.runningFile.getAbsolutePath());
        } else {
            String runningPath = System.getProperty("running.folder.path");
            this.runningFile = new File(runningPath);
            if (!this.runningFile.exists()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_NOT_EXIST, runningPath, "running.folder.path");
            }
            if (!this.runningFile.isDirectory()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_A_DIR, this.runningFile.getAbsolutePath(), "running.folder.path");
            }
            if (!this.runningFile.canWrite()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_WRITEABLE, this.runningFile.getAbsolutePath(), "running.folder.path");
            }
        }
        System.setProperty("filter.file.ext", this.extFilter);
    }

    private void initSysProperties() {
        if (!SYS_PROP.containsKey("reports.root.path")) {
            this.validationReportRootPath = SystemFileHelper.createTempDirAndInstallHookDeleteOnShutdown();
            this.isTempValidationReportRootPath = true;
            System.setProperty("reports.root.path", this.validationReportRootPath.getAbsolutePath());
        } else {
            File reportFolder = new File(SYS_PROP.getProperty("reports.root.path"));
            if (!reportFolder.exists()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_NOT_EXIST, reportFolder, "reports.root.path");
            }
            if (!reportFolder.isDirectory()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_A_DIR, reportFolder, "reports.root.path");
            }
            if (!reportFolder.canWrite()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_WRITEABLE, reportFolder, "reports.root.path");
            }
        }
        System.setProperty("reports.backup.enable", "false");
        if (!SYS_PROP.containsKey("convertedFiles.root.path")) {
            this.convertedFilestRootPath = SystemFileHelper.createTempDirAndInstallHookDeleteOnShutdown();
            this.isTempConvertedFilestRootPath = true;
            System.setProperty("convertedFiles.root.path", this.convertedFilestRootPath.getAbsolutePath());
        } else {
            File converFolder = new File(SYS_PROP.getProperty("convertedFiles.root.path"));
            if (!converFolder.exists()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_NOT_EXIST, converFolder, "convertedFiles.root.path");
            }
            if (!converFolder.isDirectory()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_A_DIR, converFolder, "convertedFiles.root.path");
            }
            if (!converFolder.canWrite()) {
                throw new ValidationServiceException(ExceptionKind.RUNNING_DIR_IS_NOT_WRITEABLE, converFolder, "convertedFiles.root.path");
            }
        }
        if (!SYS_PROP.containsKey("spring.poller.fixed.rate")) {
            System.setProperty("spring.poller.fixed.rate", "1000");
        }
        if (!SYS_PROP.containsKey("spring.poller.maxmsgperpoll")) {
            System.setProperty("spring.poller.maxmsgperpoll", "10");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callValidationService(String[] args) throws InterruptedException, IOException {
        LOGGER.logConsoleInfoPrefix(this.getMsgRunService(), "=> ");
        this.launchService();
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_3, this.inputDirFile.getAbsolutePath());
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_4, this.outputDirFile.getAbsolutePath());
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_5, new File(".").getAbsolutePath().replace("/.", ""));
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_6);
        LOGGER.logConsoleInfo(Messages.LOG_RUNNING_7);
        this.context.registerShutdownHook();
        this.installCleanHookOnShutdown();
        while (true) {
            AbstractValidationService abstractValidationService = this;
            synchronized (abstractValidationService) {
                this.wait();
            }
        }
    }

    private void installCleanHookOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                super.run();
                LOGGER.logInfo(Messages.LOG_RUNNING_9);
                LOGGER.logConsoleInfo(Messages.LOG_RUNNING_13);
                while (SystemFileHelper.filterHiddenFiles(AbstractValidationService.this.runningFile).length != 0) {
                    try {
                        1.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                LOGGER.logConsoleInfo(Messages.LOG_RUNNING_14);
                LOGGER.logInfo(Messages.LOG_RUNNING_10);
                if (AbstractValidationService.this.isTempRunningFile) {
                    LOGGER.logInfo(Messages.LOG_RUNNING_12, AbstractValidationService.this.runningFile.getAbsolutePath());
                    SystemFileHelper.deleteFolder(AbstractValidationService.this.runningFile);
                }
                if (AbstractValidationService.this.isTempValidationReportRootPath) {
                    LOGGER.logInfo(Messages.LOG_RUNNING_12, AbstractValidationService.this.validationReportRootPath.getAbsolutePath());
                    SystemFileHelper.deleteFolder(AbstractValidationService.this.validationReportRootPath);
                }
                if (AbstractValidationService.this.isTempConvertedFilestRootPath) {
                    LOGGER.logInfo(Messages.LOG_RUNNING_12, AbstractValidationService.this.convertedFilestRootPath.getAbsolutePath());
                    SystemFileHelper.deleteFolder(AbstractValidationService.this.convertedFilestRootPath);
                }
                LOGGER.logConsoleInfoPrefix(Messages.LOG_RUNNING_11, "=> ");
            }
        });
    }

    private void validateParameters(String[] args) throws ValidationServiceException {
        this.validateArgsLength(args);
        String inputDir = args[0];
        this.inputDirFile = new File(inputDir);
        if (!this.inputDirFile.exists()) {
            throw new ValidationServiceException(ExceptionKind.INPUT_DIR_NOT_EXIST, inputDir);
        }
        if (!this.inputDirFile.isDirectory()) {
            throw new ValidationServiceException(ExceptionKind.INPUT_DIR_IS_NOT_A_DIR, this.inputDirFile.getAbsolutePath());
        }
        if (!this.inputDirFile.canWrite()) {
            throw new ValidationServiceException(ExceptionKind.INPUT_DIR_IS_NOT_WRITEABLE, this.inputDirFile.getAbsolutePath());
        }
        String outputDir = args[1];
        this.outputDirFile = new File(outputDir);
        if (!this.outputDirFile.exists()) {
            throw new ValidationServiceException(ExceptionKind.OUTPUT_DIR_NOT_EXIST, outputDir);
        }
        if (!this.outputDirFile.isDirectory()) {
            throw new ValidationServiceException(ExceptionKind.OUTPUT_DIR_IS_NOT_A_DIR, this.outputDirFile.getAbsolutePath());
        }
        if (!this.outputDirFile.canWrite()) {
            throw new ValidationServiceException(ExceptionKind.OUTPUT_DIR_IS_NOT_WRITEABLE, this.outputDirFile.getAbsolutePath());
        }
        this.extFilter = args.length == 3 && !args[2].equals(XML_INPUT_FORMAT_PARAMETER) || args.length == 4 ? "*." + args[2] : "*";
    }

    private void validateArgsLength(String[] args) throws ValidationServiceException {
        if (args.length < 1) {
            throw new ValidationServiceException(ExceptionKind.MISSING_ARGUMENTS_ERROR);
        }
        if (args.length < 2) {
            throw new ValidationServiceException(ExceptionKind.WRONG_ARGUMENTS_NUMBER_ERROR_1, args.length);
        }
        if (args.length > 4) {
            throw new ValidationServiceException(ExceptionKind.WRONG_ARGUMENTS_NUMBER_ERROR_2, args.length);
        }
    }

    private void validationServiceHelp() {
        System.out.println(Messages.HELP_LINE_01);
        ExceptionKind[] exceptionKindArray = ExceptionKind.values();
        int n = exceptionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionKind error = exceptionKindArray[n2];
            System.out.println("- " + error.getCode() + " : " + error.getMessage());
            ++n2;
        }
    }
}

