/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.helpers;

import fr.cnav.autocontrole.IMessageUIDescriptor;
import fr.cnav.autocontrole.INormSelector;
import fr.cnav.autocontrole.INormSerializerFactory;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.registry.NormRegistryException;
import java.net.URL;

public class StandardHelper {
    private static StandardHelper instance;
    INormSelector normSelector;
    private AbstractKBDescriptor normDescriptor;
    private IMessageUIDescriptor messageDescriptor;
    private INormSerializerFactory serializerFactory;
    private String applicationLabel;
    private URL application16x16IconURL;
    private URL application64x64IconURL;
    private URL applicationUserDocumentationURL;

    private StandardHelper(INormSelector normSelector) {
        this.normSelector = normSelector;
    }

    public static StandardHelper createNewStandardHelper(INormSelector normSelector) {
        StandardHelper standardHelper = new StandardHelper(normSelector);
        StandardHelper.setInstance(standardHelper);
        return standardHelper;
    }

    public void initializeClasses() throws NormRegistryException {
        this.messageDescriptor = this.normSelector.getMessageUIDescriptor();
        this.normDescriptor = this.normSelector.getNormDescriptor();
        this.serializerFactory = this.normSelector.getSerializerFactory();
    }

    public INormSelector getNormSelector() {
        return this.normSelector;
    }

    public AbstractKBDescriptor getNormDescriptor() {
        return this.normDescriptor;
    }

    public IMessageUIDescriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public StandardDescription getStandard() {
        return this.getStandardAccessor().getStandardDescription();
    }

    public StandardAccessor getStandardAccessor() {
        return this.getNormDescriptor().getStandardAccessor();
    }

    public INormSerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public String getApplicationLabel() {
        if (this.applicationLabel == null) {
            this.applicationLabel = this.normSelector.getApplicationLabel();
        }
        return this.applicationLabel;
    }

    public URL getApplicationIcon16URL() {
        if (this.application16x16IconURL == null) {
            this.application16x16IconURL = this.normSelector.getApplicationIcon16x16URL();
        }
        return this.application16x16IconURL;
    }

    public URL getApplicationIcon64URL() {
        if (this.application64x64IconURL == null) {
            this.application64x64IconURL = this.normSelector.getApplicationIcon64x64URL();
        }
        return this.application64x64IconURL;
    }

    public URL getApplicationUserDocumentationURL() {
        if (this.applicationUserDocumentationURL == null) {
            this.applicationUserDocumentationURL = this.normSelector.getApplicationUserDocumentationURL();
        }
        return this.applicationUserDocumentationURL;
    }

    public String getStandardVersion() {
        return String.valueOf(this.getStandard().getVersion()) + " R\u00e9vision : " + this.getStandard().getRevision();
    }

    public Object getNormeElt(String fullQualifedIdTarget, String nature) {
        FieldDescription normeElt = null;
        FieldDescription field = this.getStandardAccessor().getFieldDescription(fullQualifedIdTarget);
        if (nature != null && !"".equals(nature) && field != null) {
            for (DeclarationDescription decl : this.getStandard().getDeclarations()) {
                if (!decl.getName().equals(nature)) continue;
                normeElt = field;
            }
        } else if (field != null) {
            normeElt = field;
        }
        return normeElt;
    }

    public static StandardHelper getInstance() {
        return instance;
    }

    public static void setInstance(StandardHelper instance) {
        StandardHelper.instance = instance;
    }
}

