/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.presentation;

import fr.cnav.saturne.presentation.SaturneEditorPlugin;
import fr.cnav.saturne.presentation.SaturneModelWizardSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WizardNewSaturneModelCreationPage
extends WizardPage {
    private Text modelNameText;
    private boolean projectCreation;
    private Combo encodingField;
    private Button fullValidModel;
    private List<String> encodings;
    private ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            WizardNewSaturneModelCreationPage.this.setPageComplete(WizardNewSaturneModelCreationPage.this.validatePage());
        }
    };

    public WizardNewSaturneModelCreationPage(String pageName, boolean projectCreation) {
        super(pageName);
        this.projectCreation = projectCreation;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData parentData = new GridData();
        parentData.verticalAlignment = 4;
        parentData.grabExcessVerticalSpace = true;
        parentData.horizontalAlignment = 4;
        composite.setLayoutData((Object)parentData);
        if (this.projectCreation) {
            Label nameLabel = new Label(composite, 16384);
            nameLabel.setText("Nom du mod\u00e8le Saturne");
            GridData nameData = new GridData();
            nameData.horizontalAlignment = 4;
            nameLabel.setLayoutData((Object)nameData);
            this.modelNameText = new Text(composite, 2048);
            GridData nameDataText = new GridData();
            nameDataText.horizontalAlignment = 4;
            nameDataText.grabExcessHorizontalSpace = true;
            this.modelNameText.setLayoutData((Object)nameDataText);
            this.modelNameText.setText(String.valueOf(SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneEditorFilenameDefaultBase")) + "." + SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneEditorFilenameExtensions"));
            this.modelNameText.addModifyListener(this.validator);
        }
        Label encodingLabel = new Label(composite, 16384);
        encodingLabel.setText(SaturneEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
        GridData encodingData = new GridData();
        encodingData.horizontalAlignment = 4;
        encodingLabel.setLayoutData((Object)encodingData);
        this.encodingField = new Combo(composite, 2048);
        GridData encodingDataCombo = new GridData();
        encodingDataCombo.horizontalAlignment = 4;
        encodingDataCombo.grabExcessHorizontalSpace = true;
        this.encodingField.setLayoutData((Object)encodingDataCombo);
        for (String encoding : this.getEncodings()) {
            this.encodingField.add(encoding);
        }
        this.encodingField.select(0);
        this.encodingField.addModifyListener(this.validator);
        this.fullValidModel = new Button(composite, 32);
        this.fullValidModel.setText("Supprimer tous les \u00e9l\u00e9ments inutilis\u00e9s?");
        this.fullValidModel.setSelection(false);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    public void setDefaultModelName(String modelName) {
        if (modelName != null && !modelName.isEmpty()) {
            this.modelNameText.setText(String.valueOf(Character.toUpperCase(modelName.charAt(0))) + modelName.substring(1) + "." + SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneEditorFilenameExtensions"));
        }
    }

    private Collection<String> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(SaturneEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
            while (stringTokenizer.hasMoreTokens()) {
                this.encodings.add(stringTokenizer.nextToken());
            }
        }
        return this.encodings;
    }

    public boolean validatePage() {
        boolean isValid = true;
        if (this.projectCreation) {
            isValid = false;
            if (this.getModelName() != null) {
                String[] split = this.getModelName().split("\\.");
                String extension = split[split.length - 1];
                if (extension == null || !"saturne".equals(extension)) {
                    String key = SaturneModelWizardSpec.FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(SaturneEditorPlugin.INSTANCE.getString(key, new Object[]{SaturneModelWizardSpec.FORMATTED_FILE_EXTENSIONS}));
                } else {
                    isValid = true;
                }
            }
        }
        return isValid;
    }

    public String getEncoding() {
        return this.encodingField.getText();
    }

    public Boolean isFullValidModelToGenerate() {
        return this.fullValidModel.getSelection();
    }

    public String getModelName() {
        if (this.modelNameText != null) {
            return this.modelNameText.getText();
        }
        return "";
    }
}

