/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.all.rules;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import n4ds.dsn.p03v01.all.rules.ChaineUtil;

public class IdentiteControleurUtil {
    private ArrayList<String> messagesRetourControle = new ArrayList();
    private boolean resultatRetourControle;
    private final String msg_0 = "Pr\u00e9sence d'un ou plusieurs caract\u00e8res non autoris\u00e9s par la norme";
    private final String msg_1 = "Le premier caract\u00e8re d'une rubrique est un trait d'union ou un espace";
    private final String msg_2 = "Le dernier caract\u00e8re d'une rubrique est un trait d'union, une apostrophe ou un espace";
    private final String msg_3 = "Pr\u00e9sence d'une combinaison de trait d'union, d'apostrophe et d'espace interdite dans cette rubrique";
    private final String msg_4 = "Pr\u00e9sence de monsieur ou madame dans les champs identit\u00e9s";
    private final String msg_5 = "Caract\u00e8res non autoris\u00e9s pour les identit\u00e9s";
    private static final String TRAIT_UNION = "-";
    private static final String DOUBLE_TRAIT_UNION = "--";
    private static final String APOSTROPHE = "'";
    private static final String BLANC = " ";
    private static final String SANS_NOM = "SN";
    private static final String SANS_PRENOM = "SP";
    private ArrayList<String> chaineListeChars_1 = new ArrayList();
    private ArrayList<String> chaineListeChars_2 = new ArrayList();
    private ArrayList<String> chaineListeChars_3 = new ArrayList();
    private ArrayList<String> chaineListeChars_4 = new ArrayList();
    private ArrayList<String> chaineListeChars_5 = new ArrayList();
    private ArrayList<String> chaineListeChars_6 = new ArrayList();
    private final String regle = "(\\x2d\\w+)|(\\x20\\w+)";

    public IdentiteControleurUtil() {
        this.chaineListeChars_1.add(TRAIT_UNION);
        this.chaineListeChars_1.add(BLANC);
        this.chaineListeChars_2.add(TRAIT_UNION);
        this.chaineListeChars_2.add(BLANC);
        this.chaineListeChars_2.add(APOSTROPHE);
        this.chaineListeChars_3.add("  ");
        this.chaineListeChars_3.add("- ");
        this.chaineListeChars_3.add("' ");
        this.chaineListeChars_3.add(" '");
        this.chaineListeChars_3.add(" -");
        this.chaineListeChars_3.add("'-");
        this.chaineListeChars_3.add("-'");
        this.chaineListeChars_3.add("''");
        this.chaineListeChars_3.add("---");
        this.chaineListeChars_4 = this.chaineListeChars_3;
        this.chaineListeChars_5.add("MR ");
        this.chaineListeChars_5.add("Mr ");
        this.chaineListeChars_5.add("MONSIEUR ");
        this.chaineListeChars_5.add("Monsieur ");
        this.chaineListeChars_5.add("MADAME ");
        this.chaineListeChars_5.add("Madame ");
        this.chaineListeChars_5.add("MME ");
        this.chaineListeChars_5.add("Mme ");
        this.chaineListeChars_6.add(SANS_NOM);
        this.chaineListeChars_6.add(SANS_PRENOM);
        this.resultatRetourControle = true;
    }

    public void controleIdentite(String ligne) {
        Pattern identitePattern = Pattern.compile("[\\x21]|[\\x23-\\x25]|[\\x3b-\\x3c]|[\\x3e-\\x3f]|[\\x5b-\\x5e]|[\\x7b-\\x7e]|[\\xa0-\\xaa]|[\\xac-\\xaf]|[\\xb1-\\xba]|[\\xbc-\\xbf]|[\\xc6]|[\\xd0]|[\\xd7-\\xd8]|[\\xde-\\xdf]|[\\xe6]|[\\xf0]|[\\xf7-\\xf8]|[\\xfe]");
        Matcher identiteMatcher = identitePattern.matcher(ligne);
        if (identiteMatcher.find()) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Pr\u00e9sence d'un ou plusieurs caract\u00e8res non autoris\u00e9s par la norme");
        }
        if ((identiteMatcher = (identitePattern = Pattern.compile("[(\\x21-\\x26)(\\x28-\\x2c)(\\x2e-\\x2f)(\\x30-\\x40)(\\x5b-\\x60)(\\x7b-\\x7e)(\\xa0-\\xbf)(\\xc6)(\\xd0)(\\xd7-\\xd8)(\\xde-\\xdf)(\\xe6)(\\xf0)(\\xf7-\\xf8)(\\xfe)]")).matcher(ligne)).find()) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Caract\u00e8res non autoris\u00e9s pour les identit\u00e9s");
        }
        if (ChaineUtil.arrayExistsAtPos(this.chaineListeChars_1, ligne, "P")) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Le premier caract\u00e8re d'une rubrique est un trait d'union ou un espace");
        }
        if (ChaineUtil.arrayExistsAtPos(this.chaineListeChars_2, ligne, "d")) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Le dernier caract\u00e8re d'une rubrique est un trait d'union, une apostrophe ou un espace");
        }
        if (ChaineUtil.arrayExistsAtPos(this.chaineListeChars_4, ligne, "i")) {
            this.setResultatRetourControle(false);
            this.getMessagesRetourControle().add("Pr\u00e9sence d'une combinaison de trait d'union, d'apostrophe et d'espace interdite dans cette rubrique");
        }
    }

    public ArrayList<String> getMessagesRetourControle() {
        return this.messagesRetourControle;
    }

    public void setMessagesRetourControle(ArrayList<String> messagesRetourControle) {
        this.messagesRetourControle = messagesRetourControle;
    }

    public boolean getResultatRetourControle() {
        return this.resultatRetourControle;
    }

    public void setResultatRetourControle(boolean resultatRetourControle) {
        this.resultatRetourControle = resultatRetourControle;
    }

    public String getMsg_0() {
        return "Pr\u00e9sence d'un ou plusieurs caract\u00e8res non autoris\u00e9s par la norme";
    }

    public String getMsg_1() {
        return "Le premier caract\u00e8re d'une rubrique est un trait d'union ou un espace";
    }

    public String getMsg_2() {
        return "Le dernier caract\u00e8re d'une rubrique est un trait d'union, une apostrophe ou un espace";
    }

    public String getMsg_3() {
        return "Pr\u00e9sence d'une combinaison de trait d'union, d'apostrophe et d'espace interdite dans cette rubrique";
    }

    public String getMsg_4() {
        return "Pr\u00e9sence de monsieur ou madame dans les champs identit\u00e9s";
    }

    public String getMsg_5() {
        return "Caract\u00e8res non autoris\u00e9s pour les identit\u00e9s";
    }

    public String getTraitUnion() {
        return TRAIT_UNION;
    }

    public String getDoubleTraitUnion() {
        return DOUBLE_TRAIT_UNION;
    }

    public String getApostrophe() {
        return APOSTROPHE;
    }

    public String getBlanc() {
        return BLANC;
    }

    public String getSansNom() {
        return SANS_NOM;
    }

    public String getSansPrenom() {
        return SANS_PRENOM;
    }

    public ArrayList<String> getChaineListeChars_1() {
        return this.chaineListeChars_1;
    }

    public ArrayList<String> getChaineListeChars_2() {
        return this.chaineListeChars_2;
    }

    public ArrayList<String> getChaineListeChars_3() {
        return this.chaineListeChars_3;
    }

    public ArrayList<String> getChaineListeChars_4() {
        return this.chaineListeChars_4;
    }

    public ArrayList<String> getChaineListeChars_5() {
        return this.chaineListeChars_5;
    }

    public ArrayList<String> getChaineListeChars_6() {
        return this.chaineListeChars_6;
    }

    public String messagesRetourControleToString() {
        String res = "";
        for (String msg : this.getMessagesRetourControle()) {
            if (this.getMessagesRetourControle().size() == 1) {
                res = res.concat(String.valueOf(msg) + ".");
            }
            if (this.getMessagesRetourControle().size() <= 1) continue;
            res = this.getMessagesRetourControle().indexOf(msg) != this.getMessagesRetourControle().size() - 1 ? res.concat(String.valueOf(msg) + ". ") : res.concat(String.valueOf(msg) + ".");
        }
        return res;
    }
}

