/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.headless;

import fr.cnav.autocontrol.export.ReportExportType;
import fr.cnav.autocontrole.AutoCtrlValidator;
import fr.cnav.autocontrole.INormSelector;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.headless.ExitCodeKind;
import fr.cnav.autocontrole.headless.IntegerTester;
import fr.cnav.autocontrole.headless.Messages;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.normselector.NormSelectorImpl;
import fr.cnav.autocontrole.update.ProvisonningProductService;
import fr.cnav.autocontrole.update.UpdateException;
import fr.cnav.autocontrole.update.UpdateValService;
import fr.cnav.saturne.validator.registry.NormRegistryException;
import fr.cnav.saturne.validator.report.IReportConstants;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validate
implements IApplication {
    private static final String HEADER_LIST_NORM = Messages.HeaderListNorm;
    private static final String PLUGIN_ID = "fr.cnav.autocontrole.headless";
    private static final String APPLICATION_ID = "validate";
    public static final String VALIDATE_APPLICATION_ID = "fr.cnav.autocontrole.headless.validate";
    private static final String HELP_MESSAGE = "... -application fr.cnav.autocontrole.headless.validate [OPTS] <fichierDsn>";
    private static final Option HELP_OPTION = new Option(Messages.OptionHelpName, Messages.OptionHelpLongName, false, Messages.OptionHelpDesc);
    private static final Option OUTPUT_FOLDER_OPTION = new Option(Messages.OptionOutputFolderName, Messages.OptionOutputFolderLongName, true, Messages.OptionOutputFolderDesc);
    private static final Option ANOMALIE_LIMITE_OPTION = new Option(Messages.OptionLimitName, Messages.OptionLimitLongName, true, Messages.OptionLimitDesc);
    private static final Option ANOMALIE_GROUPING_OPTION = new Option(Messages.OptionGroupingName, Messages.OptionGroupingLongName, true, Messages.OptionGroupingDesc);
    private static final Option NO_CHECK_UPDATE_OPTION = new Option(Messages.OptionCheckUpdateName, Messages.OptionCheckUpdateLongName, false, Messages.OptionCheckUpdateDesc);
    private static final Option DO_UPDATE_OPTION = new Option(Messages.OptionDoUpdateName, Messages.OptionDoUpdateLongName, false, Messages.OptionDoUpdateDesc);
    private static final Option DO_XML_NATIVE_VALIDATION = new Option(Messages.OptionXmlNativeName, Messages.OptionXmlNativeLongName, false, Messages.OptionXmlNativeDesc);
    private static final Logger LOGGER = LoggerFactory.getLogger(Validate.class);
    private static final Options options = new Options();
    private static final HelpFormatter formatter = new HelpFormatter();
    private Integer exitCode = ExitCodeKind.EC_NO_ERROR.getCode();
    private File outputFile;
    private File inputMsg = null;
    private ReportExportType reportExportType;
    private String anomalieLimit;
    private Integer factorizationThreshold;
    private INormSelector normSelector;
    private boolean mustCheckUpdate;
    private boolean doUpdate;
    private boolean msgInXmlFormat = false;
    private static final String updateSiteUrl;
    private static final UpdateValService updateService;
    private static final ProvisonningProductService provisonningProductService;
    private static Map<Object, String> optionGrouping;

    static {
        OUTPUT_FOLDER_OPTION.setArgName(Messages.OptionOutputFolderArgName);
        ANOMALIE_LIMITE_OPTION.setArgName(Messages.OptionLimitArgName);
        ANOMALIE_GROUPING_OPTION.setArgName(Messages.OptionGroupingArgName);
        updateSiteUrl = System.getProperty("fr.cnav.autocontrole.updatesite.loc");
        updateService = new UpdateValService(updateSiteUrl);
        provisonningProductService = new ProvisonningProductService(updateSiteUrl);
        optionGrouping = new HashMap<Object, String>();
    }

    public void initOptions() {
        options.addOption(HELP_OPTION);
        options.addOption(OUTPUT_FOLDER_OPTION);
        options.addOption(ANOMALIE_LIMITE_OPTION);
        options.addOption(ANOMALIE_GROUPING_OPTION);
        options.addOption(NO_CHECK_UPDATE_OPTION);
        options.addOption(DO_UPDATE_OPTION);
        options.addOption(DO_XML_NATIVE_VALIDATION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseArguments(String[] args) {
        this.exitCode = ExitCodeKind.EC_NO_ERROR.getCode();
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption(HELP_OPTION.getOpt())) {
                this.printHelp();
                this.exitCode = ExitCodeKind.EC_NEED_HELP.getCode();
                return;
            }
            if (cmd.hasOption(DO_UPDATE_OPTION.getOpt())) {
                this.doUpdate = true;
                return;
            }
            this.doUpdate = false;
            if (cmd.hasOption(DO_XML_NATIVE_VALIDATION.getOpt())) {
                this.msgInXmlFormat = true;
            }
            if (cmd.getArgList().isEmpty()) {
                LOGGER.error(ExitCodeKind.EC_NO_INPUT_FILE.getMessage());
                this.printHelp();
                this.exitCode = ExitCodeKind.EC_NO_INPUT_FILE.getCode();
                return;
            }
            if (cmd.hasOption(ANOMALIE_LIMITE_OPTION.getOpt())) {
                String limitString = cmd.getOptionValue(ANOMALIE_LIMITE_OPTION.getOpt());
                if (!IntegerTester.isInt(limitString)) {
                    LOGGER.error(ExitCodeKind.EC_INVALID_LIMIT_ANOMALIE.getMessage(limitString));
                    this.printHelp();
                    this.exitCode = ExitCodeKind.EC_INVALID_LIMIT_ANOMALIE.getCode();
                    return;
                }
                this.anomalieLimit = limitString;
            } else {
                this.anomalieLimit = IReportConstants.UNLIMITED_ERRORS.toString();
            }
            if (cmd.hasOption(ANOMALIE_GROUPING_OPTION.getOpt())) {
                String value = cmd.getOptionValue(ANOMALIE_GROUPING_OPTION.getOpt());
                try {
                    this.factorizationThreshold = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    LOGGER.error(ExitCodeKind.EC_INVALID_LIMIT_ANOMALIE.getMessage(value));
                }
            } else {
                this.factorizationThreshold = -1;
            }
            this.mustCheckUpdate = !cmd.hasOption(NO_CHECK_UPDATE_OPTION.getOpt());
            this.reportExportType = ReportExportType.XML;
            String inputFileName = (String)cmd.getArgList().get(0);
            this.inputMsg = new File(inputFileName);
            if (!this.inputMsg.exists()) {
                LOGGER.error(ExitCodeKind.EC_INPUT_FILE_NOT_EXIST.getMessage(inputFileName));
                this.exitCode = ExitCodeKind.EC_INPUT_FILE_NOT_EXIST.getCode();
                return;
            }
            String msgExt = StandardHelper.getInstance().getNormDescriptor().getKBBasePackage();
            if (!cmd.hasOption(OUTPUT_FOLDER_OPTION.getOpt())) {
                this.outputFile = new File(String.valueOf(this.inputMsg.getAbsolutePath().replace("\\." + msgExt + "$", "")) + this.reportExportType.getExtensionPath());
                return;
            }
            this.outputFile = new File(cmd.getOptionValue(OUTPUT_FOLDER_OPTION.getOpt()));
            if (!this.outputFile.exists()) {
                LOGGER.error(ExitCodeKind.EC_OUTPUT_DIR_PARMETER_NOT_EXIST.getMessage(this.outputFile.getAbsolutePath()));
                this.exitCode = ExitCodeKind.EC_OUTPUT_DIR_PARMETER_NOT_EXIST.getCode();
                return;
            }
            if (this.outputFile.isDirectory()) {
                this.outputFile = new File(this.outputFile, String.valueOf(this.inputMsg.getName().replace("\\." + msgExt + "$", "")) + this.reportExportType.getExtensionPath());
                return;
            }
            LOGGER.error(ExitCodeKind.EC_OUTPUT_PARMETER_IS_NOT_DIR.getMessage(this.outputFile.getAbsolutePath()));
            this.exitCode = ExitCodeKind.EC_OUTPUT_PARMETER_IS_NOT_DIR.getCode();
            return;
        }
        catch (ParseException parseException) {
            LOGGER.error(ExitCodeKind.EC_INVALID_OPTION.getMessage());
            this.printHelp();
            this.exitCode = ExitCodeKind.EC_INVALID_OPTION.getCode();
            return;
        }
    }

    private void printHelp() {
        formatter.setWidth(100);
        formatter.setOptionComparator((Comparator)new OptionComparator());
        formatter.printHelp(HELP_MESSAGE, options);
        String headerNormsList = HEADER_LIST_NORM;
        String normList = this.getNormList();
        System.out.println("\n" + headerNormsList + " : " + normList);
    }

    private String getNormList() {
        StringBuilder normList = new StringBuilder();
        Set normIds = this.normSelector.getNormIds();
        for (String normIdTemp : normIds) {
            normList.append("\n" + normIdTemp + "-" + this.normSelector.getNormLabel(normIdTemp));
        }
        return normList.toString();
    }

    public Object start(IApplicationContext context) throws IOException, UpdateException {
        try {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            if (bundle == null) {
                System.err.println(String.format(Messages.ProductLaunchError, PLUGIN_ID));
                LOGGER.error(String.format(Messages.ProductLaunchError, PLUGIN_ID));
            }
            this.initOptions();
            String[] args = null;
            Map map = context.getArguments();
            for (Object key : map.keySet()) {
                if (!"application.args".equals(key)) continue;
                args = (String[])map.get(key);
            }
            this.exitCode = this.runValidation(args);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage());
            return ExitCodeKind.EC_TECHNICAL_ERROR.getCode();
        }
        return this.exitCode;
    }

    private int initNormSelector() {
        String normId = System.getProperty("fr.cnav.autocontrole.defaultnorm.id");
        try {
            if (normId == null || normId.equals("")) {
                throw new AutoCtrlException(this.getNormList(), ExceptionKind.CANNOT_SELECT_GIVEN_NORM, new Object[0]);
            }
            this.normSelector = new NormSelectorImpl();
            this.normSelector.setSelectedNorm(normId);
            StandardHelper.createNewStandardHelper((INormSelector)this.normSelector);
            StandardHelper.getInstance().initializeClasses();
            if (StandardHelper.getInstance().getNormDescriptor() == null || StandardHelper.getInstance().getNormDescriptor().getStandardAccessor() == null || StandardHelper.getInstance().getNormDescriptor().getStandardAccessor().getStandard() == null) {
                throw new AutoCtrlException(ExceptionKind.ERROR_CANNOT_RETRIEVE_BUNDLE);
            }
        }
        catch (NormRegistryException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return e.getCode();
        }
        return -1;
    }

    public int runValidation(String[] args) throws IOException {
        try {
            int returnCode = this.initNormSelector();
            if (returnCode != -1) {
                return returnCode;
            }
            this.parseArguments(args);
            if (this.exitCode.intValue() != ExitCodeKind.EC_NO_ERROR.getCode()) {
                return this.exitCode;
            }
            if (this.mustCheckUpdate || this.doUpdate) {
                boolean mustUpdate;
                try {
                    provisonningProductService.isUpdateSite();
                    mustUpdate = updateService.checkForUpdate((IProgressMonitor)new NullProgressMonitor());
                }
                catch (UpdateException e) {
                    switch (e.getCode()) {
                        case 2: {
                            LOGGER.error(ExitCodeKind.EC_NEED_HELP.getMessage(updateSiteUrl));
                            return ExitCodeKind.EC_NEED_HELP.getCode();
                        }
                        case 3: {
                            LOGGER.error(ExitCodeKind.EC_UPDATESITE_NOT_AVAILABLE.getMessage(updateSiteUrl));
                            return ExitCodeKind.EC_UPDATESITE_NOT_AVAILABLE.getCode();
                        }
                        case 1: {
                            LOGGER.error(ExitCodeKind.EC_INCORRECT_URI_UPDATESITE.getMessage(updateSiteUrl));
                            return ExitCodeKind.EC_INCORRECT_URI_UPDATESITE.getCode();
                        }
                        case 0: {
                            LOGGER.error(ExitCodeKind.EC_EMPTY_UPDATESITE.getMessage(updateSiteUrl));
                            return ExitCodeKind.EC_EMPTY_UPDATESITE.getCode();
                        }
                        case 5: {
                            LOGGER.error(ExitCodeKind.EC_UPDATESITE_NOT_AVAILABLE.getMessage(updateSiteUrl));
                            return ExitCodeKind.EC_UPDATESITE_NOT_AVAILABLE.getCode();
                        }
                    }
                    LOGGER.error(ExitCodeKind.EC_UPDATESITE_NOT_AVAILABLE.getMessage(updateSiteUrl));
                    return ExitCodeKind.EC_UPDATESITE_NOT_AVAILABLE.getCode();
                }
                if (mustUpdate && this.doUpdate) {
                    LOGGER.info(Messages.ProductRunningUpdate);
                    try {
                        updateService.update((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (UpdateException e) {
                        LOGGER.error(ExitCodeKind.EC_UPDATE_PRODUCT_FAILED.getMessage(e.getMessage()));
                        return ExitCodeKind.EC_UPDATE_PRODUCT_FAILED.getCode();
                    }
                    LOGGER.info(ExitCodeKind.EC_UPDATE_PRODUCT_DONE.getMessage());
                    return ExitCodeKind.EC_UPDATE_PRODUCT_DONE.getCode();
                }
                if (this.doUpdate) {
                    LOGGER.info(ExitCodeKind.EC_PRODUCT_ALREADY_UP_TO_DATE.getMessage());
                    return ExitCodeKind.EC_PRODUCT_ALREADY_UP_TO_DATE.getCode();
                }
                if (mustUpdate) {
                    LOGGER.error(ExitCodeKind.EC_MUST_UPDATE_PRODUCT.getMessage());
                    return ExitCodeKind.EC_MUST_UPDATE_PRODUCT.getCode();
                }
            }
            MessageFile messageFile = new MessageFile(this.inputMsg);
            messageFile.setMsgInXmlFormat(this.msgInXmlFormat);
            AutoCtrlValidator autoCtrlValidator = new AutoCtrlValidator(this.anomalieLimit, this.factorizationThreshold);
            boolean isIntegrityValidated = false;
            try {
                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                autoCtrlValidator.pepareValidationEnvironment((IProgressMonitor)nullProgressMonitor);
                LOGGER.info(String.format(Messages.ValidationTestInegrity, this.inputMsg.getAbsolutePath(), this.normSelector.getNormLabel()));
                isIntegrityValidated = autoCtrlValidator.validateIntegrity((IProgressMonitor)nullProgressMonitor, StandardHelper.getInstance().getNormDescriptor());
                if (!isIntegrityValidated) {
                    LOGGER.error(ExitCodeKind.EC_MSG_INTEGRITY_TEST_FAILED.getMessage(this.inputMsg.getAbsolutePath(), this.normSelector.getNormLabel()));
                    return ExitCodeKind.EC_MSG_INTEGRITY_TEST_FAILED.getCode();
                }
                LOGGER.info(String.format(Messages.ValidationRunning, this.inputMsg.getAbsolutePath(), this.normSelector.getNormLabel()));
                autoCtrlValidator.validate((IProgressMonitor)nullProgressMonitor);
            }
            catch (AutoCtrlException e) {
                LOGGER.error(e.getMessage());
                System.out.println(e.getCode());
                return e.getCode();
            }
            if (isIntegrityValidated) {
                boolean success;
                LOGGER.info(String.format(Messages.ValidationEnd1, MessageFile.getInstance().getAnomalies().size()));
                LOGGER.info(String.format(Messages.ValidationEnd2, this.outputFile.getAbsolutePath()));
                File reportFileTemp = new File(MessageFile.getInstance().getReportTempFilePath());
                if (this.outputFile.exists()) {
                    this.outputFile.delete();
                }
                if (!(success = reportFileTemp.renameTo(this.outputFile))) {
                    LOGGER.error(ExceptionKind.ERROR_SERIALISATION_REPORT_HEADLESS.getMessage(new Object[]{this.outputFile.getAbsolutePath(), reportFileTemp.getAbsolutePath()}));
                    System.out.println(ExceptionKind.ERROR_SERIALISATION_REPORT_HEADLESS.getMessage(new Object[]{this.outputFile.getAbsolutePath(), reportFileTemp.getAbsolutePath()}));
                    return ExceptionKind.ERROR_SERIALISATION_REPORT_HEADLESS.getCode();
                }
                LOGGER.info(Messages.ValidationEnd3);
            }
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
            t.printStackTrace();
            return ExitCodeKind.EC_TECHNICAL_ERROR.getCode();
        }
        return this.exitCode;
    }

    public void stop() {
    }

    private static class OptionComparator
    implements Comparator<Option> {
        private OptionComparator() {
        }

        @Override
        public int compare(Option o1, Option o2) {
            String cat1 = (String)optionGrouping.get(o1);
            cat1 = cat1 == null ? "" : cat1;
            String cat2 = (String)optionGrouping.get(o2);
            String string = cat2 = cat2 == null ? "" : cat2;
            if (cat1.equals(cat2)) {
                if (optionGrouping.containsValue(o1.getOpt())) {
                    return -1;
                }
                if (optionGrouping.containsValue(o2.getOpt())) {
                    return 1;
                }
                return o1.getOpt().compareToIgnoreCase(o2.getOpt());
            }
            return cat1.compareTo(cat2);
        }
    }
}

