/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.all.rules;

import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.IFieldLocalizer;
import fr.cnav.saturne.validator.SequentialLocalizer;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.IRuleWithId;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import n4ds.dsn.p03v01.all.rules.StructureConstants;

public class RuleS21_G00_41_028_CCH_11
implements IRuleWithId,
StructureConstants {
    private final RuleCriticity ruleCriticity;
    private final BlockDescription context;
    private final FieldDescription subject;
    private final MessageElementFactory messageElementFactory;
    public static final int ID = 27;
    public static final String MESSAGE = "Vous n'avez pas d\u00e9clar\u00e9 la rubrique \"Profondeur de recalcul de la paie - S21.G00.41.028\" pour le bloc \"Changements Contrat - S21.G00.41\" pr\u00e9sentant la \"Date de la modification - S21.G00.41.001\" la plus ancienne, pour un m\u00eame contrat (S21.G00.40) et une m\u00eame modalit\u00e9 (se r\u00e9f\u00e9rer au principe (c) du paragraphe 4.4.14.2 : \u00ab Obligation ou interdiction de d\u00e9clarer la date de profondeur de recalcul de la paie pour le changement d\u2019une modalit\u00e9 \u00bb). Ceci n'est pas admis.";
    private MessageElementDescription deepestAncestor;
    private final StandardAccessor modelAccessor;
    public static final String[] USED_DATA = new String[]{"S21.G00.41.028", "S21.G00.40", "S21.G00.41", "S21.G00.41.002", "S21.G00.41.003", "S21.G00.41.004", "S21.G00.41.005", "S21.G00.41.006", "S21.G00.41.007", "S21.G00.41.008", "S21.G00.41.010", "S21.G00.41.011", "S21.G00.41.013", "S21.G00.41.016", "S21.G00.41.017", "S21.G00.41.018", "S21.G00.41.019", "S21.G00.41.020", "S21.G00.41.022", "S21.G00.41.023", "S21.G00.41.024", "S21.G00.41.025", "S21.G00.41.027", "S21.G00.41.029", "S21.G00.41.030", "S21.G00.41.016", "S21.G00.41.031", "S21.G00.41.032", "S21.G00.41.033", "S21.G00.41.034", "S21.G00.41.035", "S21.G00.41.036", "S21.G00.41.037", "S21.G00.41.038", "S21.G00.41.039", "S21.G00.41.040", "S21.G00.41.041", "S21.G00.41.042", "S21.G00.41.043", "S21.G00.41.016", "S21.G00.41.044", "S21.G00.41.045", "S21.G00.41.046", "S21.G00.41.047", "S21.G00.41.048", "S21.G00.41.049", "S21.G00.41.050", "S21.G00.41.051", "S21.G00.41.052", "S21.G00.41.053", "S21.G00.41.055", "S21.G00.41.056", "S21.G00.41.057", "S21.G00.41.058", "S21.G00.41.059", "S21.G00.41.060", "S21.G00.41.061", "S21.G00.41.062", "S21.G00.41.063", "S21.G00.41.064", "S21.G00.41.065"};
    public static final ArrayList<String> MODALITE_TYPE = new ArrayList<String>(Arrays.asList("S21.G00.41.002", "S21.G00.41.003", "S21.G00.41.004", "S21.G00.41.005", "S21.G00.41.006", "S21.G00.41.007", "S21.G00.41.008", "S21.G00.41.010", "S21.G00.41.011", "S21.G00.41.013", "S21.G00.41.016", "S21.G00.41.017", "S21.G00.41.018", "S21.G00.41.019", "S21.G00.41.020", "S21.G00.41.022", "S21.G00.41.023", "S21.G00.41.024", "S21.G00.41.025", "S21.G00.41.027", "S21.G00.41.029", "S21.G00.41.030", "S21.G00.41.016", "S21.G00.41.031", "S21.G00.41.032", "S21.G00.41.033", "S21.G00.41.034", "S21.G00.41.035", "S21.G00.41.036", "S21.G00.41.037", "S21.G00.41.038", "S21.G00.41.039", "S21.G00.41.040", "S21.G00.41.041", "S21.G00.41.042", "S21.G00.41.043", "S21.G00.41.016", "S21.G00.41.044", "S21.G00.41.045", "S21.G00.41.046", "S21.G00.41.047", "S21.G00.41.048", "S21.G00.41.049", "S21.G00.41.050", "S21.G00.41.051", "S21.G00.41.052", "S21.G00.41.053", "S21.G00.41.055", "S21.G00.41.056", "S21.G00.41.057", "S21.G00.41.058", "S21.G00.41.059", "S21.G00.41.060", "S21.G00.41.061", "S21.G00.41.062", "S21.G00.41.063", "S21.G00.41.064", "S21.G00.41.065"));

    public RuleS21_G00_41_028_CCH_11(StandardAccessor modelAccessor) {
        this.context = modelAccessor.getBlockDescription("S21.G00.40");
        this.subject = modelAccessor.getFieldDescription("S21.G00.41.028");
        this.messageElementFactory = new MessageElementFactory(modelAccessor);
        this.modelAccessor = modelAccessor;
        this.ruleCriticity = RuleCriticity.BLOCKING;
    }

    public int getUniqueId() {
        return 27;
    }

    public List<FieldDescription> getUsedData() {
        throw new UnsupportedOperationException("shouldn't be used");
    }

    public MessageElementDescription getDeepestAncestor() {
        return this.deepestAncestor;
    }

    public BlockDescription getContext() {
        return this.context;
    }

    public RuleCriticity getCriticity() {
        return this.ruleCriticity;
    }

    public String getCode() {
        return "S21.G00.41.028/CCH-11";
    }

    public FieldDescription getSubject() {
        return this.subject;
    }

    private Iterable<IMessageFieldDate> getSubject(IMessageBlock context) {
        IMessageBlock ctxt = context;
        Iterable<IMessageFieldDate> s21_G00_41_028 = null;
        Stream<Object> ctxtStream = ctxt == null ? Stream.empty() : Stream.of(ctxt);
        Stream<IMessageBlock> _s21_G00_41Stream = ctxtStream == null ? Stream.empty() : ctxtStream.map(b -> b.getBlock(0)).flatMap(Collection::stream).filter(Objects::nonNull);
        Stream<IMessageFieldDate> s21_G00_41_028Stream = _s21_G00_41Stream.map(b -> b.getField(24)).filter(IMessageFieldDate.class::isInstance).map(IMessageFieldDate.class::cast).filter(Objects::nonNull);
        s21_G00_41_028 = s21_G00_41_028Stream::iterator;
        return s21_G00_41_028;
    }

    private int getSubjectBestLineNumber(IMessageBlock context) {
        IMessageBlock ctxt = context;
        int lineNumber = ctxt.getFirstLine();
        Stream<Object> ctxtStream = ctxt == null ? Stream.empty() : Stream.of(ctxt);
        return lineNumber;
    }

    public IRuleResult run(IMessageBlock block) {
        boolean result = true;
        IMessageBlock faultyBlock = null;
        for (IMessageBlock block41 : block.getBlock(0)) {
            Date olderDate;
            boolean isBlockWithModalite = false;
            for (IMessageField field : block41.getFields()) {
                if (!MODALITE_TYPE.contains(field.getStandardFieldDescription().getFullQualifiedId())) continue;
                isBlockWithModalite = true;
            }
            if (!isBlockWithModalite) {
                if (block41.getField(24) == null) continue;
                result = false;
                faultyBlock = block41;
                continue;
            }
            List<IMessageBlock> block41sSameModalite = this.getOtherBlock41(block41);
            if (block41sSameModalite.isEmpty()) {
                if (block41.getField(24) != null) continue;
                result = false;
                faultyBlock = block41;
                continue;
            }
            Date block41DateModif = this.getDateModifFromBlock(block41);
            if (block41DateModif.before(olderDate = this.getOlderDate(block41sSameModalite))) {
                if (block41.getField(24) != null) continue;
                result = false;
                faultyBlock = block41;
                continue;
            }
            if (block41DateModif.after(olderDate)) {
                if (block41.getField(24) == null) continue;
                result = false;
                faultyBlock = block41;
                continue;
            }
            List<IMessageBlock> block41sSameDateAndSameModalite = this.getBlocksWithDate(block41DateModif, block41sSameModalite);
            boolean isDateDefinedOnOtherBlock = false;
            for (IMessageBlock block41SameDateAndSameModalite : block41sSameDateAndSameModalite) {
                if (block41SameDateAndSameModalite.getField(24) == null) continue;
                isDateDefinedOnOtherBlock = true;
            }
            if (block41.getField(24) != null && isDateDefinedOnOtherBlock) {
                result = false;
                faultyBlock = block41;
                continue;
            }
            if (block41.getField(24) != null || isDateDefinedOnOtherBlock) continue;
            result = false;
            faultyBlock = block41;
        }
        if (result) {
            return IRule.SUCCESS;
        }
        IMessageBlock targetBlock = faultyBlock != null ? faultyBlock : block;
        MessageField subject = this.messageElementFactory.createMessageField(this.getSubject().getFullQualifiedId(), null, (IFieldLocalizer)new SequentialLocalizer(this.getSubjectBestLineNumber(targetBlock)));
        return new RuleFailure((IRule)this, (IMessageField)subject, block, MESSAGE);
    }

    private List<IMessageBlock> getBlocksWithDate(Date date, List<IMessageBlock> blocks) {
        ArrayList<IMessageBlock> blocksWithDate = new ArrayList<IMessageBlock>();
        for (IMessageBlock block : blocks) {
            if (date == null || !date.equals(this.getDateModifFromBlock(block))) continue;
            blocksWithDate.add(block);
        }
        return blocksWithDate;
    }

    private Date getOlderDate(List<IMessageBlock> blocks) {
        Date olderDate = null;
        for (IMessageBlock block : blocks) {
            Date blockDate = this.getDateModifFromBlock(block);
            if (olderDate != null && !blockDate.before(olderDate)) continue;
            olderDate = blockDate;
        }
        return olderDate;
    }

    private Date getDateModifFromBlock(IMessageBlock block) {
        IMessageFieldDate field = (IMessageFieldDate)block.getField(0);
        return (Date)field.getValue();
    }

    private List<IMessageBlock> getOtherBlock41(IMessageBlock currentBlock41) {
        ArrayList<IMessageBlock> block41sSameModalite = new ArrayList<IMessageBlock>();
        String currentModalite = this.getModaliteFromBloc(currentBlock41);
        List block41s = currentBlock41.getParent().getBlock(0);
        for (IMessageBlock block41 : block41s) {
            if (block41 == currentBlock41 || currentModalite == null || !currentModalite.equals(this.getModaliteFromBloc(block41))) continue;
            block41sSameModalite.add(block41);
        }
        return block41sSameModalite;
    }

    private String getModaliteFromBloc(IMessageBlock block) {
        for (IMessageField field : block.getFields()) {
            String fieldFullQualifiedId = field.getStandardFieldDescription().getFullQualifiedId();
            if (!MODALITE_TYPE.contains(fieldFullQualifiedId)) continue;
            return fieldFullQualifiedId;
        }
        return null;
    }
}

