/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SimpleDslFormatter {
    private static final String INDENT_SPACE = " ";
    private static final Pattern PATTERNE_DSL_BOOLEAN = Pattern.compile("or|and|<=>|=>");

    private SimpleDslFormatter() {
    }

    public static String format(String expression) {
        if (expression == null) {
            return "";
        }
        String cleanExpression = expression.replaceAll("[\\n\\r\\s]+", INDENT_SPACE);
        StringBuilder builder = new StringBuilder();
        Matcher matcher = PATTERNE_DSL_BOOLEAN.matcher(cleanExpression);
        int indentSize = 0;
        int lastIndex = 0;
        while (matcher.find()) {
            builder.append(SimpleDslFormatter.indent(indentSize));
            builder.append(cleanExpression.substring(lastIndex, matcher.start()));
            builder.append("\n");
            builder.append(SimpleDslFormatter.indent(indentSize));
            builder.append(cleanExpression.substring(matcher.start(), matcher.end()));
            builder.append("\n");
            ++indentSize;
            lastIndex = matcher.end();
        }
        builder.append(SimpleDslFormatter.indent(indentSize));
        builder.append(cleanExpression.substring(lastIndex, cleanExpression.length()));
        return builder.toString();
    }

    protected static String indent(int size) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < size) {
            builder.append(INDENT_SPACE);
            ++i;
        }
        return builder.toString();
    }
}

