/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.types.adapter;

import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.parser.Logging;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import java.util.Map;
import java.util.logging.Level;

public class LogicalNaryTypeAdapter
extends DSLTypeAdapter {
    @Override
    Type computeType(Type context, Map<String, Type> env) {
        assert (this.getTarget() instanceof Nary);
        Type result = Type.BOOLEAN;
        Nary target = (Nary)this.getTarget();
        for (Expression expr : target.getOperands()) {
            DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt(expr);
            Type type = adapter.getType(Type.UNDEFINED, env);
            if (type == Type.UNDEFINED) {
                this.setErrorMsg(adapter.getErrorMsg());
                result = Type.UNDEFINED;
                break;
            }
            if (type == Type.BOOLEAN) continue;
            this.setErrorMsg("N4DSType : Logical operator's operands must be of boolean type : " + (Object)((Object)adapter.getType(context, env)));
            result = Type.UNDEFINED;
            break;
        }
        if (result == Type.UNDEFINED) {
            Logging.LOGGER.log(Level.SEVERE, this.getErrorMsg());
        }
        return result;
    }
}

