/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.vn;

import fr.cnav.saturne.dsl.formules.AlphaNum;
import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Date;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Num;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.optimization.vn.HashedExpression;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;

public class EquivalentExpr
extends FormulesSwitch<Boolean> {
    private Binding otherB;
    private IteratorVariable otherVariable;
    private Stack<Expression> stack = new Stack();

    public boolean equivalent(Expression expr1, Expression expr2) {
        this.stack.push(expr2);
        return (Boolean)this.doSwitch(expr1);
    }

    protected boolean equivalent(Binding binding1, Binding binding2) {
        this.otherB = binding2;
        return (Boolean)this.doSwitch(binding1);
    }

    protected boolean equivalent(IteratorVariable var1, IteratorVariable var2) {
        this.otherVariable = var2;
        return (Boolean)this.doSwitch(var1);
    }

    @Override
    public Boolean caseAlphaNum(AlphaNum object) {
        Expression other = this.stack.pop();
        if (!(other instanceof AlphaNum)) {
            return false;
        }
        AlphaNum otherAlpha = (AlphaNum)other;
        return otherAlpha.getValue().equals(object.getValue());
    }

    @Override
    public Boolean caseNum(Num object) {
        Expression other = this.stack.pop();
        if (!(other instanceof Num)) {
            return false;
        }
        Num otherAlpha = (Num)other;
        return otherAlpha.getValue().equals(object.getValue());
    }

    @Override
    public Boolean caseDate(Date object) {
        Expression other = this.stack.pop();
        if (!(other instanceof Date)) {
            return false;
        }
        Date otherDate = (Date)other;
        return otherDate.getValue().equals(object.getValue());
    }

    @Override
    public Boolean caseBinary(Binary object) {
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass()) {
            Binary otherBinary = (Binary)other;
            if (this.equivalent(object.getLeftOp(), otherBinary.getLeftOp()) && this.equivalent(object.getRightOp(), otherBinary.getRightOp())) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Boolean caseFunctionCall(FunctionCall object) {
        Expression other = this.stack.pop();
        if (object.eClass() == other.eClass()) {
            FunctionCall otherCall = (FunctionCall)other;
            if (otherCall.getName().equals(object.getName())) {
                EList<Expression> args = object.getArguments();
                EList<Expression> otherArgs = otherCall.getArguments();
                if (args.size() != otherArgs.size()) {
                    return false;
                }
                int i = 0;
                while (i < args.size()) {
                    if (!this.equivalent((Expression)args.get(i), (Expression)otherArgs.get(i))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Boolean caseIn(In object) {
        Expression other = this.stack.pop();
        if (other.eClass() != object.eClass()) {
            return false;
        }
        In in = (In)other;
        if (this.equivalent(in.getLeftOp(), object.getLeftOp()) && this.equivalent(in.getRightOp(), object.getRightOp())) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean caseVarRef(VarRef object) {
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass() && ((VarRef)other).getVarName().equals(object.getVarName())) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean caseValueList(ValueList object) {
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass()) {
            ValueList valueList = (ValueList)other;
            EList<Literal> list = object.getValues();
            EList<Literal> otherList = valueList.getValues();
            if (list.size() != otherList.size()) {
                return false;
            }
            int i = 0;
            while (i < list.size()) {
                if (!((Literal)list.get(i)).getValue().equals(((Literal)otherList.get(i)).getValue())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean caseNary(Nary object) {
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass()) {
            Nary otherNary = (Nary)other;
            EList<Expression> operands = object.getOperands();
            EList<Expression> otherOps = otherNary.getOperands();
            if (operands.size() != otherOps.size()) {
                return false;
            }
            int i = 0;
            while (i < operands.size()) {
                if (!this.equivalent((Expression)operands.get(i), (Expression)otherOps.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public Boolean caseBinding(Binding object) {
        Binding other = this.otherB;
        if (other.getVarName().equals(object.getVarName())) {
            return this.equivalent(other.getExpr(), object.getExpr());
        }
        return false;
    }

    @Override
    public Boolean caseLet(Let object) {
        boolean result;
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass()) {
            Let otherLet = (Let)other;
            EList<Binding> bindings = object.getBindings();
            EList<Binding> otherBindings = otherLet.getBindings();
            if (bindings.size() == otherBindings.size()) {
                int i = 0;
                while (i < bindings.size()) {
                    if (!this.equivalent((Binding)bindings.get(i), (Binding)otherBindings.get(i))) {
                        return false;
                    }
                    ++i;
                }
                result = this.equivalent(object.getIn(), otherLet.getIn());
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public Boolean caseIteratorVariable(IteratorVariable object) {
        IteratorVariable other = this.otherVariable;
        String otherName = other.getVarName();
        String name = object.getVarName();
        if (otherName != null && name != null && name.equals(otherName)) {
            return this.equivalent(other.getElement(), object.getElement());
        }
        return false;
    }

    @Override
    public Boolean caseQuantified(Quantified object) {
        boolean result;
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass()) {
            Quantified otherQuantified = (Quantified)other;
            if (otherQuantified.getQuantifier() == object.getQuantifier()) {
                EList<IteratorVariable> variables = object.getVariables();
                EList<IteratorVariable> otherVars = otherQuantified.getVariables();
                int size = variables.size();
                int i = 0;
                while (i < size) {
                    if (!this.equivalent((IteratorVariable)variables.get(i), (IteratorVariable)otherVars.get(i))) {
                        return false;
                    }
                    ++i;
                }
                result = this.equivalent(object.getExpression(), otherQuantified.getExpression());
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public Boolean caseFieldRef(FieldRef object) {
        boolean result;
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass()) {
            HashedExpression he1 = new HashedExpression(object);
            HashedExpression he2 = new HashedExpression(other);
            if (he1.toString().equals(he2.toString())) {
                String var1 = object.getContextVariable();
                String var2 = ((FieldRef)other).getContextVariable();
                result = var1 == null ? var2 == null : var1.equals(var2);
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public Boolean caseNot(Not object) {
        Expression other = this.stack.pop();
        if (other.eClass() == object.eClass()) {
            Not otherNot = (Not)other;
            return this.equivalent(object.getOperand(), otherNot.getOperand());
        }
        return false;
    }
}

