/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.ControlType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.IdQualifiedElementDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;

public class GenericRuleDescription
implements IdQualifiedElementDescription {
    protected GenericRule genericRule;
    private BlockDescription context;
    private BlockDescription computedContext;
    private FieldDescription subject;

    public GenericRuleDescription(GenericRule theGenericRule, StandardMapUtils standardMapUtils) {
        Block ruleComputedContext;
        Field ruleSubject;
        this.genericRule = theGenericRule;
        standardMapUtils.updateMaps(this.getFullQualifiedId(), this);
        Block ruleContext = this.genericRule.getContext();
        if (ruleContext != null) {
            this.context = standardMapUtils.getBlockDescription(ruleContext.getFullQualifiedId());
        }
        if ((ruleSubject = this.genericRule.getSubject()) != null) {
            this.subject = standardMapUtils.getFieldDescription(ruleSubject.getFullQualifiedId());
        }
        if ((ruleComputedContext = this.genericRule.getComputedContext()) != null) {
            this.computedContext = standardMapUtils.getBlockDescription(ruleComputedContext.getFullQualifiedId());
        }
    }

    public BlockDescription getContext() {
        return this.context;
    }

    public FieldDescription getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.genericRule.getMessage();
    }

    public ControlType getType() {
        return this.genericRule.getType();
    }

    public RuleCriticity getCriticity() {
        return this.genericRule.getCriticity();
    }

    public BlockDescription getComputedContext() {
        return this.computedContext;
    }

    @Override
    public String getName() {
        return this.genericRule.getName();
    }

    @Override
    public String getDescription() {
        return this.genericRule.getDescription();
    }

    @Override
    public String getComment() {
        return this.genericRule.getComment();
    }

    @Override
    public String getId() {
        return this.genericRule.getId();
    }

    @Override
    public String getFullQualifiedId() {
        return this.genericRule.getFullId();
    }
}

