/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ui.dialogs.IStyledStringHighlighter;

public class StyledStringHighlighter
implements IStyledStringHighlighter {
    private static final String QMARK = "?";
    private static final String ASTERISK = "*";
    private static final char TERMINATOR = '<';

    @Override
    public StyledString highlight(String text, String pattern, StyledString.Styler styler) {
        if (text == null || text.isEmpty()) {
            return new StyledString();
        }
        StyledString styledString = new StyledString(text);
        if (pattern == null || pattern.isEmpty() || ASTERISK.equals(pattern) || QMARK.equals(pattern)) {
            return styledString;
        }
        pattern = this.removeEndTerminator(pattern);
        pattern = this.replaceConsecutiveAsterisks(pattern);
        pattern = this.escapeSpecialCharacters(pattern);
        try {
            this.highlight(text, pattern, styledString, styler);
        }
        catch (Exception exception) {}
        return styledString;
    }

    private String removeEndTerminator(String filterPattern) {
        int numEndTerminators = 0;
        int i = filterPattern.length() - 1;
        while (i >= 0) {
            if (filterPattern.charAt(i) != '<') break;
            ++numEndTerminators;
            --i;
        }
        filterPattern = filterPattern.substring(0, filterPattern.length() - numEndTerminators);
        return filterPattern;
    }

    private String replaceConsecutiveAsterisks(String filterPattern) {
        return filterPattern.replaceAll("(\\*)\\1+", ASTERISK);
    }

    private String escapeSpecialCharacters(String filterPattern) {
        boolean startsWithSpecialChar = filterPattern.startsWith(ASTERISK) || filterPattern.startsWith(QMARK);
        boolean endsWithSpecialChar = filterPattern.endsWith(ASTERISK) || filterPattern.endsWith(QMARK);
        filterPattern = filterPattern.replace(ASTERISK, "\\E).*(\\Q");
        filterPattern = filterPattern.replace(QMARK, "\\E).(\\Q");
        if (!startsWithSpecialChar) {
            filterPattern = "(\\Q" + filterPattern;
        }
        if (!endsWithSpecialChar) {
            filterPattern = String.valueOf(filterPattern) + "\\E)";
        }
        int start = filterPattern.startsWith("\\E)") ? 3 : 0;
        int end = filterPattern.length() - (filterPattern.endsWith("(\\Q") ? 3 : 0);
        return filterPattern.substring(start, end);
    }

    private void highlight(String text, String filterPattern, StyledString styledString, StyledString.Styler boldStyler) {
        Pattern pattern = Pattern.compile(filterPattern, 2);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (groupCount == 0) {
                styledString.setStyle(matcher.start(), matcher.end() - matcher.start(), boldStyler);
                continue;
            }
            int i = 1;
            while (i <= groupCount) {
                styledString.setStyle(matcher.start(i), matcher.end(i) - matcher.start(i), boldStyler);
                ++i;
            }
        }
    }
}

