/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.app.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.BlockingQueue;

public class FolderWatcher
implements Runnable {
    private File folderToWatch;
    private BlockingQueue<File> inputFileQueue;
    private WatchService watchService;
    private String extFilter;

    public FolderWatcher(File aFolder, BlockingQueue<File> inputFileQueue, String extFilter) throws IOException {
        this.folderToWatch = aFolder;
        this.inputFileQueue = inputFileQueue;
        this.extFilter = extFilter;
        this.initWatchFolder();
    }

    private void initWatchFolder() throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        Path path = this.folderToWatch.toPath();
        path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
    }

    private void runLoopWatchFolder() throws InterruptedException {
        WatchKey key;
        while ((key = this.watchService.take()) != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent<?> ev = event;
                Path filename = (Path)ev.context();
                if (!filename.toFile().getName().matches(this.extFilter)) continue;
                File currentFile = new File(this.folderToWatch + "/" + filename.toFile().getName());
                this.inputFileQueue.add(currentFile);
            }
            key.reset();
        }
    }

    @Override
    public void run() {
        try {
            this.runLoopWatchFolder();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

