/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole;

import fr.cnav.autocontrole.AutocontrolPlugin;
import fr.cnav.autocontrole.INormSerializer;
import fr.cnav.autocontrole.Messages;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.helpers.ZipApacheUtil;
import fr.cnav.autocontrole.helpers.ZipUtil;
import fr.cnav.autocontrole.messageparser.Context2DeclarationCaches;
import fr.cnav.autocontrole.messageparser.MessageParserForIndividual;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.service.ValidationListenerImpl;
import fr.cnav.autocontrole.service.ValidationServiceException;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.Anomaly;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ValidationInformation;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.autocontrol.registry.IIndividualFieldRegistry;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialLineReader;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.functions.ValidationFunctions;
import fr.cnav.saturne.validator.impl.FormatType;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.report.IReportConstants;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.service.IValidationListener;
import fr.cnav.saturne.validator.service.ValidationEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class AutoCtrlValidator {
    public static final String PROJECT_NAME = "autoctrlprj";
    public static final String CONVERSION_FOLDER = "autoctrldsn/output/conversions";
    public static final String REPORT_FOLDER = "autoctrldsn/output/report";
    private static final String CONVERTED_FILE_EXTENSION = ".xml";
    private IProject autoCtrlProject;
    private IFolder conversionIFolder;
    private IFolder reportIFolder;
    private String validatorServiceLimtLoggedErrors;
    private String factorizationThreshold;

    public AutoCtrlValidator() {
        this(IReportConstants.UNLIMITED_ERRORS.toString(), -1);
    }

    public AutoCtrlValidator(String limtLoggedErrors, Integer factorizationThreshold) {
        this.validatorServiceLimtLoggedErrors = limtLoggedErrors;
        this.factorizationThreshold = factorizationThreshold.toString();
    }

    public void validate(IProgressMonitor monitor) throws AutoCtrlException {
        this.executeValidate(monitor);
        try {
            this.refreshValidateFolders();
        }
        catch (CoreException e) {
            throw new AutoCtrlException(ExceptionKind.CANNOT_REFRESH_FOLDER, (Throwable)e);
        }
        MessageFile.getInstance().initializeReportProvider();
    }

    private void prepareAutoCtrlFolder() throws CoreException {
        this.conversionIFolder = this.autoCtrlProject.getFolder(CONVERSION_FOLDER);
        this.reportIFolder = this.autoCtrlProject.getFolder(REPORT_FOLDER);
        AutoCtrlValidator.recusiveCreationHelper(this.conversionIFolder);
        AutoCtrlValidator.recusiveCreationHelper(this.reportIFolder);
    }

    private void createAutoCtrlProjet() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IWorkspaceRoot root = workspace.getRoot();
        this.autoCtrlProject = root.getProject(PROJECT_NAME);
        if (this.autoCtrlProject.exists()) {
            this.autoCtrlProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        this.autoCtrlProject.create((IProgressMonitor)progressMonitor);
        this.autoCtrlProject.open((IProgressMonitor)progressMonitor);
    }

    private void refreshValidateFolders() throws CoreException {
        this.conversionIFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private static void recusiveCreationHelper(IFolder f) throws CoreException {
        IFolder currentFolder = f;
        ArrayList<IFolder> listParentFolder = new ArrayList<IFolder>();
        while (!currentFolder.exists()) {
            listParentFolder.add(currentFolder);
            IContainer conteneur = currentFolder.getParent();
            if (!(conteneur instanceof IFolder)) break;
            currentFolder = (IFolder)conteneur;
        }
        Collections.reverse(listParentFolder);
        for (IFolder iFolder : listParentFolder) {
            iFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void executeValidate(IProgressMonitor monitor) throws AutoCtrlException {
        MessageFile.getInstance().setFieldLineNumberToIndividualDescriptorMap(null);
        ValidationFunctions validationFunctions = null;
        try {
            AbstractKBDescriptor normDescriptor = StandardHelper.getInstance().getNormDescriptor();
            if (normDescriptor == null) {
                throw new IllegalArgumentException("The normeId parameter can't be null.");
            }
            INormSerializer normSerializer = StandardHelper.getInstance().getSerializerFactory().getNormSerializer(StandardHelper.getInstance().getSerializerFactory().getDefaultContentType());
            OptionMap applicationOptionsMap = this.initValidationFunctions();
            try {
                validationFunctions = new ValidationFunctions(new ControlMessages(normDescriptor.getResourceBundle()), applicationOptionsMap, normDescriptor);
                applicationOptionsMap.setOption(new Key("fr.cnav.saturne.rules.properties"), (Object)validationFunctions.getControlsProperties());
            }
            catch (ValidationFunctionException exception) {
                throw new ValidationServiceException(exception);
            }
            File inputFile = MessageFile.getInstance().getInputFile();
            String reportPathStr = String.valueOf(inputFile.getName()) + "-norm.report";
            IFile reportIFile = this.reportIFolder.getFile(reportPathStr);
            File reportFile = new File(reportIFile.getRawLocation().toString());
            MessageFile.getInstance().setReportFile(reportFile);
            String sendId = inputFile.getName();
            try {
                if (reportFile.exists()) {
                    reportFile.delete();
                }
                reportFile.createNewFile();
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.ERROR_TECHNIC_VALIDATION, (Throwable)e);
            }
            ValidationListenerImpl validationListener = new ValidationListenerImpl(monitor);
            validationFunctions.setListener((IValidationListener)validationListener);
            IReportLogger reportLogger = this.prepareReport(normDescriptor.getStandardAccessor().getStandard(), normSerializer.getReportSerializer(), sendId, false, applicationOptionsMap);
            FileOutputStream report = null;
            IMessageBlock rootMessageBlock = null;
            try {
                try {
                    if (ZipUtil.isZipFile(MessageFile.getInstance().getInputFile())) {
                        File unzipFile = this.unzipFile();
                        rootMessageBlock = this.validateInputFile(validationFunctions, reportLogger, unzipFile);
                    } else {
                        rootMessageBlock = this.validateInputFile(validationFunctions, reportLogger, MessageFile.getInstance().getInputFile());
                    }
                    report = new FileOutputStream(reportFile);
                    this.writeReport(normSerializer.getReportSerializer(), report, reportLogger, validationFunctions);
                }
                catch (ValidationFunctionException e) {
                    throw new AutoCtrlException(ExceptionKind.ERROR_PROCESS_ALL_IN_ONE, new Object[]{e.getMessage(), e});
                }
                catch (IOException e) {
                    throw new AutoCtrlException(ExceptionKind.ERROR_TECHNIC_VALIDATION, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (report != null) {
                    try {
                        report.close();
                    }
                    catch (IOException e) {
                        throw new AutoCtrlException(ExceptionKind.ERROR_PROCESS_ALL_IN_ONE, e.getMessage(), e);
                    }
                }
                throw throwable;
            }
            if (report != null) {
                try {
                    report.close();
                }
                catch (IOException e) {
                    throw new AutoCtrlException(ExceptionKind.ERROR_PROCESS_ALL_IN_ONE, e.getMessage(), e);
                }
            }
            monitor.subTask(Messages.AutoCtrlValidator_6);
            this.extractInformationFromMessage(rootMessageBlock);
            monitor.worked(100);
            MessageFile.getInstance().setReportTempFilePath(reportIFile.getRawLocation().toString());
        }
        catch (ValidationServiceException e) {
            e.printStackTrace();
            throw new AutoCtrlException(ExceptionKind.ERROR_PROCESS_ALL_IN_ONE, e.getMessage(), e);
        }
    }

    private IMessageBlock validateInputFile(ValidationFunctions validationFunctions, IReportLogger reportLogger, File inputFile) throws ValidationFunctionException {
        File convertedTempFile = null;
        try {
            String convertedFileName = String.valueOf(MessageFile.getInstance().getInputFile().getName()) + CONVERTED_FILE_EXTENSION;
            IFile convertIFile = this.conversionIFolder.getFile(convertedFileName);
            convertedTempFile = new File(convertIFile.getRawLocation().toString());
            validationFunctions.validateFromText(inputFile, convertedTempFile, reportLogger);
            this.launchComputeContext(validationFunctions, reportLogger, convertedTempFile);
        }
        catch (TooManyAnomaliesException tooManyAnomaliesException) {
            this.launchComputeContext(validationFunctions, reportLogger, convertedTempFile);
        }
        return validationFunctions.getRootMessageBlock();
    }

    private void launchComputeContext(ValidationFunctions validationFunctions, IReportLogger reportLogger, File xmlFile) throws ValidationFunctionException {
        FileInputStream xmlInput = null;
        try {
            try {
                xmlInput = new FileInputStream(xmlFile);
                validationFunctions.computeContexts((InputStream)xmlInput, reportLogger);
            }
            catch (Exception e) {
                throw new AutoCtrlException(ExceptionKind.ERROR_PROCESS_ALL_IN_ONE, e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            if (xmlInput != null) {
                try {
                    xmlInput.close();
                }
                catch (IOException e) {
                    throw new AutoCtrlException(ExceptionKind.ERROR_PROCESS_ALL_IN_ONE, e.getMessage(), e);
                }
            }
            throw throwable;
        }
        if (xmlInput != null) {
            try {
                xmlInput.close();
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.ERROR_PROCESS_ALL_IN_ONE, e.getMessage(), e);
            }
        }
    }

    private File unzipFile() {
        String unzippedFileName = String.valueOf(MessageFile.getInstance().getInputFile().getName()) + ".unzip";
        IFile unzipIFile = this.conversionIFolder.getFile(unzippedFileName);
        File unzipFile = new File(unzipIFile.getRawLocation().toString());
        if (!unzipFile.exists()) {
            try {
                ZipUtil.extactFirstFile(MessageFile.getInstance().getInputFile(), unzipFile);
            }
            catch (Exception exception) {
                ZipApacheUtil.extactFirstFile(MessageFile.getInstance().getInputFile(), "ISO-8859-1", unzipFile);
            }
        }
        return unzipFile;
    }

    private OptionMap initValidationFunctions() {
        OptionMap options = new OptionMap();
        options.setOption(new Key("fr.cnav.norme.report.mutualisation.threshold"), (Object)Integer.valueOf(this.factorizationThreshold));
        options.setOption(new Key("maximal.number.errors"), (Object)Integer.valueOf(this.validatorServiceLimtLoggedErrors));
        options.setOption(new Key("fr.cnav.saturne.validator.unloadingActivated"), (Object)false);
        Properties propertiesSystem = System.getProperties();
        if (propertiesSystem.containsKey("stop.on.syntactic.error")) {
            options.setOption(new Key("stop.on.syntactic.error"), (Object)Boolean.valueOf(propertiesSystem.getProperty("stop.on.syntactic.error")));
        }
        if (propertiesSystem.containsKey("stop.on.conversion.error")) {
            options.setOption(new Key("stop.on.conversion.error"), (Object)Boolean.valueOf(propertiesSystem.getProperty("stop.on.conversion.error")));
        }
        if (propertiesSystem.containsKey("fr.cnav.norme.val.anomaliesInhibiting")) {
            options.setOption(new Key("fr.cnav.norme.val.anomaliesInhibiting"), (Object)Boolean.valueOf(propertiesSystem.getProperty("fr.cnav.norme.val.anomaliesInhibiting")));
        }
        return options;
    }

    private void extractInformationFromMessage(IMessageBlock messageBlock) {
        boolean messageDescriptorProvided = StandardHelper.getInstance().getMessageDescriptor() != null;
        String individualFQID = null;
        if (messageDescriptorProvided) {
            individualFQID = StandardHelper.getInstance().getMessageDescriptor().getIndividualFullQualifiedID();
        }
        List<IIndividualFieldRegistry> individualFields = null;
        if (StandardHelper.getInstance().getMessageDescriptor() != null) {
            individualFields = StandardHelper.getInstance().getMessageDescriptor().getIndividualFields();
        }
        try {
            MessageParserForIndividual messageParserForIndividual = new MessageParserForIndividual(messageBlock, individualFQID, individualFields, MessageFile.getInstance().getAnomalies(), StandardHelper.getInstance().getStandard());
            MessageFile.getInstance().setFieldLineNumberToIndividualDescriptorMap(messageParserForIndividual.getFieldLineNumberToIndividualDescriptorMap());
            MessageFile.getInstance().setIndividualNumber(messageParserForIndividual.getNbIndividualBlocks());
            Context2DeclarationCaches context2DeclarationMapFromMessageBlock = new Context2DeclarationCaches(messageBlock, MessageFile.getInstance().getReportResult().getReport().getRootContext(), StandardHelper.getInstance().getStandardAccessor());
            MessageFile.getInstance().setMapContext2Declaration(context2DeclarationMapFromMessageBlock.getMapContext2Declaration());
            MessageFile.getInstance().setMapContext2DeclarationRank(context2DeclarationMapFromMessageBlock.getMapContext2DeclarationRank());
        }
        catch (Exception e) {
            AutocontrolPlugin.log((IStatus)new Status(1, "fr.cnav.autocontrole", "The individual information retrieving encountered a problem.", (Throwable)e));
        }
    }

    public void pepareValidationEnvironment(IProgressMonitor monitor) {
        monitor.subTask(Messages.AutoCtrlValidator_1);
        monitor.worked(0);
        try {
            this.createAutoCtrlProjet();
        }
        catch (CoreException e) {
            throw new AutoCtrlException(ExceptionKind.CANNOT_CREATE_PRJ, new Object[]{PROJECT_NAME, e});
        }
        try {
            this.prepareAutoCtrlFolder();
        }
        catch (CoreException e) {
            throw new AutoCtrlException(ExceptionKind.CANNOT_PERPARE_PRJ, new Object[]{PROJECT_NAME, e});
        }
        monitor.worked(10);
    }

    public boolean validateIntegrity(IProgressMonitor monitor, AbstractKBDescriptor normDescriptor) throws AutoCtrlException {
        if (normDescriptor.getOptions().getOption(new Key("fr.cnav.saturne.validator.inputFormatValidation")) == FormatType.TXT || normDescriptor.getOptions().getOption(new Key("fr.cnav.saturne.validator.inputFormatValidation")) == FormatType.TXTNP) {
            return this.validateIntegritySequencielFormat(monitor, normDescriptor);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateIntegritySequencielFormat(IProgressMonitor monitor, AbstractKBDescriptor normDescriptor) throws AutoCtrlException {
        boolean isIntegrityConfirmed;
        File inputFile = MessageFile.getInstance().getInputFile();
        File unzipFile = null;
        unzipFile = ZipUtil.isZipFile(MessageFile.getInstance().getInputFile()) ? this.unzipFile() : inputFile;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(unzipFile);
                Standard standard = normDescriptor.getStandardAccessor().getStandard();
                ControlMessages controlMessages = new ControlMessages(null);
                SequentialLineReader sequentialLineReader = new SequentialLineReader((InputStream)fileInputStream, Charset.forName(standard.getMessagesEncoding()), new OptionMap(), controlMessages, normDescriptor.getStandardAccessor());
                isIntegrityConfirmed = false;
                int lineCounter = 0;
                IMessageField nextField = sequentialLineReader.getNextField();
                while (nextField != null && lineCounter < 5) {
                    ++lineCounter;
                    if (!this.hasStructuralInvalidity(nextField)) {
                        isIntegrityConfirmed = true;
                    }
                    sequentialLineReader.consumme();
                    nextField = sequentialLineReader.getNextField();
                }
            }
            catch (Throwable t) {
                throw new AutoCtrlException(ExceptionKind.ERROR_INTEGRITY_CHECKING, t);
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.ERROR_INTEGRITY_CHECKING, (Throwable)e);
            }
        }
        monitor.worked(15);
        return isIntegrityConfirmed;
    }

    private boolean hasStructuralInvalidity(IMessageField<?> field) {
        List annotations = ((MessageField)field).getAnnotations();
        for (Object annotation : annotations) {
            if (!(annotation instanceof ValidationInformation)) continue;
            ValidationInformation validationInformation = (ValidationInformation)annotation;
            List anomalies = validationInformation.getAnomalies();
            for (Anomaly anomaly : anomalies) {
                if (anomaly.getField().getValue() != null) continue;
                return true;
            }
        }
        return false;
    }

    private void writeReport(IReportSerializer reportSerializer, OutputStream report, IReportLogger reportLogger, ValidationFunctions validationFunctions) throws IOException, ValidationFunctionException {
        validationFunctions.notify(ValidationEvent.REPORT_SERIALIZATION_START, reportLogger);
        validationFunctions.writeReport(report, reportLogger, reportSerializer);
        validationFunctions.notify(ValidationEvent.REPORT_SERIALIZATION_END, reportLogger);
    }

    private IReportLogger prepareReport(Standard standard, IReportSerializer reportSerializer, String id, boolean calculateContextsDuringParsing, OptionMap applicationOptionMap) throws ValidationServiceException {
        IReportLogger reportLogger = reportSerializer.getReportLogger(standard, calculateContextsDuringParsing, applicationOptionMap);
        reportLogger.setCustomAttribute("fr.cnav.saturne.validator.report.validationIdAttributeKey", id);
        reportLogger.setCustomAttribute("fr.cnav.saturne.validator.report.timeStampAttributeKey", Calendar.getInstance().getTime().toString());
        return reportLogger;
    }
}

