/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Cst06SyntaxControl
extends AbstractFieldSyntaxControl {
    private final String aCategoryFullQualifiedId;

    public Cst06SyntaxControl(int id, String code, FieldDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        this.aCategoryFullQualifiedId = target.getFullQualifiedId();
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        String value = subject.getValueAsString();
        if (value == null || value.length() == 0) {
            String message = this.controlMessage.getMessage("syntactic.messages.CST06_EMPTY", new Object[]{this.aCategoryFullQualifiedId});
            RuleFailure result = new RuleFailure(this, subject, subject.getParent(), message);
            return result;
        }
        return IRule.SUCCESS;
    }
}

