/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.reportfilter;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.parser.FormuleTraducteur;
import fr.cnav.saturne.dsl.parser.FormuleTraducteurException;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.IReportLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ReportFilteringOperation {
    private static final String SEPARATOR_PRESENT_IN_SEMANTIC_RULES_CODE = "/";
    private static final String FUNCTION_NAME_IS_ABSENT = "is_absent";
    private static final String FUNCTION_NAME_IS_PRESENT = "is_present";

    public Map<String, Set<GenericRule>> getFieldIdToReferencingRulesMap(Standard standard, Map<String, Set<IMessageBlock>> fieldIdToFieldIntervalMap) {
        if (fieldIdToFieldIntervalMap == null) {
            throw new IllegalArgumentException(String.valueOf(ReportFilteringOperation.class.getSimpleName()) + ": fieldIdToFieldIntervalMap cannot be null.");
        }
        HashMap<String, Set<GenericRule>> fieldIdToRuleReferencingItMap = new HashMap<String, Set<GenericRule>>();
        if (!fieldIdToFieldIntervalMap.isEmpty()) {
            FormuleTraducteur formuleTraducteur = this.initializeAstExpressionParser(standard);
            EList rules = standard.getRules().getRules();
            for (GenericRule rule : rules) {
                this.updateRulesUsingFieldsRegardingExpression(formuleTraducteur, rule, fieldIdToRuleReferencingItMap, fieldIdToFieldIntervalMap);
            }
        }
        return fieldIdToRuleReferencingItMap;
    }

    private void updateRulesUsingFieldsRegardingExpression(FormuleTraducteur formuleTraducteur, GenericRule rule, Map<String, Set<GenericRule>> fieldIdToRuleReferencingItMap, Map<String, Set<IMessageBlock>> fieldIdToScopeMap) {
        if (rule instanceof Rule && ((Rule)rule).getDslExpression() != null) {
            Rule dslRule = (Rule)rule;
            if (dslRule.getComputedContext() == null && dslRule.getSubject() != null && dslRule.getSubject().eContainer() instanceof ReusedBlock) {
                ReusedBlock reusedBlock = (ReusedBlock)dslRule.getSubject().eContainer();
                for (Block ctxtBlock : reusedBlock.getReusingBlocks()) {
                    this.updateRulesUsingFieldsRegardingExpression(formuleTraducteur, dslRule, ctxtBlock, fieldIdToRuleReferencingItMap, fieldIdToScopeMap);
                }
            } else {
                this.updateRulesUsingFieldsRegardingExpression(formuleTraducteur, dslRule, dslRule.getComputedContext(), fieldIdToRuleReferencingItMap, fieldIdToScopeMap);
            }
        }
    }

    private void updateRulesUsingFieldsRegardingExpression(FormuleTraducteur formuleTraducteur, Rule dslRule, Block context, Map<String, Set<GenericRule>> fieldIdToRuleReferencingItMap, Map<String, Set<IMessageBlock>> fieldIdToScopeMap) {
        Expression dslExpression = null;
        String dslExpressionString = dslRule.getDslExpression();
        try {
            dslExpression = formuleTraducteur.processDSL(dslExpressionString, dslRule.getSubject().getFullQualifiedId(), context.getFullQualifiedId());
        }
        catch (FormuleTraducteurException formuleTraducteurException) {}
        Set<FieldRef> fieldRefs = this.getFieldRefs(dslExpression);
        Iterator<FieldRef> iterator = fieldRefs.iterator();
        boolean isExpressionUsingField = false;
        while (iterator.hasNext() && !isExpressionUsingField) {
            FieldRef fieldRef = iterator.next();
            if (fieldRef.eContainer() instanceof FunctionCall && (FUNCTION_NAME_IS_PRESENT.equals(((FunctionCall)fieldRef.eContainer()).getName()) || FUNCTION_NAME_IS_ABSENT.equals(((FunctionCall)fieldRef.eContainer()).getName())) || fieldIdToScopeMap.get(fieldRef.getName()) == null) continue;
            Set<GenericRule> rulesUsingField = fieldIdToRuleReferencingItMap.get(fieldRef.getName());
            if (rulesUsingField == null) {
                rulesUsingField = new HashSet<GenericRule>();
                fieldIdToRuleReferencingItMap.put(fieldRef.getName(), rulesUsingField);
            }
            rulesUsingField.add((GenericRule)dslRule);
        }
    }

    private FormuleTraducteur initializeAstExpressionParser(Standard standard) {
        StandardParserConfiguration standardParserConfiguration = null;
        try {
            standardParserConfiguration = new StandardParserConfiguration(standard, null);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        FormuleTraducteur formuleTraducteur = new FormuleTraducteur((IParserConfiguration)standardParserConfiguration);
        return formuleTraducteur;
    }

    private Set<FieldRef> getFieldRefs(Expression expr) {
        HashSet<FieldRef> results = new HashSet<FieldRef>();
        if (expr != null) {
            TreeIterator objects = expr.eAllContents();
            while (objects.hasNext()) {
                EObject next = (EObject)objects.next();
                if (!(next instanceof FieldRef)) continue;
                results.add((FieldRef)next);
            }
        }
        return results;
    }

    public void filterSecondaryAnomalies(IReportLogger reportLogger, Map<String, Set<IMessageBlock>> fieldIdToFieldIntervalMap, Map<String, Set<GenericRule>> fieldIdToRuleToIgnoreMap) {
        if (reportLogger == null) {
            throw new IllegalArgumentException(String.valueOf(ReportFilteringOperation.class.getSimpleName()) + ": normDescriptor cannot be null.");
        }
        if (fieldIdToRuleToIgnoreMap == null) {
            throw new IllegalArgumentException(String.valueOf(ReportFilteringOperation.class.getSimpleName()) + ": fieldIdToRuleToIgnoreMap cannot be null.");
        }
        if (fieldIdToFieldIntervalMap == null) {
            throw new IllegalArgumentException(String.valueOf(ReportFilteringOperation.class.getSimpleName()) + ": fieldIdToFieldIntervalMap cannot be null.");
        }
        if (!fieldIdToFieldIntervalMap.isEmpty() && !fieldIdToRuleToIgnoreMap.isEmpty()) {
            this.filterContextAnomalies(reportLogger.getReport().getRootContext(), fieldIdToFieldIntervalMap, fieldIdToRuleToIgnoreMap, reportLogger);
        }
    }

    private void filterContextAnomalies(Context context, Map<String, Set<IMessageBlock>> fieldIdToFieldIntervalMap, Map<String, Set<GenericRule>> fieldIdToRuleToIgnoreMap, IReportLogger reportLogger) {
        Iterator<Anomaly> messageAnomaliesterator = context.getAnomalies().iterator();
        while (messageAnomaliesterator.hasNext()) {
            Anomaly anomaly = messageAnomaliesterator.next();
            if (!anomaly.getCode().contains(SEPARATOR_PRESENT_IN_SEMANTIC_RULES_CODE)) continue;
            this.filtersAnomaly(anomaly, fieldIdToFieldIntervalMap, fieldIdToRuleToIgnoreMap, reportLogger, messageAnomaliesterator);
        }
        List<Context> subContexts = context.getContextChildren();
        for (Context subContext : subContexts) {
            this.filterContextAnomalies(subContext, fieldIdToFieldIntervalMap, fieldIdToRuleToIgnoreMap, reportLogger);
        }
    }

    private void filtersAnomaly(Anomaly anomaly, Map<String, Set<IMessageBlock>> fieldToScopeMap, Map<String, Set<GenericRule>> fieldIdToRuleToIgnoreMap, IReportLogger reportLogger, Iterator<Anomaly> anomaliesIterator) {
        boolean anomalyFiltered = false;
        Set<Map.Entry<String, Set<IMessageBlock>>> entrySet = fieldToScopeMap.entrySet();
        for (Map.Entry<String, Set<IMessageBlock>> fieldToMessageBlockSetEntry : entrySet) {
            Set<IMessageBlock> scopeSet = fieldToMessageBlockSetEntry.getValue();
            if (scopeSet == null) continue;
            Iterator<IMessageBlock> scopeIterator = scopeSet.iterator();
            while (scopeIterator.hasNext() && !anomalyFiltered) {
                boolean toFilter;
                IMessageBlock scope = scopeIterator.next();
                if (scope.getFirstLine() > anomaly.getFieldLocalizer().getLineNumber() || scope.getLastLine() < anomaly.getFieldLocalizer().getLineNumber() || !(toFilter = this.isAnomalyKindSupportedByIntervalField(fieldIdToRuleToIgnoreMap, anomaly, fieldToMessageBlockSetEntry.getKey()))) continue;
                anomaliesIterator.remove();
                anomalyFiltered = true;
            }
        }
    }

    private boolean isAnomalyKindSupportedByIntervalField(Map<String, Set<GenericRule>> fieldIdToRuleToIgnoreMap, Anomaly anomaly, String fieldId) {
        boolean matchRule = false;
        Set<GenericRule> rulesSet = fieldIdToRuleToIgnoreMap.get(fieldId);
        if (rulesSet != null) {
            Iterator<GenericRule> iterator = fieldIdToRuleToIgnoreMap.get(fieldId).iterator();
            while (iterator.hasNext() && !matchRule) {
                GenericRule rule = iterator.next();
                if (!anomaly.getCode().equals(rule.getFullId())) continue;
                matchRule = true;
            }
        }
        return matchRule;
    }
}

