/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.keyvalue;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.Anomaly;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.SequentialLocalizer;
import fr.cnav.saturne.validator.ValidationInformation;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SequentialLineReader {
    public static final int DEFAULT_MAX_LENGTH = 256;
    public static final int DEFAULT_MIN_LENGTH = 1;
    public static final String SEPARATOR = ",";
    public static final String FIELD_VALUE_DELIMITERS = "'";
    public static final String PATTERN_VALID_LINE = "[a-zA-Z_0-9_\\-\\.]+[ \\t\\n\\x0B\\f\\r]*,[ \\t\\n\\x0B\\f\\r]*'[ \\t\\n\\x0B\\f\\r]*.*?[ \\t\\n\\x0B\\f\\r]*'\\r?";
    public static final String PATTERN_INVALID_FIELD = "([\\w_\\-\\.]*)([^,']*),([^,']*)('(.*)')([^\\r]*)(\\r)?";
    public static final String PATTERN_VALID_FIELD_ID = "([\\w_\\-\\.]+)([^\\w_\\-\\.]+).*";
    public static final int GROUP_FIELD_ID = 1;
    public static final int GROUP_FIELD_VALUE = 5;
    public static final int GROUP_SPACE_ONE = 2;
    public static final int GROUP_SPACE_TWO = 3;
    public static final int GROUP_SPACE_THREE = 4;
    public static final int GROUP_SPACE_FOUR = 6;
    public static final int GROUP_INVALID_END_OF_LINE = 6;
    public static final int GROUP_INVALID_VALUE_FIELD = 5;
    public static final int GROUP_INVALID_FIELD_VALUE_DELIMITERS = 4;
    public static final int GROUP_INVALID_FIELD_ID = 2;
    private static final String ANOMALIES_MESSAGES_SEPARATOR = " ";
    private static final String GENERAL_FORMAT_KEY = "conversion.messages.CV01";
    private static final String MESSAGE_INVALID_SPACES_AROUND_SEPARATOR = "invalidSpacesAroundSeparator";
    private static final String MESSAGE_INVALID_SPACES_AROUND_VALUE = "invalidSpacesAroundValue";
    private static final String MESSAGE_INVALID_END_OF_LINE = "invalidEndOfLine";
    private static final String MESSAGE_WRONG_DELIMITER_PROBLEM = "invalidValueDelimiters";
    private static final String MESSAGE_WRONG_SEPARATOR_PROBLEM = "invalidSeparator";
    private String nextLine;
    private int currentLineNumber;
    private BufferedReader reader;
    private final Automaton validLinePattern;
    private final Pattern invalidFieldPattern;
    private final Pattern validFieldIdPattern;
    private final int fieldMinLength;
    private final int fieldMaxLength;
    private ControlMessages controlMessages;
    private MessageElementFactory messageElementFactory;
    private StandardAccessor modelAccessor;

    public SequentialLineReader(InputStream input, Charset charset, OptionMap options, ControlMessages controlMessages, StandardAccessor theModelAccessor) {
        this.reader = new BufferedReader(new InputStreamReader(input, charset));
        this.currentLineNumber = 0;
        RegExp r = new RegExp(PATTERN_VALID_LINE);
        this.validLinePattern = r.toAutomaton();
        this.invalidFieldPattern = Pattern.compile(PATTERN_INVALID_FIELD);
        this.validFieldIdPattern = Pattern.compile(PATTERN_VALID_FIELD_ID);
        this.fieldMaxLength = this.maxLength(options);
        this.fieldMinLength = this.minLength(options);
        this.controlMessages = controlMessages;
        this.messageElementFactory = new MessageElementFactory(theModelAccessor);
        this.modelAccessor = theModelAccessor;
    }

    private boolean matchesAnyOf(String str) {
        boolean result = str.codePoints().anyMatch(Character::isISOControl);
        return result;
    }

    private String removeFrom(String str) {
        String result = str.codePoints().filter(i -> !Character.isISOControl(i)).mapToObj(c -> String.valueOf((char)c)).map(Object::toString).collect(Collectors.joining());
        return result;
    }

    private String filterForbiddenXmlCharacter(String fieldValue) {
        if (this.matchesAnyOf(fieldValue)) {
            return this.removeFrom(fieldValue);
        }
        return fieldValue;
    }

    private int minLength(OptionMap options) {
        Integer value = (Integer)options.getOption(new Key("sequence.provider.min.length"));
        if (value == null) {
            value = 1;
        }
        return value;
    }

    private int maxLength(OptionMap options) {
        Integer value = (Integer)options.getOption(new Key("sequence.provider.max.length"));
        if (value == null) {
            value = 256;
        }
        return value;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    private String getNextLine() throws IOException {
        if (this.nextLine == null) {
            String line = this.trim(this.reader.readLine());
            ++this.currentLineNumber;
            while (line != null && "".equals(line)) {
                line = this.trim(this.reader.readLine());
                ++this.currentLineNumber;
            }
            if (line != null && !"".equals(line) && Character.isLowerCase(line.charAt(0))) {
                char[] characters = line.toCharArray();
                characters[0] = Character.toUpperCase(characters[0]);
                line = new String(characters);
            }
            this.nextLine = line;
        }
        return this.nextLine;
    }

    private String trim(String line) {
        String result = line;
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    public IMessageField<?> getNextField() throws SaturneValidatorException {
        String line;
        IMessageField<?> result = null;
        try {
            line = this.getNextLine();
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
        if (line == null) {
            return null;
        }
        boolean matches = this.validLinePattern.run(line);
        result = !matches ? this.getStructurallyInvalidField(line, this.currentLineNumber) : this.getFieldIdentifiable(line, this.currentLineNumber);
        if (!this.modelAccessor.doesIdCorrespondsToAStandardElement(result.getStandardFieldDescription().getFullQualifiedId())) {
            this.addAnomaly(result, "CV10", this.controlMessages.getMessage("conversion.messages.CV10"), RuleCriticity.BLOCKING);
        }
        return result;
    }

    public void consumme() {
        this.nextLine = null;
    }

    private void addAnomaly(IMessageField<?> field, String anomalyCode, String anomalyMessage, RuleCriticity anomalyCriticity) {
        ValidationInformation info = this.getValidationInfo((MessageField)field);
        Anomaly anomalyStructurallyValid = new Anomaly(field, anomalyCode, anomalyMessage, this.currentLineNumber, anomalyCriticity);
        info.addAnomaly(anomalyStructurallyValid);
    }

    ValidationInformation getValidationInfo(MessageField<?> field) {
        ValidationInformation info;
        if (field.getAnnotations().size() == 0) {
            info = new ValidationInformation();
            field.addAnnotation(info);
        } else {
            info = (ValidationInformation)field.getAnnotations().get(0);
        }
        return info;
    }

    private IMessageField<?> getStructurallyInvalidField(String line, int lineNumber) {
        Matcher m = this.invalidFieldPattern.matcher(line);
        Matcher m2 = this.validFieldIdPattern.matcher(line);
        String fieldId = "";
        boolean mMatches = m.matches();
        boolean m2Matches = false;
        if (mMatches) {
            fieldId = m.group(1);
        } else {
            m2Matches = m2.matches();
            if (m2Matches && !m2.group(1).isEmpty()) {
                fieldId = m2.group(1);
            }
        }
        MessageField<?> field = this.messageElementFactory.createMessageField(fieldId, null, new SequentialLocalizer(lineNumber));
        if (mMatches) {
            boolean anomalyDetected = false;
            if (m.group(1).isEmpty() || !m.group(2).isEmpty()) {
                this.addAnomaly(field, "CV06", this.controlMessages.getMessage("conversion.messages.CV06", new Object[0]), RuleCriticity.BLOCKING);
                anomalyDetected = true;
            } else if (!m.group(6).isEmpty()) {
                this.addAnomaly(field, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage("conversion.messages.invalidEndOfLine"), RuleCriticity.BLOCKING);
                anomalyDetected = true;
            }
            if (!anomalyDetected) {
                this.addAnomaly(field, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage(GENERAL_FORMAT_KEY) + this.controlMessages.getMessage("conversion.messages.generalProblem"), RuleCriticity.BLOCKING);
            }
        } else if (!line.contains(SEPARATOR) || line.lastIndexOf(SEPARATOR) > line.indexOf(SEPARATOR)) {
            this.addAnomaly(field, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage("conversion.messages.invalidSeparator"), RuleCriticity.BLOCKING);
        } else if (line.indexOf(FIELD_VALUE_DELIMITERS) == line.lastIndexOf(FIELD_VALUE_DELIMITERS)) {
            this.addAnomaly(field, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage("conversion.messages.invalidValueDelimiters"), RuleCriticity.BLOCKING);
        } else {
            this.addAnomaly(field, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage("conversion.messages.generalProblem"), RuleCriticity.BLOCKING);
        }
        return field;
    }

    private IMessageField<?> getFieldIdentifiable(String line, int lineNumber) {
        int commaIndex = line.indexOf(44);
        String fieldId = line.substring(0, commaIndex).trim();
        String fieldValueWithDelimiter = line.substring(commaIndex + 1);
        int indexOfFirstQuote = fieldValueWithDelimiter.indexOf(39);
        int indexOfLastQuote = fieldValueWithDelimiter.charAt(fieldValueWithDelimiter.length() - 1) == '\r' ? fieldValueWithDelimiter.length() - 2 : fieldValueWithDelimiter.length() - 1;
        String fieldValue = fieldValueWithDelimiter.substring(indexOfFirstQuote + 1, indexOfLastQuote);
        IMessageField<?> result = this.getStructurallyValidFieldWithfilteredForbiddenXmlCharacter(lineNumber, fieldId, fieldValue);
        if (line.charAt(commaIndex - 1) == ' ' || line.charAt(commaIndex + 1) == ' ') {
            this.addAnomaly(result, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage("conversion.messages.invalidSpacesAroundSeparator"), RuleCriticity.BLOCKING);
        }
        if (fieldValueWithDelimiter.charAt(indexOfFirstQuote + 1) == ' ' || fieldValueWithDelimiter.charAt(indexOfLastQuote - 1) == ' ') {
            this.addAnomaly(result, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage("conversion.messages.invalidSpacesAroundValue"), RuleCriticity.BLOCKING);
        }
        if (fieldValue.length() > this.fieldMaxLength || fieldValue.length() < this.fieldMinLength) {
            this.addAnomaly(result, "CV02", this.controlMessages.getMessage("conversion.messages.CV02", new Object[]{this.fieldMinLength, this.fieldMaxLength}), RuleCriticity.BLOCKING);
        }
        return result;
    }

    private IMessageField<?> getStructurallyValidFieldWithfilteredForbiddenXmlCharacter(int lineNumber, String fieldId, String fieldValue) {
        MessageField<?> newMessageField = this.messageElementFactory.createMessageField(fieldId.trim(), this.filterForbiddenXmlCharacter(fieldValue), new SequentialLocalizer(lineNumber));
        if (this.matchesAnyOf(fieldValue)) {
            this.addAnomaly(newMessageField, "CV01", String.valueOf(this.controlMessages.getMessage(GENERAL_FORMAT_KEY, new Object[0])) + ANOMALIES_MESSAGES_SEPARATOR + this.controlMessages.getMessage("conversion.messages.invalidXmlChar"), RuleCriticity.BLOCKING);
        }
        return newMessageField;
    }
}

