/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.Anomaly;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.ValidationInformation;
import fr.cnav.saturne.validator.impl.LineAndColumnLocalizer;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;

public class JsonSequenceReader
implements ISequenceProvider {
    private final OptionMap options;
    private final StandardAccessor modelAccessor;
    private ControlMessages controlMessages;
    private MessageElementFactory factory;
    private final BufferedReader reader;
    private IMessageBlock lastBlock;
    private JsonReader jsonReader;
    private String lastReadName;
    private Stack<String> readArrayName;
    private List<Anomaly> currentAnomalies = new ArrayList<Anomaly>();

    public JsonSequenceReader(OptionMap optionsMap, ControlMessages theControlMessages, StandardAccessor theModelAccessor, InputStream input, Charset charset) throws SaturneValidatorException {
        this.options = optionsMap;
        this.modelAccessor = theModelAccessor;
        this.controlMessages = theControlMessages;
        this.factory = new MessageElementFactory(this.modelAccessor);
        this.reader = new BufferedReader(new InputStreamReader(input, charset));
        this.jsonReader = new JsonReader((Reader)this.reader);
        this.readArrayName = new Stack();
        try {
            this.jsonReader.beginObject();
            this.jsonReader.nextName();
            this.jsonReader.beginObject();
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
    }

    @Override
    public OptionMap getOptions() {
        return this.options;
    }

    @Override
    public IMessageBlock getNextBlock() throws SaturneValidatorException {
        if (this.lastBlock == null) {
            this.lastBlock = this.readNextBlock();
            if (this.lastBlock == null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new SaturneValidatorException(e);
                }
            }
        }
        return this.lastBlock;
    }

    @Override
    public void consummeBlock() {
        this.lastBlock = null;
    }

    private IMessageBlock readNextBlock() throws SaturneValidatorException {
        JsonToken currentToken;
        String elementName;
        IMessageBlock nextMsgBlock;
        block15: {
            nextMsgBlock = null;
            elementName = this.lastReadName;
            currentToken = this.jsonReader.peek();
            if (!JsonToken.END_DOCUMENT.equals((Object)currentToken)) break block15;
            return null;
        }
        try {
            if (JsonToken.BEGIN_OBJECT.equals((Object)currentToken)) {
                if (this.lastReadName != null) {
                    elementName = this.lastReadName;
                    this.lastReadName = null;
                } else if (!this.readArrayName.isEmpty()) {
                    elementName = this.readArrayName.peek();
                }
            } else {
                elementName = this.jsonReader.nextName();
            }
            try {
                nextMsgBlock = this.factory.createMessageBlock(elementName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Anomaly anomaly = new Anomaly(this.factory.createMessageField(elementName, "", new LineAndColumnLocalizer(this.getLine(), 0)), "CV13", this.controlMessages.getMessage("conversion.messages.CV13", new Object[]{elementName, this.getLine()}), this.getLine(), RuleCriticity.BLOCKING);
                this.pushAnomaly(anomaly);
            }
            this.jsonReader.beginObject();
            currentToken = this.createFields(nextMsgBlock);
            while (JsonToken.END_OBJECT.equals((Object)currentToken) || JsonToken.END_ARRAY.equals((Object)currentToken)) {
                if (JsonToken.END_OBJECT.equals((Object)currentToken)) {
                    this.jsonReader.endObject();
                } else {
                    this.jsonReader.endArray();
                    this.readArrayName.pop();
                }
                currentToken = this.jsonReader.peek();
            }
        }
        catch (IOException | IllegalStateException e) {
            throw new SaturneValidatorException(e);
        }
        if (nextMsgBlock != null) {
            this.attachPreviousAnomalies(nextMsgBlock);
        } else {
            nextMsgBlock = this.readNextBlock();
        }
        return nextMsgBlock;
    }

    private JsonToken createFields(IMessageBlock msgBlock) throws IOException, SaturneValidatorException {
        JsonToken currentToken = this.jsonReader.peek();
        while (JsonToken.NAME.equals((Object)currentToken)) {
            String elementName = this.jsonReader.nextName();
            JsonToken nextToken = this.jsonReader.peek();
            if (JsonToken.BEGIN_OBJECT.equals((Object)nextToken)) {
                this.lastReadName = elementName;
                break;
            }
            if (JsonToken.BEGIN_ARRAY.equals((Object)nextToken)) {
                this.jsonReader.beginArray();
                this.readArrayName.push(elementName);
                this.lastReadName = null;
                break;
            }
            if (JsonToken.STRING.equals((Object)nextToken) || JsonToken.NUMBER.equals((Object)nextToken) || JsonToken.BOOLEAN.equals((Object)nextToken)) {
                String originalValue = this.jsonReader.nextString();
                MessageField<?> field = this.factory.createMessageField(elementName, originalValue, new LineAndColumnLocalizer(this.getLine(), this.getColumn()));
                if (msgBlock != null) {
                    msgBlock.addField(field);
                }
            }
            currentToken = this.jsonReader.peek();
        }
        return currentToken;
    }

    protected int getLine() throws SaturneValidatorException {
        try {
            String linePattern = "line ";
            String columnPattern = " column ";
            String location = this.jsonReader.toString();
            int start = location.indexOf(linePattern);
            int end = location.indexOf(columnPattern);
            String number = location.substring(start + linePattern.length(), end);
            return Integer.decode(number);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SaturneValidatorException(e);
        }
    }

    protected int getColumn() throws SaturneValidatorException {
        try {
            String columnPattern = " column ";
            String location = this.jsonReader.toString();
            int start = location.indexOf(columnPattern);
            int end = location.indexOf(" ", start + columnPattern.length());
            String number = location.substring(start + columnPattern.length(), end);
            return Integer.decode(number);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SaturneValidatorException(e);
        }
    }

    private void attachPreviousAnomalies(IMessageBlock msgBlock) {
        List<Anomaly> anomalies = this.popAnomalies();
        if (!anomalies.isEmpty()) {
            this.addAnomalies(msgBlock, anomalies);
        }
    }

    private void addAnomalies(IMessageBlock msgBlock, List<Anomaly> anomalies) {
        ValidationInformation info = ((MessageBlock)msgBlock).getAnnotations().stream().filter(ValidationInformation.class::isInstance).map(ValidationInformation.class::cast).findFirst().orElse(null);
        if (info == null) {
            info = new ValidationInformation();
            ((MessageBlock)msgBlock).addAnnotation(info);
        }
        info.getAnomalies().addAll(anomalies);
    }

    private void pushAnomaly(Anomaly anomaly) {
        this.currentAnomalies.add(anomaly);
    }

    private List<Anomaly> popAnomalies() {
        List<Anomaly> result = this.currentAnomalies.stream().collect(Collectors.toList());
        this.currentAnomalies.clear();
        return result;
    }
}

