/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer;

import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.impl.DsnAnomalyComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import n4ds.dsn.p03v01.all.rules.StructureConstants;
import n4ds.dsn.serializer.ConfigurationDsn;

public class DsnXmlSerializer
implements StructureConstants {
    private final XMLStreamWriter writer;
    private final Context report;
    private final IReportLogger reportLogger;
    private int nbAnoBloquante;
    private int nbAnoNonbloquante;
    private ModelAccessor accessor;

    public DsnXmlSerializer(XMLStreamWriter writer, IReportLogger reportLogger, ModelAccessor accessor) {
        this.writer = writer;
        this.report = reportLogger.getReport().getRootContext();
        this.reportLogger = reportLogger;
        this.accessor = accessor;
    }

    public void serialize() throws XMLStreamException {
        this.serializeHeader();
        this.serializeEnvoiIdentification();
        this.serializeEnvoiBilan();
        this.serializeEnvoiAnomalies();
        List secondLevelContexts = this.report.getContextChildren();
        for (Context secondLevelContext : secondLevelContexts) {
            this.serializeSecondLevelContext(secondLevelContext);
        }
        this.serializeFooter();
    }

    private void serializeHeader() throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeComment("Version : " + this.accessor.getStandard().getDescription());
        this.writer.writeComment("Date : " + ConfigurationDsn.getTimeStamp());
        this.writer.setPrefix("gipmds", "http://www.gip-mds.fr/");
        this.writer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.writer.writeStartElement("http://www.gip-mds.fr/", "rapport");
        this.writer.writeAttribute("profil", "DSN");
        this.writer.writeAttribute("type", "BAN");
        this.writer.writeAttribute("version", "v01r08");
        this.writer.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "http://www.gip-mds.fr/dsn_bilans_v01r08.xsd");
        this.writer.writeNamespace("gipmds", "http://www.gip-mds.fr/");
        this.writer.writeNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    private void serializeEnvoiIdentification() throws XMLStreamException {
        String messageID = this.reportLogger.getCustomAttributeValue("fr.cnav.saturne.validator.report.validationIdAttributeKey");
        List categories = this.report.getContextFields();
        this.writer.writeStartElement("envoi");
        this.writer.writeStartElement("envoi_identification");
        this.writer.writeStartElement("identifiant");
        if (messageID != null) {
            this.writer.writeCharacters(messageID);
        }
        this.writer.writeEndElement();
        String version_norme = "";
        String point_de_depot = "";
        String type_envoi = "";
        String essai_reel = "";
        String emetteur_siren = "";
        String emetteur_nic = "";
        String nom_logiciel = "";
        String editeur_logiciel = "";
        String version_logiciel = "";
        for (ContextField category : categories) {
            if (category.getReportSerializationName().equals("version_norme") && category.getValue().trim() != null) {
                version_norme = category.getValue().trim();
                continue;
            }
            if (category.getReportSerializationName().equals("point_de_depot") && category.getValue().trim() != null) {
                point_de_depot = category.getValue().trim();
                continue;
            }
            if (category.getReportSerializationName().equals("type_envoi") && category.getValue().trim() != null) {
                type_envoi = category.getValue().trim();
                continue;
            }
            if (category.getReportSerializationName().equals("essai_reel") && category.getValue().trim() != null) {
                essai_reel = category.getValue().trim();
                continue;
            }
            if (category.getReportSerializationName().equals("siren") && category.getValue().trim() != null) {
                emetteur_siren = category.getValue().trim();
                continue;
            }
            if (category.getReportSerializationName().equals("nic") && category.getValue().trim() != null) {
                emetteur_nic = category.getValue().trim();
                continue;
            }
            if (category.getReportSerializationName().equals("nom_logiciel") && category.getValue().trim() != null) {
                nom_logiciel = category.getValue().trim();
                continue;
            }
            if (category.getReportSerializationName().equals("editeur_logiciel") && category.getValue().trim() != null) {
                editeur_logiciel = category.getValue().trim();
                continue;
            }
            if (!category.getReportSerializationName().equals("version_logiciel") || category.getValue().trim() == null) continue;
            version_logiciel = category.getValue().trim();
        }
        if (!"".equals(version_norme)) {
            this.writer.writeStartElement("version_norme");
            this.writer.writeCharacters(version_norme);
            this.writer.writeEndElement();
        }
        if (!"".equals(point_de_depot)) {
            this.writer.writeStartElement("point_de_depot");
            this.writer.writeCharacters(point_de_depot);
            this.writer.writeEndElement();
        }
        if (!"".equals(type_envoi)) {
            this.writer.writeStartElement("type_envoi");
            this.writer.writeCharacters(type_envoi);
            this.writer.writeEndElement();
        }
        if (!"".equals(essai_reel)) {
            this.writer.writeStartElement("essai_reel");
            this.writer.writeCharacters(essai_reel);
            this.writer.writeEndElement();
        }
        this.writer.writeStartElement("emetteur_siret");
        this.writer.writeCharacters(String.valueOf(emetteur_siren) + emetteur_nic);
        this.writer.writeEndElement();
        if (!"".equals(nom_logiciel)) {
            this.writer.writeStartElement("nom_logiciel");
            this.writer.writeCharacters(nom_logiciel);
            this.writer.writeEndElement();
        }
        if (!"".equals(editeur_logiciel)) {
            this.writer.writeStartElement("editeur_logiciel");
            this.writer.writeCharacters(editeur_logiciel);
            this.writer.writeEndElement();
        }
        if (!"".equals(editeur_logiciel)) {
            this.writer.writeStartElement("version_logiciel");
            this.writer.writeCharacters(version_logiciel);
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private void serializeEnvoiBilan() throws XMLStreamException {
        List declarations = this.report.getContextChildren();
        int nbAnoDeclaration = 0;
        for (Context context : declarations) {
            nbAnoDeclaration += this.calculateDeclarationAnomaliesNumber(context);
        }
        int nbAnoEnvoi = 0;
        List envoiAnomalies = this.report.getAnomalies();
        for (Anomaly anomaly : envoiAnomalies) {
            nbAnoEnvoi += anomaly.getNumber();
        }
        int nbAnoTotal = nbAnoEnvoi + nbAnoDeclaration;
        this.writer.writeStartElement("envoi_bilan");
        this.writer.writeStartElement("envoi_etat");
        if (this.isReportValid(this.report)) {
            this.writer.writeCharacters("OK");
        } else {
            this.writer.writeCharacters("KO");
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement("envoi_contenu");
        this.writer.writeStartElement("declarations");
        this.writer.writeCharacters(Integer.toString(declarations.size()));
        this.writer.writeEndElement();
        this.writer.writeStartElement("salaries");
        this.writer.writeCharacters(Integer.toString(this.getThirdLevelContextNumber(this.report)));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("envoi_compteurs");
        this.writer.writeStartElement("envoi_categorie");
        this.writer.writeCharacters("generale");
        this.writer.writeEndElement();
        this.writer.writeStartElement("nombre");
        this.writer.writeCharacters(Integer.toString(nbAnoEnvoi));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("envoi_compteurs");
        this.writer.writeStartElement("envoi_categorie");
        this.writer.writeCharacters("declaration");
        this.writer.writeEndElement();
        this.writer.writeStartElement("nombre");
        this.writer.writeCharacters(Integer.toString(nbAnoDeclaration));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("envoi_compteurs");
        this.writer.writeStartElement("envoi_categorie");
        this.writer.writeCharacters("total");
        this.writer.writeEndElement();
        this.writer.writeStartElement("nombre");
        this.writer.writeCharacters(Integer.toString(nbAnoTotal));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private boolean isReportValid(Context reportToCheck) {
        boolean reportIsValid = false;
        if (reportToCheck.isValid()) {
            Iterator iterator = reportToCheck.getContextChildren().iterator();
            while (iterator.hasNext() && !reportIsValid) {
                Context context = (Context)iterator.next();
                this.nbAnoBloquante = 0;
                this.nbAnoNonbloquante = 0;
                this.calculatesBlockingAndNoBlockingAnomaliesNumbers(context, 2);
                if (!context.isValid() || this.nbAnoBloquante != 0) continue;
                reportIsValid = true;
            }
        }
        return reportIsValid;
    }

    private int calculateDeclarationAnomaliesNumber(Context context) {
        int anomaliesNumber = 0;
        List anomalies = context.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            anomaliesNumber += anomaly.getNumber();
        }
        List contextChildren = context.getContextChildren();
        for (Context subContext : contextChildren) {
            anomaliesNumber += this.calculateDeclarationAnomaliesNumber(subContext);
        }
        return anomaliesNumber;
    }

    private int getThirdLevelContextNumber(Context rootContext) {
        List subContexts = rootContext.getContextChildren();
        int thirdLevelContextNumber = 0;
        for (Context subContext : subContexts) {
            thirdLevelContextNumber += subContext.getContextChildren().size();
        }
        return thirdLevelContextNumber;
    }

    private void serializeEnvoiAnomalies() throws XMLStreamException {
        for (Anomaly anomaly : this.report.getAnomalies()) {
            this.writer.writeStartElement("envoi_anomalie");
            this.writer.writeStartElement("description");
            this.writer.writeStartElement("code");
            this.writer.writeCharacters(anomaly.getCode());
            this.writer.writeEndElement();
            this.writer.writeStartElement("categorie");
            if (!anomaly.isBlocking()) {
                this.writer.writeCharacters("non-bloquant");
            } else {
                this.writer.writeCharacters("bloquant");
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement("message");
            this.writer.writeCharacters(anomaly.getMessage());
            this.writer.writeEndElement();
            if (anomaly.getFieldLocalizer().getLineNumber() != 0) {
                this.writer.writeStartElement("numero_ligne");
                this.writer.writeCharacters(Integer.toString(anomaly.getFieldLocalizer().getLineNumber()));
                this.writer.writeEndElement();
            }
            if (anomaly.getNumber() > 1) {
                this.writer.writeStartElement("nombre");
                this.writer.writeCharacters(Integer.toString(anomaly.getNumber()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement("valeurs");
            this.writer.writeStartElement("rubrique_declenchante");
            if (anomaly.getFieldId() != null) {
                this.writer.writeStartElement("identifiant");
                this.writer.writeCharacters(anomaly.getFieldId());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("identifiant");
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (anomaly.getFieldLabel() != null) {
                this.writer.writeStartElement("libelle");
                this.writer.writeCharacters(anomaly.getFieldLabel());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("libelle");
                this.writer.writeCharacters("rubrique inconnue");
                this.writer.writeEndElement();
            }
            if (anomaly.getFieldValue() != null) {
                this.writer.writeStartElement("valeur");
                this.writer.writeCharacters(anomaly.getFieldValue());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("valeur");
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private Map<String, Integer> calculateSubContextNumber(Context context) {
        List contextChildren = context.getContextChildren();
        HashMap<String, Integer> contextSerialisationNameToContextNumber = new HashMap<String, Integer>();
        Set directSubContextSerializationNames = this.reportLogger.geReportContextDescriptor().getDirectSubContextSerializationNames(context);
        for (String directSubContextSerializationName : directSubContextSerializationNames) {
            contextSerialisationNameToContextNumber.put(directSubContextSerializationName, new Integer(0));
        }
        for (Context subcontext : contextChildren) {
            Integer subContextNumber;
            Integer n = subContextNumber = (Integer)contextSerialisationNameToContextNumber.get(subcontext.getName());
            subContextNumber = n + 1;
            contextSerialisationNameToContextNumber.put(subcontext.getName(), n);
        }
        return contextSerialisationNameToContextNumber;
    }

    private void serializeSecondLevelContext(Context secondLevelContext) throws XMLStreamException {
        List categories = secondLevelContext.getContextFields();
        String rangDeclaration = Integer.toString(secondLevelContext.getRank());
        this.nbAnoBloquante = 0;
        this.nbAnoNonbloquante = 0;
        this.calculatesBlockingAndNoBlockingAnomaliesNumbers(secondLevelContext, 2);
        this.writer.writeStartElement(secondLevelContext.getName());
        this.writer.writeStartElement(String.valueOf(secondLevelContext.getName()) + "_identification");
        this.writer.writeStartElement("rang");
        this.writer.writeCharacters(rangDeclaration);
        this.writer.writeEndElement();
        ContextField contextFieldSiren = null;
        ContextField contextFieldNicSiege = null;
        ContextField contextFieldNicAffection = null;
        for (ContextField contextField : categories) {
            if (contextField.getReportSerializationName().equals("nic_siege")) {
                contextFieldNicSiege = contextField;
                continue;
            }
            if (contextField.getReportSerializationName().equals("nic_affectation")) {
                contextFieldNicAffection = contextField;
                continue;
            }
            if (contextField.getReportSerializationName().equals("SIREN")) {
                contextFieldSiren = contextField;
                continue;
            }
            this.writer.writeStartElement(contextField.getReportSerializationName());
            this.writer.writeCharacters(contextField.getValue().trim());
            this.writer.writeEndElement();
        }
        if (contextFieldSiren == null) {
            this.writer.writeStartElement("SIREN");
            this.writer.writeCharacters("");
            this.writer.writeEndElement();
        } else {
            this.writer.writeStartElement(contextFieldSiren.getReportSerializationName());
            this.writer.writeCharacters(contextFieldSiren.getValue().trim());
            this.writer.writeEndElement();
        }
        if (contextFieldNicSiege == null) {
            this.writer.writeStartElement("nic_siege");
            this.writer.writeCharacters("");
            this.writer.writeEndElement();
        } else {
            this.writer.writeStartElement(contextFieldNicSiege.getReportSerializationName());
            this.writer.writeCharacters(contextFieldNicSiege.getValue().trim());
            this.writer.writeEndElement();
        }
        if (contextFieldNicAffection == null) {
            this.writer.writeStartElement("nic_affectation");
            this.writer.writeCharacters("");
            this.writer.writeEndElement();
        } else {
            this.writer.writeStartElement(contextFieldNicAffection.getReportSerializationName());
            this.writer.writeCharacters(contextFieldNicAffection.getValue().trim());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement(String.valueOf(secondLevelContext.getName()) + "_bilan");
        this.writer.writeStartElement("etat");
        if (this.nbAnoBloquante == 0 && secondLevelContext.isValid() && (this.report.getAnomalies().size() <= 0 || !"LIM000".equals(((Anomaly)this.report.getAnomalies().get(this.report.getAnomalies().size() - 1)).getCode()))) {
            this.writer.writeCharacters("OK");
        } else {
            this.writer.writeCharacters("KO");
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement(String.valueOf(secondLevelContext.getName()) + "_contenu");
        Map<String, Integer> reportSerializationNameToNumberInContext = this.calculateSubContextNumber(secondLevelContext);
        if (reportSerializationNameToNumberInContext.isEmpty()) {
            throw new IllegalStateException("The norm model should have a third level context for the second level one.");
        }
        String thirdLevelContextReportSerializationName = reportSerializationNameToNumberInContext.keySet().iterator().next();
        this.writer.writeStartElement(String.valueOf(thirdLevelContextReportSerializationName) + "s");
        this.writer.writeCharacters(Integer.toString(secondLevelContext.getContextChildren().size()));
        this.writer.writeEndElement();
        int nbcontrats = this.getNumberContracts(secondLevelContext);
        if (thirdLevelContextReportSerializationName.equals("salarie")) {
            this.writer.writeStartElement("contrats");
            this.writer.writeCharacters(new Integer(nbcontrats).toString());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement("declaration_compteurs");
        this.writer.writeStartElement("categorie");
        this.writer.writeCharacters("bloquant");
        this.writer.writeEndElement();
        this.writer.writeStartElement("nombre");
        this.writer.writeCharacters(Integer.toString(this.nbAnoBloquante));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("declaration_compteurs");
        this.writer.writeStartElement("categorie");
        this.writer.writeCharacters("non-bloquant");
        this.writer.writeEndElement();
        this.writer.writeStartElement("nombre");
        this.writer.writeCharacters(Integer.toString(this.nbAnoNonbloquante));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        List anomalies = secondLevelContext.getAnomalies();
        Collections.sort(anomalies, new DsnAnomalyComparator());
        for (Anomaly currentAnomaly : anomalies) {
            String codeAnomalie = currentAnomaly.getCode() == null || "".equals(currentAnomaly.getCode()) ? "" : currentAnomaly.getCode();
            String bloquantAnomalie = !currentAnomaly.isBlocking() ? "non-bloquant" : "bloquant";
            String messageAnomalie = currentAnomaly.getMessage() == null || "".equals(currentAnomaly.getMessage()) ? "" : currentAnomaly.getMessage();
            String numeroLigneAnomalie = String.valueOf(currentAnomaly.getFieldLocalizer().getLineNumber());
            this.writer.writeStartElement("declaration_anomalie");
            this.writer.writeStartElement("description");
            this.writer.writeStartElement("code");
            this.writer.writeCharacters(codeAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement("categorie");
            this.writer.writeCharacters(bloquantAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement("message");
            this.writer.writeCharacters(messageAnomalie);
            this.writer.writeEndElement();
            if (!"".equals(numeroLigneAnomalie)) {
                this.writer.writeStartElement("numero_ligne");
                this.writer.writeCharacters(numeroLigneAnomalie);
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getNumber() > 1) {
                this.writer.writeStartElement("nombre");
                this.writer.writeCharacters(Integer.toString(currentAnomaly.getNumber()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement("valeurs");
            this.writer.writeStartElement("rubrique_declenchante");
            if (currentAnomaly.getFieldId() != null) {
                this.writer.writeStartElement("identifiant");
                this.writer.writeCharacters(currentAnomaly.getFieldId());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("identifiant");
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldLabel() != null) {
                this.writer.writeStartElement("libelle");
                this.writer.writeCharacters(currentAnomaly.getFieldLabel());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("libelle");
                this.writer.writeCharacters("rubrique inconnue");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldValue() != null) {
                this.writer.writeStartElement("valeur");
                this.writer.writeCharacters(currentAnomaly.getFieldValue());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("valeur");
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        List employeeContexts = secondLevelContext.getContextChildren();
        for (Context employeeContext : employeeContexts) {
            this.serializesDeclarationAnomalies(thirdLevelContextReportSerializationName, employeeContext, null);
            List contractContexts = employeeContext.getContextChildren();
            for (Context contractContext : contractContexts) {
                this.serializesDeclarationAnomalies(thirdLevelContextReportSerializationName, employeeContext, contractContext);
            }
        }
        this.writer.writeEndElement();
    }

    private void serializesDeclarationAnomalies(String contextReportSerializationName, Context employeeContext, Context contractContext) throws XMLStreamException {
        List employeeContextFields = employeeContext.getContextFields();
        List anomalies = contractContext == null ? employeeContext.getAnomalies() : contractContext.getAnomalies();
        for (Anomaly currentAnomaly : anomalies) {
            String codeAnomalie = currentAnomaly.getCode() == null || "".equals(currentAnomaly.getCode()) ? "" : currentAnomaly.getCode();
            String bloquantAnomalie = !currentAnomaly.isBlocking() ? "non-bloquant" : "bloquant";
            String messageAnomalie = currentAnomaly.getMessage() == null || "".equals(currentAnomaly.getMessage()) ? "" : currentAnomaly.getMessage();
            String numeroLigneAnomalie = String.valueOf(currentAnomaly.getFieldLocalizer().getLineNumber());
            this.writer.writeStartElement("declaration_anomalie");
            this.writer.writeStartElement("description");
            this.writer.writeStartElement("code");
            this.writer.writeCharacters(codeAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement("categorie");
            this.writer.writeCharacters(bloquantAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement("message");
            this.writer.writeCharacters(messageAnomalie);
            this.writer.writeEndElement();
            if (!"".equals(numeroLigneAnomalie)) {
                this.writer.writeStartElement("numero_ligne");
                this.writer.writeCharacters(numeroLigneAnomalie);
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getNumber() > 1) {
                this.writer.writeStartElement("nombre");
                this.writer.writeCharacters(Integer.toString(currentAnomaly.getNumber()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement("valeurs");
            this.writer.writeStartElement("rubrique_declenchante");
            if (currentAnomaly.getFieldId() != null) {
                this.writer.writeStartElement("identifiant");
                this.writer.writeCharacters(currentAnomaly.getFieldId());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("identifiant");
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldLabel() != null) {
                this.writer.writeStartElement("libelle");
                this.writer.writeCharacters(currentAnomaly.getFieldLabel());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("libelle");
                this.writer.writeCharacters("rubrique inconnue");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldValue() != null) {
                this.writer.writeStartElement("valeur");
                this.writer.writeCharacters(currentAnomaly.getFieldValue());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement("valeur");
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            if (currentAnomaly.getFieldId() != null) {
                this.writer.writeStartElement("environnement");
                this.writer.writeStartElement(contextReportSerializationName);
                this.writer.writeAttribute("origine", this.reportLogger.getReport().getNormUri());
                String nir = "";
                String nomUsage = "";
                String nomFamille = "";
                String prenoms = "";
                String sexe = "";
                String dateNaissance = "";
                String lieuNaissance = "";
                String codePays = "";
                String matricule = "";
                String rang = String.valueOf(employeeContext.getRank());
                String ntt = "";
                String dateDebutContrat = "";
                String numeroContrat = "";
                for (ContextField employeeContextField : employeeContextFields) {
                    if (employeeContextField.getReportSerializationName().equals("NIR") && employeeContextField.getValue().trim() != null) {
                        nir = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("nom_usage") && employeeContextField.getValue().trim() != null) {
                        nomUsage = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("nom_famille") && employeeContextField.getValue().trim() != null) {
                        nomFamille = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("prenoms") && employeeContextField.getValue().trim() != null) {
                        prenoms = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("sexe") && employeeContextField.getValue().trim() != null) {
                        sexe = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("date_naissance") && employeeContextField.getValue().trim() != null) {
                        dateNaissance = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("lieu_naissance") && employeeContextField.getValue().trim() != null) {
                        lieuNaissance = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("code_pays") && employeeContextField.getValue().trim() != null) {
                        codePays = employeeContextField.getValue().trim();
                    }
                    if (employeeContextField.getReportSerializationName().equals("matricule") && employeeContextField.getValue().trim() != null) {
                        matricule = employeeContextField.getValue().trim();
                    }
                    if (!employeeContextField.getReportSerializationName().equals("NTT") || employeeContextField.getValue().trim() == null) continue;
                    ntt = employeeContextField.getValue().trim();
                }
                if (contractContext != null) {
                    List contractContextFields = contractContext.getContextFields();
                    for (ContextField field : contractContextFields) {
                        if (field.getReportSerializationName().equals(ConfigurationDsn.REPORT_RUB_SALARIE_DATE_DEBUT_CONTRAT) && field.getValue().trim() != null) {
                            dateDebutContrat = field.getValue().trim();
                        }
                        if (!field.getReportSerializationName().equals(ConfigurationDsn.REPORT_RUB_SALARIE_DATE_NUMERO_CONTRAT) || field.getValue().trim() == null) continue;
                        numeroContrat = field.getValue().trim();
                    }
                }
                if (!"".equals(nir)) {
                    this.writer.writeStartElement("NIR");
                    this.writer.writeCharacters(nir);
                    this.writer.writeEndElement();
                } else if (!"".equals(ntt)) {
                    this.writer.writeStartElement("NTT");
                    this.writer.writeCharacters(ntt);
                    this.writer.writeEndElement();
                } else {
                    this.writer.writeStartElement("NIR");
                    this.writer.writeCharacters("rubrique absente dans le fichier");
                    this.writer.writeEndElement();
                }
                if (!"".equals(nomFamille)) {
                    this.writer.writeStartElement("nom_famille");
                    this.writer.writeCharacters(nomFamille);
                    this.writer.writeEndElement();
                }
                if (!"".equals(nomUsage)) {
                    this.writer.writeStartElement("nom_usage");
                    this.writer.writeCharacters(nomUsage);
                    this.writer.writeEndElement();
                }
                if (!"".equals(prenoms)) {
                    this.writer.writeStartElement("prenoms");
                    this.writer.writeCharacters(prenoms);
                    this.writer.writeEndElement();
                }
                if (!"".equals(sexe)) {
                    this.writer.writeStartElement("sexe");
                    this.writer.writeCharacters(sexe);
                    this.writer.writeEndElement();
                }
                if (!"".equals(dateNaissance)) {
                    this.writer.writeStartElement("date_naissance");
                    this.writer.writeCharacters(dateNaissance);
                    this.writer.writeEndElement();
                }
                if (!"".equals(lieuNaissance)) {
                    this.writer.writeStartElement("lieu_naissance");
                    this.writer.writeCharacters(lieuNaissance);
                    this.writer.writeEndElement();
                }
                if (!"".equals(codePays)) {
                    this.writer.writeStartElement("code_pays");
                    this.writer.writeCharacters(codePays);
                    this.writer.writeEndElement();
                }
                if (!"".equals(matricule)) {
                    this.writer.writeStartElement("matricule");
                    this.writer.writeCharacters(matricule);
                    this.writer.writeEndElement();
                }
                if (!"".equals(rang)) {
                    this.writer.writeStartElement("rang");
                    this.writer.writeCharacters(rang);
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
                if (!"".equals(dateDebutContrat)) {
                    this.writer.writeStartElement("contrat");
                    this.writer.writeStartElement("date_debut_contrat");
                    this.writer.writeCharacters(dateDebutContrat);
                    this.writer.writeEndElement();
                    this.writer.writeStartElement("num_contrat");
                    if (!"".equals(numeroContrat)) {
                        this.writer.writeCharacters(numeroContrat);
                    } else {
                        this.writer.writeCharacters("rubrique absente dans le fichier");
                    }
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
    }

    private void calculatesBlockingAndNoBlockingAnomaliesNumbers(Context secondLevelContext, int level) {
        List anomalies = secondLevelContext.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            if (!anomaly.isBlocking()) {
                this.nbAnoNonbloquante += anomaly.getNumber();
                continue;
            }
            this.nbAnoBloquante += anomaly.getNumber();
        }
        if (level <= 3) {
            List subContexts = secondLevelContext.getContextChildren();
            for (Context context : subContexts) {
                this.calculatesBlockingAndNoBlockingAnomaliesNumbers(context, level + 1);
            }
        }
    }

    private void serializeFooter() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
    }

    private int getNumberContracts(Context declarationContext) {
        List subContexts = declarationContext.getContextChildren();
        int nbcontrat = 0;
        for (Context subContext : subContexts) {
            List contexteNiveauTrois = subContext.getContextChildren();
            for (Context contexte : contexteNiveauTrois) {
                if (!contexte.getblockQualifiedId().equals("S21.G00.40")) continue;
                ++nbcontrat;
            }
        }
        return nbcontrat;
    }
}

