/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.common;

import fr.cnav.saturne.dsl.runtime.BuiltinFunctions;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Objects;

public class ExternalFunctions {
    public static boolean isSiren(String value) {
        return value == null ? true : ExternalFunctions.isLuhnValid(value, 9);
    }

    public static boolean isSiren(IMessageFieldAlphanum value) {
        return ExternalFunctions.isSiren(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)value));
    }

    public static boolean isSiret_WithSirenNic(String siren, String nic) {
        if (siren != null && nic != null) {
            return ExternalFunctions.isSiret(String.valueOf(siren) + nic);
        }
        return true;
    }

    public static boolean isSiret_WithSirenNic(IMessageFieldAlphanum siren, IMessageFieldAlphanum nic) {
        return ExternalFunctions.isSiret_WithSirenNic(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)siren), BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)nic));
    }

    public static boolean isSiret(String siret) {
        if (siret != null) {
            boolean retVal = ExternalFunctions.isLuhnValid(siret, 14);
            if (!retVal && siret.startsWith("356000000")) {
                int sum = 0;
                int i = 0;
                while (i < siret.length()) {
                    sum += Character.digit(siret.charAt(i), 10);
                    ++i;
                }
                retVal = sum % 5 == 0;
            }
            return retVal;
        }
        return true;
    }

    public static boolean isSiret(IMessageFieldAlphanum siret) {
        return ExternalFunctions.isSiret(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)siret));
    }

    public static boolean isSiretAgircArrco(String siret) {
        return siret == null ? false : ExternalFunctions.isSiret(siret) && siret.startsWith("442542023");
    }

    public static boolean isSiretCAMIEG(String siret) {
        return siret == null ? false : siret.equals("49914777500013");
    }

    public static boolean isSiretCCVRP(String siret) {
        return siret == null ? false : siret.equals("78480958400013");
    }

    public static boolean isSiretCNIEG(String siret) {
        return siret == null ? false : siret.equals("47865038500014");
    }

    public static boolean isSiretCRPCEN(String siret) {
        return siret == null ? false : siret.equals("77567188600064");
    }

    public static boolean isSiretCRPNPAC(String siret) {
        return siret == null ? false : siret.equals("78542230400192");
    }

    public static boolean isSiretPoleEmploi(String siret) {
        return siret == null ? false : ExternalFunctions.isSiret(siret) && siret.startsWith("130005481");
    }

    public static boolean isSiretIRCANTEC(String siret) {
        return siret == null ? false : ExternalFunctions.isSiret(siret) && siret.startsWith("784301525");
    }

    public static boolean isSiretCongesSpectacle(String siret) {
        return siret == null ? false : ExternalFunctions.isSiret(siret) && siret.startsWith("448323758");
    }

    public static boolean isDsnBirthday(String date) {
        boolean retVal = false;
        if (date != null && date.length() >= 4) {
            try {
                int birthYear = Integer.parseInt(date.substring(4));
                Calendar curDate = GregorianCalendar.getInstance();
                int curYear = curDate.get(1);
                retVal = curYear - 120 < birthYear && birthYear <= curYear;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static boolean isDsnBirthday(IMessageFieldAlphanum date) {
        return ExternalFunctions.isDsnBirthday(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date));
    }

    public static boolean isDsnBirthdayDate(Date date) {
        boolean retVal = false;
        if (date != null) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                int birthYear = cal.get(1);
                Calendar curDate = GregorianCalendar.getInstance();
                int curYear = curDate.get(1);
                retVal = curYear - 120 < birthYear && birthYear <= curYear;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return retVal;
    }

    public static boolean isDsnBirthdayDate(IMessageFieldDate date) {
        return ExternalFunctions.isDsnBirthdayDate(BuiltinFunctions.getValueOfMessageFieldDate((IMessageFieldDate)date));
    }

    public static boolean alternateOverlap(Date d1, Date f11, Date f12, Date d2, Date f21, Date f22) {
        if (!(d1 == null || d2 == null || f11 == null && f12 == null || f21 == null && f22 == null)) {
            return BuiltinFunctions.overlapPeriod((Date)d1, (Date)(f11 == null ? f12 : f11), (Date)d2, (Date)(f21 == null ? f22 : f21));
        }
        return false;
    }

    private static char getEmployLabelValue(char c) {
        return c == 'i' ? Character.toUpperCase(c) : c;
    }

    public static boolean isEmployLabel(String label) {
        boolean retVal = true;
        if (label != null && label.length() > 0) {
            char m = ExternalFunctions.getEmployLabelValue(label.charAt(0));
            retVal = Character.isLetterOrDigit(m);
            int i = 1;
            int repeatCount = 1;
            while (retVal && i < label.length()) {
                char c = ExternalFunctions.getEmployLabelValue(label.charAt(i));
                if (c == m && !Character.isDigit(c)) {
                    retVal = ++repeatCount <= (m == 'I' ? 3 : 2);
                } else {
                    m = c;
                    repeatCount = 1;
                }
                ++i;
            }
        }
        return retVal;
    }

    public static boolean isEmployLabel(IMessageFieldAlphanum label) {
        return ExternalFunctions.isEmployLabel(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)label));
    }

    public static String toLowerCase(String value) {
        if (value == null || value.equalsIgnoreCase("")) {
            return "";
        }
        return value.toLowerCase();
    }

    public static String toLowerCase(IMessageFieldAlphanum value) {
        return ExternalFunctions.toLowerCase(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)value));
    }

    public static boolean isIban(String iban) {
        boolean retVal = true;
        if (iban != null) {
            String countryCode = iban.substring(0, 2);
            int expectedLength = ExternalFunctions.getExpectedLengthByCountry(countryCode);
            boolean bl = retVal = iban.length() == expectedLength;
            if (retVal) {
                char currentChar;
                StringBuilder dgIban = new StringBuilder(iban.length());
                char[] cArray = iban.substring(4).toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    currentChar = cArray[n2];
                    int value = Character.digit(currentChar, 36);
                    if (value >= 0) {
                        dgIban.append(value);
                    }
                    ++n2;
                }
                cArray = iban.substring(0, 4).toCharArray();
                n = cArray.length;
                n2 = 0;
                while (n2 < n) {
                    currentChar = cArray[n2];
                    dgIban.append(Character.digit(currentChar, 36));
                    ++n2;
                }
                retVal = new BigDecimal(dgIban.toString()).remainder(new BigDecimal(97)).intValue() == 1;
            }
        }
        return retVal;
    }

    public static boolean isIban(IMessageFieldAlphanum iban) {
        return ExternalFunctions.isIban(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)iban));
    }

    private static int getExpectedLengthByCountry(String countryCode) {
        switch (countryCode) {
            case "AL": {
                return 28;
            }
            case "DE": {
                return 22;
            }
            case "AD": {
                return 24;
            }
            case "AT": {
                return 20;
            }
            case "AZ": {
                return 28;
            }
            case "BE": {
                return 16;
            }
            case "BA": {
                return 20;
            }
            case "BG": {
                return 22;
            }
            case "CY": {
                return 28;
            }
            case "HR": {
                return 21;
            }
            case "DK": {
                return 18;
            }
            case "ES": {
                return 24;
            }
            case "EE": {
                return 20;
            }
            case "FI": {
                return 18;
            }
            case "FR": {
                return 27;
            }
            case "GI": {
                return 23;
            }
            case "GR": {
                return 27;
            }
            case "GP": {
                return 27;
            }
            case "GF": {
                return 27;
            }
            case "GE": {
                return 22;
            }
            case "HU": {
                return 28;
            }
            case "IE": {
                return 22;
            }
            case "IS": {
                return 26;
            }
            case "IT": {
                return 27;
            }
            case "XK": {
                return 20;
            }
            case "LV": {
                return 21;
            }
            case "LI": {
                return 21;
            }
            case "LT": {
                return 20;
            }
            case "LU": {
                return 20;
            }
            case "MK": {
                return 19;
            }
            case "MT": {
                return 31;
            }
            case "MQ": {
                return 27;
            }
            case "YT": {
                return 27;
            }
            case "MC": {
                return 27;
            }
            case "MD": {
                return 24;
            }
            case "ME": {
                return 22;
            }
            case "NO": {
                return 15;
            }
            case "NC": {
                return 27;
            }
            case "NL": {
                return 18;
            }
            case "PL": {
                return 28;
            }
            case "PF": {
                return 27;
            }
            case "RE": {
                return 27;
            }
            case "PM": {
                return 27;
            }
            case "PT": {
                return 25;
            }
            case "CZ": {
                return 24;
            }
            case "RO": {
                return 24;
            }
            case "GB": {
                return 22;
            }
            case "SM": {
                return 27;
            }
            case "RS": {
                return 22;
            }
            case "SK": {
                return 24;
            }
            case "SI": {
                return 19;
            }
            case "SE": {
                return 24;
            }
            case "CH": {
                return 21;
            }
            case "TR": {
                return 26;
            }
            case "TF": {
                return 27;
            }
            case "UA": {
                return 29;
            }
            case "VA": {
                return 22;
            }
            case "FO": {
                return 18;
            }
            case "VG": {
                return 24;
            }
            case "WF": {
                return 27;
            }
        }
        return -1;
    }

    public static boolean isBban(String iban) {
        boolean retVal = true;
        if (iban != null) {
            boolean bl = retVal = iban.length() > 4;
            if (retVal && iban.startsWith("FR")) {
                StringBuilder extendedRib = new StringBuilder(iban.length());
                char[] cArray = iban.substring(4).toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char currentChar = cArray[n2];
                    int value = Character.digit(currentChar, 36);
                    if (value >= 0) {
                        if (value > 0) {
                            if (value > 27) {
                                ++value;
                            }
                            if ((value %= 9) == 0) {
                                value = 9;
                            }
                        }
                        extendedRib.append(value);
                    }
                    ++n2;
                }
                retVal = new BigDecimal(extendedRib.toString()).remainder(new BigDecimal(97)).intValue() == 0;
            }
        }
        return retVal;
    }

    public static boolean isBban(IMessageFieldAlphanum iban) {
        return ExternalFunctions.isBban(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)iban));
    }

    public static boolean isDate(String date) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
            sdf.setLenient(false);
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean isDate(IMessageFieldAlphanum date) {
        return ExternalFunctions.isDate(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date));
    }

    public static boolean notEmptyDate(Date date) {
        return date != null;
    }

    public static boolean notEmptyDate(IMessageFieldDate date) {
        return ExternalFunctions.notEmptyDate(BuiltinFunctions.getValueOfMessageFieldDate((IMessageFieldDate)date));
    }

    public static boolean isValidPeriodeAffectationCode(String code, Date dtRef) {
        if (code != null && code.length() == 7 && dtRef != null) {
            dtRef = BuiltinFunctions.dayAfter((Date)BuiltinFunctions.lastDayOfMonth((Date)dtRef));
            String cmpVal = String.valueOf(BuiltinFunctions.yearFromDate((Date)dtRef).toString()) + code.charAt(4);
            switch (code.charAt(4)) {
                case 'A': 
                case 'E': {
                    cmpVal = String.valueOf(cmpVal) + "00";
                    break;
                }
                case 'M': {
                    cmpVal = String.valueOf(cmpVal) + BuiltinFunctions.month((Date)dtRef);
                    break;
                }
                case 'S': {
                    cmpVal = String.valueOf(cmpVal) + (BuiltinFunctions.month((Date)dtRef).compareTo("06") <= 0 ? "01" : "02");
                    break;
                }
                case 'T': {
                    String mois = BuiltinFunctions.month((Date)dtRef);
                    cmpVal = mois.compareTo("03") <= 0 ? String.valueOf(cmpVal) + "01" : (mois.compareTo("06") <= 0 ? String.valueOf(cmpVal) + "02" : String.valueOf(cmpVal) + (mois.compareTo("09") <= 0 ? "03" : "04"));
                }
            }
            return cmpVal.length() == 7 && code.compareTo(cmpVal) <= 0;
        }
        return false;
    }

    public static boolean isValidPeriodeAffectationCode(IMessageFieldAlphanum code, IMessageFieldDate dtRef) {
        return ExternalFunctions.isValidPeriodeAffectationCode(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)code), BuiltinFunctions.getValueOfMessageFieldDate((IMessageFieldDate)dtRef));
    }

    public static boolean isCodeOrganismeNonFedere(String code) {
        if (code != null && code.length() == 9 && code.matches("[0-9A-Za-z]{9}")) {
            char[] cArray = code.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (Character.isLetter(c)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isCodeOrganismeNonFedere(IMessageFieldAlphanum code) {
        return ExternalFunctions.isCodeOrganismeNonFedere(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)code));
    }

    public static boolean isLuhnValid(String value, int count) {
        if (value == null) {
            return true;
        }
        if (value.length() >= count) {
            int val;
            int sum = 0;
            int i = count - 1;
            while (i >= 0) {
                val = Character.digit(value.charAt(i), 10);
                if (val < 0) {
                    return false;
                }
                sum += val;
                i -= 2;
            }
            i = count - 2;
            while (i >= 0) {
                val = Character.digit(value.charAt(i), 10) * 2;
                if (val < 0) {
                    return false;
                }
                sum += val > 9 ? val - 9 : val;
                i -= 2;
            }
            return sum == 0 ? false : sum % 10 == 0;
        }
        return false;
    }

    public static boolean overlapPeriodExt(Date deb1, Date fin1, Date deb2, Date fin2) {
        if (deb1 == null || fin1 == null || deb2 == null || fin2 == null) {
            return false;
        }
        if (deb1.compareTo(fin1) > 0 || deb2.compareTo(fin2) > 0) {
            return false;
        }
        return deb1.compareTo(fin2) <= 0 && deb2.compareTo(fin1) <= 0;
    }

    public static BigDecimal sigma_external(Iterable<? extends IMessageFieldNum> nums) {
        if (nums == null) {
            return BigDecimal.valueOf(0L);
        }
        Iterator<? extends IMessageFieldNum> iterator = nums.iterator();
        if (!iterator.hasNext()) {
            return BigDecimal.valueOf(0L);
        }
        double sum = 0.0;
        for (IMessageFieldNum iMessageFieldNum : nums) {
            sum += ((BigDecimal)iMessageFieldNum.getValue()).doubleValue();
        }
        return BigDecimal.valueOf(sum);
    }

    public static Date stringToDate(String date) {
        Date stDate = new Date();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
            sdf.setLenient(false);
            stDate = sdf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return stDate;
    }

    public static Date stringToDate(IMessageFieldAlphanum date) {
        return ExternalFunctions.stringToDate(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date));
    }

    public static boolean isDateMMAAAALaterOrEqual(String date1, String date2) {
        if (date1.length() != 6 || date2.length() != 6) {
            return false;
        }
        try {
            int mois1 = Integer.parseInt(date1.substring(0, 2));
            int mois2 = Integer.parseInt(date2.substring(0, 2));
            int annee1 = Integer.parseInt(date1.substring(2, 6));
            int annee2 = Integer.parseInt(date2.substring(2, 6));
            if (annee1 == annee2) {
                return mois1 > mois2;
            }
            return annee1 > annee2;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isDateMMAAAALaterOrEqual(IMessageFieldAlphanum date1, IMessageFieldAlphanum date2) {
        return ExternalFunctions.isDateMMAAAALaterOrEqual(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date1), BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date2));
    }

    public static boolean isDateMMAAAALaterOrEqual(IMessageFieldAlphanum date1, String date2) {
        return ExternalFunctions.isDateMMAAAALaterOrEqual(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date1), date2);
    }

    public static boolean isDateMMAAAALaterOrEqual(String date1, IMessageFieldAlphanum date2) {
        return ExternalFunctions.isDateMMAAAALaterOrEqual(date1, BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date2));
    }

    public static boolean isDateMMYYYY(String date) {
        if (date.length() != 6) {
            return false;
        }
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("MMyyyy");
            sdf.setLenient(false);
            sdf.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public static boolean isDateMMYYYY(IMessageFieldAlphanum date) {
        return ExternalFunctions.isDateMMYYYY(BuiltinFunctions.getValueOfMessageFieldAlphanum((IMessageFieldAlphanum)date));
    }

    public static boolean otherFieldinConteneur(IMessageBlock conteneur, String rub1, String rub2) {
        Objects.requireNonNull(rub1);
        Objects.requireNonNull(rub2);
        for (IMessageField field : conteneur.getFields()) {
            if (rub1.equals(field.getStandardFieldDescription().getFullQualifiedId()) || rub2.equals(field.getStandardFieldDescription().getFullQualifiedId())) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInExternalRefConcat(String referentialNameCol1, String referentialNameCol2, String value) {
        String columnId1 = null;
        String columnId2 = null;
        String fileName1 = null;
        String fileName2 = null;
        String dataSourcePath = "n4ds/dsn/p03v01/all/datasources/";
        if (!referentialNameCol1.contains("#")) return false;
        if (!referentialNameCol2.contains("#")) return false;
        int colmnIdSep = referentialNameCol1.indexOf(35);
        columnId1 = referentialNameCol1.substring(colmnIdSep + 1);
        columnId2 = referentialNameCol2.substring(colmnIdSep + 1);
        try {
            Integer.parseInt(columnId1);
            Integer.parseInt(columnId2);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int fileNameStart = 0;
        if (referentialNameCol1.startsWith("csv://") && referentialNameCol2.startsWith("csv://")) {
            fileNameStart = "csv://".length();
        }
        fileName1 = referentialNameCol1.substring(fileNameStart, colmnIdSep);
        fileName2 = referentialNameCol2.substring(fileNameStart, colmnIdSep);
        if (!fileName1.endsWith(".csv") && !fileName2.endsWith(".csv")) {
            fileName1 = String.valueOf(fileName1) + ".csv";
        }
        String filePath = String.valueOf(dataSourcePath) + fileName1;
        InputStream dataSource = ExternalFunctions.class.getClassLoader().getResourceAsStream(filePath);
        try {
            Throwable throwable = null;
            Object var11_17 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(dataSource, Charset.forName("UTF-8")));){
                String line;
                String[] values;
                br.readLine();
                do {
                    if ((line = br.readLine()) != null) continue;
                    return false;
                } while (!BuiltinFunctions.concat((String)(values = line.split(";"))[Integer.parseInt(columnId1) - 1], (String)values[Integer.parseInt(columnId2) - 1]).contentEquals(value));
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static BigDecimal monthBetween(IMessageFieldDate dateInf, IMessageFieldDate dateSup) {
        boolean isEndOfMonth;
        LocalDate date1 = ((Date)dateInf.getValue()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate date2 = ((Date)dateSup.getValue()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long fullMonths = ChronoUnit.MONTHS.between(date1, date2);
        LocalDate adjustedDate1 = date1.plusMonths(fullMonths);
        long extraDays = ChronoUnit.DAYS.between(adjustedDate1, date2);
        boolean bl = isEndOfMonth = date2.getDayOfMonth() == date2.lengthOfMonth();
        if (isEndOfMonth) {
            return BigDecimal.valueOf(fullMonths + 1L);
        }
        int daysInMonth = adjustedDate1.lengthOfMonth();
        BigDecimal fraction = BigDecimal.valueOf(extraDays).divide(BigDecimal.valueOf(daysInMonth), 2, 4);
        return BigDecimal.valueOf(fullMonths).add(fraction);
    }

    public static boolean annuleRemplace(IMessageBlock decl1, IMessageBlock decl2) {
        String siret2;
        ArrayList<String> typeAnnule = new ArrayList<String>();
        typeAnnule.add("03");
        typeAnnule.add("04");
        typeAnnule.add("05");
        String type1 = decl1.getField(1).getValueAsString();
        String type2 = decl2.getField(1).getValueAsString();
        String type3 = decl1.getField(2).getValueAsString();
        if (!typeAnnule.contains(type1) && !typeAnnule.contains(type2)) {
            return false;
        }
        if (typeAnnule.contains(type1) && typeAnnule.contains(type2)) {
            return false;
        }
        ArrayList entreprise1 = (ArrayList)decl1.getBlock(3);
        ArrayList entreprise2 = (ArrayList)decl2.getBlock(3);
        IMessageBlock ent1 = (IMessageBlock)entreprise1.get(0);
        IMessageBlock ent2 = (IMessageBlock)entreprise2.get(0);
        IMessageField siren1 = ent1.getField(0);
        IMessageField siren2 = ent2.getField(0);
        ArrayList etablissement1 = (ArrayList)ent1.getBlock(1);
        ArrayList etablissement2 = (ArrayList)ent2.getBlock(1);
        IMessageBlock eta1 = (IMessageBlock)etablissement1.get(0);
        IMessageBlock eta2 = (IMessageBlock)etablissement2.get(0);
        IMessageField nic1 = eta1.getField(0);
        IMessageField nic2 = eta2.getField(0);
        String siret1 = siren1.getValueAsString().concat(nic1.getValueAsString());
        if (!siret1.equalsIgnoreCase(siret2 = siren2.getValueAsString().concat(nic2.getValueAsString()))) {
            return false;
        }
        ArrayList listeIndiv1 = (ArrayList)eta1.getBlock(6);
        ArrayList listeIndiv2 = (ArrayList)eta2.getBlock(6);
        if (listeIndiv1.size() != listeIndiv2.size()) {
            return false;
        }
        ArrayList<IMessageBlock> listeContrat1 = new ArrayList();
        ArrayList<IMessageBlock> listeContrat2 = new ArrayList();
        for (IMessageBlock i1 : listeIndiv1) {
            for (IMessageBlock i2 : listeIndiv2) {
                if (!ExternalFunctions.isEquaIndiv(i1, i2) || !ExternalFunctions.isSameContratList(listeContrat1 = ExternalFunctions.getContratFromInd(i1), listeContrat2 = ExternalFunctions.getContratFromInd(i2))) continue;
                return true;
            }
        }
        return listeIndiv1.isEmpty() && listeIndiv2.isEmpty();
    }

    private static boolean isEquaIndiv(IMessageBlock indiv1, IMessageBlock indiv2) {
        if (indiv1.getField(0) != null && indiv2.getField(0) != null && !indiv1.getField(0).getValueAsString().equalsIgnoreCase(indiv2.getField(0).getValueAsString())) {
            return false;
        }
        return (indiv1.getField(0) != null || indiv2.getField(0) == null) && (indiv1.getField(0) == null || indiv2.getField(0) != null);
    }

    private static ArrayList<IMessageBlock> getContratFromInd(IMessageBlock indiv) {
        ArrayList listeContrat = new ArrayList();
        listeContrat = (ArrayList)indiv.getBlock(2);
        return listeContrat;
    }

    private static boolean isSameContratList(ArrayList<IMessageBlock> listeContrat1, ArrayList<IMessageBlock> listeContrat2) {
        if (listeContrat1.size() != listeContrat2.size()) {
            return false;
        }
        for (IMessageBlock c1 : listeContrat1) {
            int i = c1.getAllFieldsSize();
            c1.getField(0);
            for (IMessageBlock c2 : listeContrat2) {
                if (c1.getField(0) == null || c2.getField(0) == null || !c1.getField(0).getValueAsString().equalsIgnoreCase(c2.getField(0).getValueAsString())) continue;
                return true;
            }
        }
        if (listeContrat1 == null && listeContrat2 == null) {
            return true;
        }
        return listeContrat1.isEmpty() && listeContrat2.isEmpty();
    }
}

