/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.p03v01.all;

import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.functions.ValidationFunctions;
import fr.cnav.saturne.validator.impl.FormatType;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.report.impl.GenericReportLogger;
import fr.cnav.saturne.validator.report.impl.GenericXMLReportSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import n4ds.dsn.p03v01.all.KBDescriptorWithCleaner;

public class ApiValidation {
    private ValidationFunctions validationFunction;
    private OptionMap optionsMap;
    private KBDescriptorWithCleaner kbDescriptor = new KBDescriptorWithCleaner();

    public ApiValidation() throws IOException, URISyntaxException {
        this.optionsMap = this.kbDescriptor.getOptions();
    }

    public IReportLogger initReportLogger() {
        return new GenericReportLogger(this.kbDescriptor.getModelAccessor().getStandard(), true, this.optionsMap);
    }

    public KBDescriptorWithCleaner getKBDescriptor() {
        return this.kbDescriptor;
    }

    public OptionMap getOptionsMap() {
        return this.optionsMap;
    }

    public IReportLogger run(InputStream msgInputStream) throws TooManyAnomaliesException, ValidationFunctionException {
        if (this.validationFunction == null) {
            this.validationFunction = new ValidationFunctions(new ControlMessages(this.kbDescriptor.getResourceBundle()), this.optionsMap, (AbstractKBDescriptor)this.kbDescriptor);
        }
        IReportLogger reportlogger = this.initReportLogger();
        Boolean validateSyntactic = true;
        Boolean validateSyntacticInOptionMap = (Boolean)this.optionsMap.getOption(new Key("enable.syntactic.validation"));
        if (validateSyntacticInOptionMap != null) {
            validateSyntactic = validateSyntacticInOptionMap;
        }
        Boolean validateSemantic = true;
        Boolean validateSemanticInOptionMap = (Boolean)this.optionsMap.getOption(new Key("enable.semantic.validation"));
        if (validateSemanticInOptionMap != null) {
            validateSemantic = validateSemanticInOptionMap;
        }
        this.validationFunction.validateOnePassFromText(msgInputStream, reportlogger, validateSyntactic.booleanValue(), validateSemantic.booleanValue(), FormatType.TXT);
        return reportlogger;
    }

    public void run(InputStream msgInputStream, OutputStream reportOutput) throws TooManyAnomaliesException, ValidationFunctionException, IOException {
        IReportLogger reportlogger = this.run(msgInputStream);
        IReportSerializer serializer = (IReportSerializer)this.kbDescriptor.getOptions().getOption(new Key("fr.cnav.saturne.validator.validationSerializer"));
        if (serializer == null) {
            serializer = new GenericXMLReportSerializer();
        }
        this.validationFunction.writeReport(reportOutput, reportlogger, serializer);
    }
}

